/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest;

import com.amazon.randomcutforest.AbstractForestTraversalExecutor;
import com.amazon.randomcutforest.MultiVisitor;
import com.amazon.randomcutforest.TreeUpdater;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.returntypes.ConvergingAccumulator;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.ArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

public class SequentialForestTraversalExecutor
extends AbstractForestTraversalExecutor {
    public SequentialForestTraversalExecutor(ArrayList<TreeUpdater> treeUpdaters) {
        super(treeUpdaters);
    }

    @Override
    protected void update(double[] pointCopy, long sequenceIndex) {
        this.treeUpdaters.forEach(updater -> updater.update(pointCopy, sequenceIndex));
    }

    @Override
    public <R, S> S traverseForest(double[] point, Function<RandomCutTree, Visitor<R>> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        Object unnormalizedResult = this.treeUpdaters.stream().map(TreeUpdater::getTree).map(tree -> {
            Visitor visitor = (Visitor)visitorFactory.apply((RandomCutTree)tree);
            return tree.traverseTree(point, visitor);
        }).reduce(accumulator).orElseThrow(() -> new IllegalStateException("accumulator returned an empty result"));
        return finisher.apply(unnormalizedResult);
    }

    @Override
    public <R, S> S traverseForest(double[] point, Function<RandomCutTree, Visitor<R>> visitorFactory, Collector<R, ?, S> collector) {
        return this.treeUpdaters.stream().map(TreeUpdater::getTree).map(tree -> {
            Visitor visitor = (Visitor)visitorFactory.apply((RandomCutTree)tree);
            return tree.traverseTree(point, visitor);
        }).collect(collector);
    }

    @Override
    public <R, S> S traverseForest(double[] point, Function<RandomCutTree, Visitor<R>> visitorFactory, ConvergingAccumulator<R> accumulator, Function<R, S> finisher) {
        for (TreeUpdater treeUpdater : this.treeUpdaters) {
            RandomCutTree tree = treeUpdater.getTree();
            Visitor<R> visitor = visitorFactory.apply(tree);
            accumulator.accept(tree.traverseTree(point, visitor));
            if (!accumulator.isConverged()) continue;
            break;
        }
        return finisher.apply(accumulator.getAccumulatedValue());
    }

    @Override
    public <R, S> S traverseForestMulti(double[] point, Function<RandomCutTree, MultiVisitor<R>> visitorFactory, BinaryOperator<R> accumulator, Function<R, S> finisher) {
        Object unnormalizedResult = this.treeUpdaters.stream().map(TreeUpdater::getTree).map(tree -> {
            MultiVisitor visitor = (MultiVisitor)visitorFactory.apply((RandomCutTree)tree);
            return tree.traverseTreeMulti(point, visitor);
        }).reduce(accumulator).orElseThrow(() -> new IllegalStateException("accumulator returned an empty result"));
        return finisher.apply(unnormalizedResult);
    }

    @Override
    public <R, S> S traverseForestMulti(double[] point, Function<RandomCutTree, MultiVisitor<R>> visitorFactory, Collector<R, ?, S> collector) {
        return this.treeUpdaters.stream().map(TreeUpdater::getTree).map(tree -> {
            MultiVisitor visitor = (MultiVisitor)visitorFactory.apply((RandomCutTree)tree);
            return tree.traverseTreeMulti(point, visitor);
        }).collect(collector);
    }
}

