# mypy-boto3-accessanalyzer

[![PyPI - mypy-boto3-accessanalyzer](https://img.shields.io/pypi/v/mypy-boto3-accessanalyzer.svg?color=blue)](https://pypi.org/project/mypy-boto3-accessanalyzer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-accessanalyzer.svg?color=blue)](https://pypi.org/project/mypy-boto3-accessanalyzer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.AccessAnalyzer 1.15.18](https://boto3.amazonaws.com/v1/documentation/api/1.15.18/reference/services/accessanalyzer.html#AccessAnalyzer) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-accessanalyzer](#mypy-boto3-accessanalyzer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `AccessAnalyzer` service.

```bash
python -m pip install boto3-stubs[accessanalyzer]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[accessanalyzer]` in your environment: `python -m pip install 'boto3-stubs[accessanalyzer]'`

Both type checking and auto-complete should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[accessanalyzer]` in your environment: `python -m pip install 'boto3-stubs[accessanalyzer]'`

Both type checking and auto-complete should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[accessanalyzer]` in your environment: `python -m pip install 'boto3-stubs[accessanalyzer]'`
- Run `mypy` as usual

Type checking should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[accessanalyzer]` in your environment: `python -m pip install 'boto3-stubs[accessanalyzer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `AccessAnalyzer` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`AccessAnalyzerClient` provides annotations for `boto3.client("accessanalyzer")`.

```python
import boto3

from mypy_boto3_accessanalyzer import AccessAnalyzerClient

client: AccessAnalyzerClient = boto3.client("accessanalyzer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AccessAnalyzerClient = session.client("accessanalyzer")
```

### Paginators annotations

`mypy_boto3_accessanalyzer.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_accessanalyzer import AccessAnalyzerClient
from mypy_boto3_accessanalyzer.paginator import (
    ListAnalyzedResourcesPaginator,
    ListAnalyzersPaginator,
    ListArchiveRulesPaginator,
    ListFindingsPaginator,
)

client: AccessAnalyzerClient = boto3.client("accessanalyzer")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_analyzed_resources_paginator: ListAnalyzedResourcesPaginator = client.get_paginator("list_analyzed_resources")
list_analyzers_paginator: ListAnalyzersPaginator = client.get_paginator("list_analyzers")
list_archive_rules_paginator: ListArchiveRulesPaginator = client.get_paginator("list_archive_rules")
list_findings_paginator: ListFindingsPaginator = client.get_paginator("list_findings")
```







### Typed dictionations

`mypy_boto3_accessanalyzer.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_accessanalyzer.type_defs import (
    AnalyzedResourceSummaryTypeDef,
    AnalyzedResourceTypeDef,
    AnalyzerSummaryTypeDef,
    ArchiveRuleSummaryTypeDef,
    CreateAnalyzerResponseTypeDef,
    CriterionTypeDef,
    FindingSourceDetailTypeDef,
    FindingSourceTypeDef,
    FindingSummaryTypeDef,
    FindingTypeDef,
    GetAnalyzedResourceResponseTypeDef,
    GetAnalyzerResponseTypeDef,
    GetArchiveRuleResponseTypeDef,
    GetFindingResponseTypeDef,
    InlineArchiveRuleTypeDef,
    ListAnalyzedResourcesResponseTypeDef,
    ListAnalyzersResponseTypeDef,
    ListArchiveRulesResponseTypeDef,
    ListFindingsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    SortCriteriaTypeDef,
    StatusReasonTypeDef,
)

def get_structure() -> AnalyzedResourceSummaryTypeDef:
    return {
      ...
    }
```
