"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('masterNode', RosInstance_MasterNodePropertyValidator)(properties.masterNode));
    if (properties.description && (Array.isArray(properties.description) || (typeof properties.description) === 'string')) {
        errors.collect(ros.propertyValidator('description', ros.validateLength)({
            data: properties.description.length,
            min: undefined,
            max: 30,
        }));
    }
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('privateWhitelist', ros.listValidator(ros.validateAny))(properties.privateWhitelist));
    errors.collect(ros.propertyValidator('publicWhitelist', ros.listValidator(ros.validateAny))(properties.publicWhitelist));
    errors.collect(ros.propertyValidator('version', ros.requiredValidator)(properties.version));
    errors.collect(ros.propertyValidator('version', ros.validateString)(properties.version));
    errors.collect(ros.propertyValidator('dataNode', ros.requiredValidator)(properties.dataNode));
    errors.collect(ros.propertyValidator('dataNode', RosInstance_DataNodePropertyValidator)(properties.dataNode));
    if (properties.instanceChargeType && (typeof properties.instanceChargeType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceChargeType', ros.validateAllowedValues)({
            data: properties.instanceChargeType,
            allowedValues: ["PrePaid", "PostPaid"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceChargeType', ros.validateString)(properties.instanceChargeType));
    errors.collect(ros.propertyValidator('vSwitchId', ros.requiredValidator)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('vSwitchId', ros.validateString)(properties.vSwitchId));
    errors.collect(ros.propertyValidator('kibanaWhitelist', ros.listValidator(ros.validateAny))(properties.kibanaWhitelist));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    errors.collect(ros.propertyValidator('password', ros.requiredValidator)(properties.password));
    errors.collect(ros.propertyValidator('password', ros.validateString)(properties.password));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DataNode: rosInstanceDataNodePropertyToRosTemplate(properties.dataNode),
        Password: ros.stringToRosTemplate(properties.password),
        Version: ros.stringToRosTemplate(properties.version),
        VSwitchId: ros.stringToRosTemplate(properties.vSwitchId),
        Description: ros.stringToRosTemplate(properties.description),
        InstanceChargeType: ros.stringToRosTemplate(properties.instanceChargeType),
        KibanaWhitelist: ros.listMapper(ros.objectToRosTemplate)(properties.kibanaWhitelist),
        MasterNode: rosInstanceMasterNodePropertyToRosTemplate(properties.masterNode),
        Period: ros.numberToRosTemplate(properties.period),
        PrivateWhitelist: ros.listMapper(ros.objectToRosTemplate)(properties.privateWhitelist),
        PublicWhitelist: ros.listMapper(ros.objectToRosTemplate)(properties.publicWhitelist),
    };
}
/**
 * A ROS template type:  `ALIYUN::ElasticSearch::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::ElasticSearch::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDomain = ros.Token.asString(this.getAtt('Domain'));
        this.attrInstanceId = ros.Token.asString(this.getAtt('InstanceId'));
        this.attrKibanaDomain = ros.Token.asString(this.getAtt('KibanaDomain'));
        this.attrKibanaPort = ros.Token.asString(this.getAtt('KibanaPort'));
        this.attrPort = ros.Token.asString(this.getAtt('Port'));
        this.attrStatus = ros.Token.asString(this.getAtt('Status'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.dataNode = props.dataNode;
        this.password = props.password;
        this.version = props.version;
        this.vSwitchId = props.vSwitchId;
        this.description = props.description;
        this.instanceChargeType = props.instanceChargeType;
        this.kibanaWhitelist = props.kibanaWhitelist;
        this.masterNode = props.masterNode;
        this.period = props.period;
        this.privateWhitelist = props.privateWhitelist;
        this.publicWhitelist = props.publicWhitelist;
    }
    get rosProperties() {
        return {
            dataNode: this.dataNode,
            password: this.password,
            version: this.version,
            vSwitchId: this.vSwitchId,
            description: this.description,
            instanceChargeType: this.instanceChargeType,
            kibanaWhitelist: this.kibanaWhitelist,
            masterNode: this.masterNode,
            period: this.period,
            privateWhitelist: this.privateWhitelist,
            publicWhitelist: this.publicWhitelist,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ElasticSearch::Instance";
/**
 * Determine whether the given properties match those of a `DataNodeProperty`
 *
 * @param properties - the TypeScript properties of a `DataNodeProperty`
 *
 * @returns the result of the validation.
 */
function RosInstance_DataNodePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('diskType', ros.requiredValidator)(properties.diskType));
    if (properties.diskType && (typeof properties.diskType) !== 'object') {
        errors.collect(ros.propertyValidator('diskType', ros.validateAllowedValues)({
            data: properties.diskType,
            allowedValues: ["cloud_ssd", "cloud_efficiency"],
        }));
    }
    errors.collect(ros.propertyValidator('diskType', ros.validateString)(properties.diskType));
    errors.collect(ros.propertyValidator('amount', ros.requiredValidator)(properties.amount));
    if (properties.amount && (typeof properties.amount) !== 'object') {
        errors.collect(ros.propertyValidator('amount', ros.validateRange)({
            data: properties.amount,
            min: 2,
            max: 50,
        }));
    }
    errors.collect(ros.propertyValidator('amount', ros.validateNumber)(properties.amount));
    errors.collect(ros.propertyValidator('diskSize', ros.requiredValidator)(properties.diskSize));
    errors.collect(ros.propertyValidator('diskSize', ros.validateNumber)(properties.diskSize));
    errors.collect(ros.propertyValidator('spec', ros.requiredValidator)(properties.spec));
    errors.collect(ros.propertyValidator('spec', ros.validateString)(properties.spec));
    return errors.wrap('supplied properties not correct for "DataNodeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance.DataNode` resource
 *
 * @param properties - the TypeScript properties of a `DataNodeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance.DataNode` resource.
 */
// @ts-ignore TS6133
function rosInstanceDataNodePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosInstance_DataNodePropertyValidator(properties).assertSuccess();
    return {
        DiskType: ros.stringToRosTemplate(properties.diskType),
        Amount: ros.numberToRosTemplate(properties.amount),
        DiskSize: ros.numberToRosTemplate(properties.diskSize),
        Spec: ros.stringToRosTemplate(properties.spec),
    };
}
/**
 * Determine whether the given properties match those of a `MasterNodeProperty`
 *
 * @param properties - the TypeScript properties of a `MasterNodeProperty`
 *
 * @returns the result of the validation.
 */
function RosInstance_MasterNodePropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('diskType', ros.validateString)(properties.diskType));
    errors.collect(ros.propertyValidator('amount', ros.validateNumber)(properties.amount));
    errors.collect(ros.propertyValidator('diskSize', ros.validateNumber)(properties.diskSize));
    errors.collect(ros.propertyValidator('spec', ros.requiredValidator)(properties.spec));
    errors.collect(ros.propertyValidator('spec', ros.validateString)(properties.spec));
    return errors.wrap('supplied properties not correct for "MasterNodeProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance.MasterNode` resource
 *
 * @param properties - the TypeScript properties of a `MasterNodeProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ElasticSearch::Instance.MasterNode` resource.
 */
// @ts-ignore TS6133
function rosInstanceMasterNodePropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosInstance_MasterNodePropertyValidator(properties).assertSuccess();
    return {
        DiskType: ros.stringToRosTemplate(properties.diskType),
        Amount: ros.numberToRosTemplate(properties.amount),
        DiskSize: ros.numberToRosTemplate(properties.diskSize),
        Spec: ros.stringToRosTemplate(properties.spec),
    };
}
//# sourceMappingURL=data:application/json;base64,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