import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
declare module "./queue-base" {
    /**
     * Represents an SQS queue.
     *
     * @stability stable
     */
    interface IQueue {
        /**
         * Return the given named metric for this Queue.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The approximate age of the oldest non-deleted message in the queue.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateAgeOfOldestMessage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages in the queue that are delayed and not available for reading immediately.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesDelayed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that are in flight.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesNotVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages available for retrieval from the queue.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of ReceiveMessage API calls that did not return a message.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfEmptyReceives(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages deleted from the queue.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesDeleted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages returned by calls to the ReceiveMessage action.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesReceived(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages added to a queue.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesSent(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The size of messages added to a queue.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricSentMessageSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
    /**
     * Reference to a new or existing Amazon SQS queue.
     *
     * @stability stable
     */
    interface QueueBase {
        /**
         * Return the given named metric for this Queue.
         *
         * @stability stable
         */
        metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The approximate age of the oldest non-deleted message in the queue.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateAgeOfOldestMessage(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages in the queue that are delayed and not available for reading immediately.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesDelayed(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages that are in flight.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesNotVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages available for retrieval from the queue.
         *
         * Maximum over 5 minutes
         *
         * @stability stable
         */
        metricApproximateNumberOfMessagesVisible(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of ReceiveMessage API calls that did not return a message.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfEmptyReceives(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages deleted from the queue.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesDeleted(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages returned by calls to the ReceiveMessage action.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesReceived(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The number of messages added to a queue.
         *
         * Sum over 5 minutes
         *
         * @stability stable
         */
        metricNumberOfMessagesSent(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
        /**
         * The size of messages added to a queue.
         *
         * Average over 5 minutes
         *
         * @stability stable
         */
        metricSentMessageSize(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    }
}
