import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NullProviderConfig {
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null#alias NullProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/null null}
*/
export declare class NullProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "null";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/null null} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NullProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: NullProviderConfig);
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
