import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface OrgPolicyPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Immutable.
     *
     * The resource name of the Policy. Must be one of the following forms, where constraint_name is the name of the constraint which this Policy configures: * `projects/{project_number}/policies/{constraint_name}` * `folders/{folder_id}/policies/{constraint_name}` * `organizations/{organization_id}/policies/{constraint_name}` For example, "projects/123/policies/compute.disableSerialPortAccess". Note: `projects/{project_id}/policies/{constraint_name}` is also an acceptable name for API requests, but responses will return the name using the equivalent project number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#name OrgPolicyPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The parent of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#parent OrgPolicyPolicy#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#spec OrgPolicyPolicy#spec}
     *
     * @stability stable
     */
    readonly spec?: OrgPolicyPolicySpec;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#timeouts OrgPolicyPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: OrgPolicyPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface OrgPolicyPolicySpecRulesCondition {
    /**
     * Optional.
     *
     * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#description OrgPolicyPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#expression OrgPolicyPolicy#expression}
     *
     * @stability stable
     */
    readonly expression?: string;
    /**
     * Optional.
     *
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#location OrgPolicyPolicy#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Optional.
     *
     * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#title OrgPolicyPolicy#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function orgPolicyPolicySpecRulesConditionToTerraform(struct?: OrgPolicyPolicySpecRulesConditionOutputReference | OrgPolicyPolicySpecRulesCondition): any;
/**
 * @stability stable
 */
export declare class OrgPolicyPolicySpecRulesConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrgPolicyPolicySpecRulesCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrgPolicyPolicySpecRulesCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    resetExpression(): void;
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface OrgPolicyPolicySpecRulesValues {
    /**
     * List of values allowed at this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#allowed_values OrgPolicyPolicy#allowed_values}
     *
     * @stability stable
     */
    readonly allowedValues?: string[];
    /**
     * List of values denied at this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#denied_values OrgPolicyPolicy#denied_values}
     *
     * @stability stable
     */
    readonly deniedValues?: string[];
}
export declare function orgPolicyPolicySpecRulesValuesToTerraform(struct?: OrgPolicyPolicySpecRulesValuesOutputReference | OrgPolicyPolicySpecRulesValues): any;
/**
 * @stability stable
 */
export declare class OrgPolicyPolicySpecRulesValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrgPolicyPolicySpecRulesValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrgPolicyPolicySpecRulesValues | undefined);
    private _allowedValues?;
    /**
     * @stability stable
     */
    get allowedValues(): string[];
    /**
     * @stability stable
     */
    set allowedValues(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedValues(): void;
    /**
     * @stability stable
     */
    get allowedValuesInput(): string[] | undefined;
    private _deniedValues?;
    /**
     * @stability stable
     */
    get deniedValues(): string[];
    /**
     * @stability stable
     */
    set deniedValues(value: string[]);
    /**
     * @stability stable
     */
    resetDeniedValues(): void;
    /**
     * @stability stable
     */
    get deniedValuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface OrgPolicyPolicySpecRules {
    /**
     * Setting this to true means that all values are allowed.
     *
     * This field can be set only in Policies for list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#allow_all OrgPolicyPolicy#allow_all}
     *
     * @stability stable
     */
    readonly allowAll?: string;
    /**
     * Setting this to true means that all values are denied.
     *
     * This field can be set only in Policies for list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#deny_all OrgPolicyPolicy#deny_all}
     *
     * @stability stable
     */
    readonly denyAll?: string;
    /**
     * If `true`, then the `Policy` is enforced.
     *
     * If `false`, then any configuration is acceptable. This field can be set only in Policies for boolean constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#enforce OrgPolicyPolicy#enforce}
     *
     * @stability stable
     */
    readonly enforce?: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#condition OrgPolicyPolicy#condition}
     *
     * @stability stable
     */
    readonly condition?: OrgPolicyPolicySpecRulesCondition;
    /**
     * values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#values OrgPolicyPolicy#values}
     *
     * @stability stable
     */
    readonly values?: OrgPolicyPolicySpecRulesValues;
}
export declare function orgPolicyPolicySpecRulesToTerraform(struct?: OrgPolicyPolicySpecRules): any;
/**
 * @stability stable
 */
export interface OrgPolicyPolicySpec {
    /**
     * Determines the inheritance behavior for this `Policy`.
     *
     * If `inherit_from_parent` is true, PolicyRules set higher up in the hierarchy (up to the closest root) are inherited and present in the effective policy. If it is false, then no rules are inherited, and this Policy becomes the new root for evaluation. This field can be set only for Policies which configure list constraints.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#inherit_from_parent OrgPolicyPolicy#inherit_from_parent}
     *
     * @stability stable
     */
    readonly inheritFromParent?: boolean | cdktf.IResolvable;
    /**
     * Ignores policies set above this resource and restores the `constraint_default` enforcement behavior of the specific `Constraint` at this resource.
     *
     * This field can be set in policies for either list or boolean constraints. If set, `rules` must be empty and `inherit_from_parent` must be set to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#reset OrgPolicyPolicy#reset}
     *
     * @stability stable
     */
    readonly reset?: boolean | cdktf.IResolvable;
    /**
     * rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#rules OrgPolicyPolicy#rules}
     *
     * @stability stable
     */
    readonly rules?: OrgPolicyPolicySpecRules[];
}
export declare function orgPolicyPolicySpecToTerraform(struct?: OrgPolicyPolicySpecOutputReference | OrgPolicyPolicySpec): any;
/**
 * @stability stable
 */
export declare class OrgPolicyPolicySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrgPolicyPolicySpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrgPolicyPolicySpec | undefined);
    private _inheritFromParent?;
    /**
     * @stability stable
     */
    get inheritFromParent(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set inheritFromParent(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInheritFromParent(): void;
    /**
     * @stability stable
     */
    get inheritFromParentInput(): boolean | cdktf.IResolvable | undefined;
    private _reset?;
    /**
     * @stability stable
     */
    get reset(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set reset(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReset(): void;
    /**
     * @stability stable
     */
    get resetInput(): boolean | cdktf.IResolvable | undefined;
    private _rules?;
    /**
     * @stability stable
     */
    get rules(): OrgPolicyPolicySpecRules[];
    /**
     * @stability stable
     */
    set rules(value: OrgPolicyPolicySpecRules[]);
    /**
     * @stability stable
     */
    resetRules(): void;
    /**
     * @stability stable
     */
    get rulesInput(): OrgPolicyPolicySpecRules[] | undefined;
}
/**
 * @stability stable
 */
export interface OrgPolicyPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#create OrgPolicyPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#delete OrgPolicyPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html#update OrgPolicyPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function orgPolicyPolicyTimeoutsToTerraform(struct?: OrgPolicyPolicyTimeoutsOutputReference | OrgPolicyPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class OrgPolicyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): OrgPolicyPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: OrgPolicyPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html google_org_policy_policy}.
 *
 * @stability stable
 */
export declare class OrgPolicyPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/org_policy_policy.html google_org_policy_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: OrgPolicyPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _spec;
    /**
     * @stability stable
     */
    get spec(): OrgPolicyPolicySpecOutputReference;
    /**
     * @stability stable
     */
    putSpec(value: OrgPolicyPolicySpec): void;
    /**
     * @stability stable
     */
    resetSpec(): void;
    /**
     * @stability stable
     */
    get specInput(): OrgPolicyPolicySpec | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): OrgPolicyPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: OrgPolicyPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): OrgPolicyPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
