# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from fabric_cf.orchestrator.swagger_server.models.base_model_ import Model
from fabric_cf.orchestrator.swagger_server.models.status500_internal_server_error_errors import Status500InternalServerErrorErrors  # noqa: F401,E501
from fabric_cf.orchestrator.swagger_server import util


class Status500InternalServerError(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, errors: List[Status500InternalServerErrorErrors]=None, type: str='error', size: int=1, status: int=500):  # noqa: E501
        """Status500InternalServerError - a model defined in Swagger

        :param errors: The errors of this Status500InternalServerError.  # noqa: E501
        :type errors: List[Status500InternalServerErrorErrors]
        :param type: The type of this Status500InternalServerError.  # noqa: E501
        :type type: str
        :param size: The size of this Status500InternalServerError.  # noqa: E501
        :type size: int
        :param status: The status of this Status500InternalServerError.  # noqa: E501
        :type status: int
        """
        self.swagger_types = {
            'errors': List[Status500InternalServerErrorErrors],
            'type': str,
            'size': int,
            'status': int
        }

        self.attribute_map = {
            'errors': 'errors',
            'type': 'type',
            'size': 'size',
            'status': 'status'
        }
        self._errors = errors
        self._type = type
        self._size = size
        self._status = status

    @classmethod
    def from_dict(cls, dikt) -> 'Status500InternalServerError':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The status_500_internal_server_error of this Status500InternalServerError.  # noqa: E501
        :rtype: Status500InternalServerError
        """
        return util.deserialize_model(dikt, cls)

    @property
    def errors(self) -> List[Status500InternalServerErrorErrors]:
        """Gets the errors of this Status500InternalServerError.


        :return: The errors of this Status500InternalServerError.
        :rtype: List[Status500InternalServerErrorErrors]
        """
        return self._errors

    @errors.setter
    def errors(self, errors: List[Status500InternalServerErrorErrors]):
        """Sets the errors of this Status500InternalServerError.


        :param errors: The errors of this Status500InternalServerError.
        :type errors: List[Status500InternalServerErrorErrors]
        """

        self._errors = errors

    @property
    def type(self) -> str:
        """Gets the type of this Status500InternalServerError.


        :return: The type of this Status500InternalServerError.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str):
        """Sets the type of this Status500InternalServerError.


        :param type: The type of this Status500InternalServerError.
        :type type: str
        """

        self._type = type

    @property
    def size(self) -> int:
        """Gets the size of this Status500InternalServerError.


        :return: The size of this Status500InternalServerError.
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size: int):
        """Sets the size of this Status500InternalServerError.


        :param size: The size of this Status500InternalServerError.
        :type size: int
        """

        self._size = size

    @property
    def status(self) -> int:
        """Gets the status of this Status500InternalServerError.


        :return: The status of this Status500InternalServerError.
        :rtype: int
        """
        return self._status

    @status.setter
    def status(self, status: int):
        """Sets the status of this Status500InternalServerError.


        :param status: The status of this Status500InternalServerError.
        :type status: int
        """

        self._status = status
