"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BasicAuth = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const secretsmanager = require("aws-cdk-lib/aws-secretsmanager");
/**
 * Basic Auth configuration
 */
class BasicAuth {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BasicAuthProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * Creates a Basic Auth configuration from a username and a password
     *
     * @param username The username
     * @param password The password
     */
    static fromCredentials(username, password) {
        return new BasicAuth({ username, password });
    }
    /**
     * Creates a Basic Auth configuration with a password generated in Secrets
     * Manager.
     *
     * @param username The username
     * @param encryptionKey The encryption key to use to encrypt the password in
     * Secrets Manager
     */
    static fromGeneratedPassword(username, encryptionKey) {
        return new BasicAuth({ username, encryptionKey });
    }
    /**
     * Binds this Basic Auth configuration to an App
     */
    bind(scope, id) {
        const config = {
            enableBasicAuth: true,
            username: this.props.username,
        };
        if (this.props.password) {
            return {
                ...config,
                password: this.props.password.unsafeUnwrap(),
            };
        }
        const secret = new secretsmanager.Secret(scope, id, {
            generateSecretString: {
                secretStringTemplate: JSON.stringify({ username: this.props.username }),
                generateStringKey: 'password',
            },
        });
        return {
            ...config,
            password: secret.secretValueFromJson('password').unsafeUnwrap(),
        };
    }
}
exports.BasicAuth = BasicAuth;
_a = JSII_RTTI_SYMBOL_1;
BasicAuth[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.BasicAuth", version: "2.21.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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