"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const aws_lambda_nodejs_1 = require("aws-cdk-lib/aws-lambda-nodejs");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const utils_1 = require("./utils");
/**
 * An Amplify Console branch
 */
class Branch extends aws_cdk_lib_1.Resource {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_amplify_alpha_BranchProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new aws_amplify_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: (_b = props.autoBuild) !== null && _b !== void 0 ? _b : true,
            enablePullRequestPreview: (_c = props.pullRequestPreview) !== null && _c !== void 0 ? _c : true,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
            enablePerformanceMode: props.performanceMode,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
        if (props.asset) {
            new aws_cdk_lib_1.CustomResource(this, 'DeploymentResource', {
                serviceToken: AmplifyAssetDeploymentProvider.getOrCreate(this),
                resourceType: 'Custom::AmplifyAssetDeployment',
                properties: {
                    AppId: props.app.appId,
                    BranchName: branchName,
                    S3ObjectKey: props.asset.s3ObjectKey,
                    S3BucketName: props.asset.s3BucketName,
                },
            });
        }
    }
    /**
     * Import an existing branch
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Branch", version: "2.21.1-alpha.0" };
class AmplifyAssetDeploymentProvider extends aws_cdk_lib_1.NestedStack {
    constructor(scope, id) {
        super(scope, id);
        const onEvent = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-on-event', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'onEvent',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: [
                        's3:GetObject',
                        's3:GetSignedUrl',
                        'amplify:ListJobs',
                        'amplify:StartDeployment',
                    ],
                }),
            ],
        });
        const isComplete = new aws_lambda_nodejs_1.NodejsFunction(this, 'amplify-asset-deployment-is-complete', {
            entry: path.join(__dirname, 'asset-deployment-handler/index.js'),
            runtime: lambda.Runtime.NODEJS_14_X,
            handler: 'isComplete',
            initialPolicy: [
                new iam.PolicyStatement({
                    resources: ['*'],
                    actions: ['amplify:GetJob*'],
                }),
            ],
        });
        this.provider = new custom_resources_1.Provider(this, 'amplify-asset-deployment-handler-provider', {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            totalTimeout: aws_cdk_lib_1.Duration.minutes(5),
        });
    }
    /**
     * Returns the singleton provider.
     */
    static getOrCreate(scope) {
        var _b;
        const providerId = 'com.amazonaws.cdk.custom-resources.amplify-asset-deployment-provider';
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const group = (_b = stack.node.tryFindChild(providerId)) !== null && _b !== void 0 ? _b : new AmplifyAssetDeploymentProvider(stack, providerId);
        return group.provider.serviceToken;
    }
}
//# sourceMappingURL=data:application/json;base64,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