"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
async function handler(event) {
    const resourceProps = event.ResourceProperties;
    switch (event.RequestType) {
        case 'Create':
        case 'Update':
            return cfnEventHandler(resourceProps, false);
        case 'Delete':
            return cfnEventHandler(resourceProps, true);
    }
}
exports.handler = handler;
async function cfnEventHandler(props, isDeleteEvent) {
    const { AssumeRoleArn, ParentZoneId, DelegatedZoneName, DelegatedZoneNameServers, TTL } = props;
    const credentials = await getCrossAccountCredentials(AssumeRoleArn);
    const route53 = new aws_sdk_1.Route53({ credentials });
    await route53.changeResourceRecordSets({
        HostedZoneId: ParentZoneId,
        ChangeBatch: {
            Changes: [{
                    Action: isDeleteEvent ? 'DELETE' : 'UPSERT',
                    ResourceRecordSet: {
                        Name: DelegatedZoneName,
                        Type: 'NS',
                        TTL,
                        ResourceRecords: DelegatedZoneNameServers.map(ns => ({ Value: ns })),
                    },
                }],
        },
    }).promise();
}
async function getCrossAccountCredentials(roleArn) {
    const sts = new aws_sdk_1.STS();
    const timestamp = (new Date()).getTime();
    const { Credentials: assumedCredentials } = await sts
        .assumeRole({
        RoleArn: roleArn,
        RoleSessionName: `cross-account-zone-delegation-${timestamp}`,
    })
        .promise();
    if (!assumedCredentials) {
        throw Error('Error getting assume role credentials');
    }
    return new aws_sdk_1.Credentials({
        accessKeyId: assumedCredentials.AccessKeyId,
        secretAccessKey: assumedCredentials.SecretAccessKey,
        sessionToken: assumedCredentials.SessionToken,
    });
}
//# sourceMappingURL=data:application/json;base64,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