import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Route53::DNSSEC`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html
 */
export interface CfnDNSSECProps {
    /**
     * `AWS::Route53::DNSSEC.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html#cfn-route53-dnssec-hostedzoneid
     */
    readonly hostedZoneId: string;
}
/**
 * A CloudFormation `AWS::Route53::DNSSEC`.
 *
 * @external
 * @cloudformationResource AWS::Route53::DNSSEC
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html
 */
export declare class CfnDNSSEC extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::DNSSEC";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDNSSEC;
    /**
     * `AWS::Route53::DNSSEC.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-dnssec.html#cfn-route53-dnssec-hostedzoneid
     */
    hostedZoneId: string;
    /**
     * Create a new `AWS::Route53::DNSSEC`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDNSSECProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Route53::HealthCheck`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export interface CfnHealthCheckProps {
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     */
    readonly healthCheckConfig: CfnHealthCheck.HealthCheckConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     */
    readonly healthCheckTags?: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export declare class CfnHealthCheck extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HealthCheck";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHealthCheck;
    /**
     * @external
     * @cloudformationAttribute HealthCheckId
     */
    readonly attrHealthCheckId: string;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     */
    healthCheckConfig: CfnHealthCheck.HealthCheckConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     */
    healthCheckTags: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HealthCheck`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHealthCheckProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export declare namespace CfnHealthCheck {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html
     */
    interface AlarmIdentifierProperty {
        /**
         * `CfnHealthCheck.AlarmIdentifierProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-name
         */
        readonly name: string;
        /**
         * `CfnHealthCheck.AlarmIdentifierProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-region
         */
        readonly region: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export declare namespace CfnHealthCheck {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html
     */
    interface HealthCheckConfigProperty {
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.AlarmIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-alarmidentifier
         */
        readonly alarmIdentifier?: CfnHealthCheck.AlarmIdentifierProperty | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.ChildHealthChecks`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-childhealthchecks
         */
        readonly childHealthChecks?: string[];
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.EnableSNI`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-enablesni
         */
        readonly enableSni?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.FailureThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-failurethreshold
         */
        readonly failureThreshold?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.FullyQualifiedDomainName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-fullyqualifieddomainname
         */
        readonly fullyQualifiedDomainName?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.HealthThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-healththreshold
         */
        readonly healthThreshold?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.IPAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-ipaddress
         */
        readonly ipAddress?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.InsufficientDataHealthStatus`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-insufficientdatahealthstatus
         */
        readonly insufficientDataHealthStatus?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Inverted`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-inverted
         */
        readonly inverted?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.MeasureLatency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-measurelatency
         */
        readonly measureLatency?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-port
         */
        readonly port?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Regions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-regions
         */
        readonly regions?: string[];
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.RequestInterval`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-requestinterval
         */
        readonly requestInterval?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.ResourcePath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-resourcepath
         */
        readonly resourcePath?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.SearchString`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-searchstring
         */
        readonly searchString?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 */
export declare namespace CfnHealthCheck {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html
     */
    interface HealthCheckTagProperty {
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-key
         */
        readonly key: string;
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-value
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::HostedZone`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export interface CfnHostedZoneProps {
    /**
     * `AWS::Route53::HostedZone.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     */
    readonly name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     */
    readonly hostedZoneConfig?: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     */
    readonly hostedZoneTags?: CfnHostedZone.HostedZoneTagProperty[];
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     */
    readonly queryLoggingConfig?: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.VPCs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     */
    readonly vpcs?: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare class CfnHostedZone extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HostedZone";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHostedZone;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute NameServers
     */
    readonly attrNameServers: string[];
    /**
     * `AWS::Route53::HostedZone.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     */
    name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     */
    hostedZoneConfig: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     */
    queryLoggingConfig: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.VPCs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     */
    vpcs: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HostedZone`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostedZoneProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare namespace CfnHostedZone {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html
     */
    interface HostedZoneConfigProperty {
        /**
         * `CfnHostedZone.HostedZoneConfigProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html#cfn-route53-hostedzone-hostedzoneconfig-comment
         */
        readonly comment?: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare namespace CfnHostedZone {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html
     */
    interface HostedZoneTagProperty {
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html#cfn-route53-hostedzone-hostedzonetag-key
         */
        readonly key: string;
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html#cfn-route53-hostedzone-hostedzonetag-value
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare namespace CfnHostedZone {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html
     */
    interface QueryLoggingConfigProperty {
        /**
         * `CfnHostedZone.QueryLoggingConfigProperty.CloudWatchLogsLogGroupArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html#cfn-route53-hostedzone-queryloggingconfig-cloudwatchlogsloggrouparn
         */
        readonly cloudWatchLogsLogGroupArn: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 */
export declare namespace CfnHostedZone {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html
     */
    interface VPCProperty {
        /**
         * `CfnHostedZone.VPCProperty.VPCId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html#cfn-route53-hostedzone-vpc-vpcid
         */
        readonly vpcId: string;
        /**
         * `CfnHostedZone.VPCProperty.VPCRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html#cfn-route53-hostedzone-vpc-vpcregion
         */
        readonly vpcRegion: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::KeySigningKey`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html
 */
export interface CfnKeySigningKeyProps {
    /**
     * `AWS::Route53::KeySigningKey.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-hostedzoneid
     */
    readonly hostedZoneId: string;
    /**
     * `AWS::Route53::KeySigningKey.KeyManagementServiceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-keymanagementservicearn
     */
    readonly keyManagementServiceArn: string;
    /**
     * `AWS::Route53::KeySigningKey.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-name
     */
    readonly name: string;
    /**
     * `AWS::Route53::KeySigningKey.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-status
     */
    readonly status: string;
}
/**
 * A CloudFormation `AWS::Route53::KeySigningKey`.
 *
 * @external
 * @cloudformationResource AWS::Route53::KeySigningKey
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html
 */
export declare class CfnKeySigningKey extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::KeySigningKey";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnKeySigningKey;
    /**
     * `AWS::Route53::KeySigningKey.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-hostedzoneid
     */
    hostedZoneId: string;
    /**
     * `AWS::Route53::KeySigningKey.KeyManagementServiceArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-keymanagementservicearn
     */
    keyManagementServiceArn: string;
    /**
     * `AWS::Route53::KeySigningKey.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-name
     */
    name: string;
    /**
     * `AWS::Route53::KeySigningKey.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-keysigningkey.html#cfn-route53-keysigningkey-status
     */
    status: string;
    /**
     * Create a new `AWS::Route53::KeySigningKey`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnKeySigningKeyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Route53::RecordSet`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export interface CfnRecordSetProps {
    /**
     * `AWS::Route53::RecordSet.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    readonly name: string;
    /**
     * `AWS::Route53::RecordSet.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    readonly type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    readonly aliasTarget?: CfnRecordSet.AliasTargetProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Comment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSet.Failover`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    readonly failover?: string;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    readonly geoLocation?: CfnRecordSet.GeoLocationProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    readonly healthCheckId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    readonly multiValueAnswer?: boolean | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Region`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    readonly region?: string;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    readonly resourceRecords?: string[];
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    readonly setIdentifier?: string;
    /**
     * `AWS::Route53::RecordSet.TTL`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    readonly ttl?: string;
    /**
     * `AWS::Route53::RecordSet.Weight`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    readonly weight?: number;
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export declare class CfnRecordSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRecordSet;
    /**
     * `AWS::Route53::RecordSet.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     */
    name: string;
    /**
     * `AWS::Route53::RecordSet.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     */
    type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     */
    aliasTarget: CfnRecordSet.AliasTargetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Comment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Failover`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     */
    failover: string | undefined;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     */
    geoLocation: CfnRecordSet.GeoLocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     */
    healthCheckId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     */
    multiValueAnswer: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Region`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     */
    region: string | undefined;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     */
    resourceRecords: string[] | undefined;
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     */
    setIdentifier: string | undefined;
    /**
     * `AWS::Route53::RecordSet.TTL`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     */
    ttl: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Weight`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     */
    weight: number | undefined;
    /**
     * Create a new `AWS::Route53::RecordSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRecordSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export declare namespace CfnRecordSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSet.AliasTargetProperty.DNSName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSet.AliasTargetProperty.HostedZoneId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        readonly hostedZoneId: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 */
export declare namespace CfnRecordSet {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSet.GeoLocationProperty.ContinentCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-continentcode
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.CountryCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.SubdivisionCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        readonly subdivisionCode?: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::RecordSetGroup`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export interface CfnRecordSetGroupProps {
    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    readonly recordSets?: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export declare class CfnRecordSetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRecordSetGroup;
    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     */
    recordSets: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRecordSetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.DNSName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.HostedZoneId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         */
        readonly hostedZoneId: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.ContinentCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordsetgroup-geolocation-continentcode
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.CountryCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.SubdivisionCode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         */
        readonly subdivisionCode?: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
     */
    interface RecordSetProperty {
        /**
         * `CfnRecordSetGroup.RecordSetProperty.AliasTarget`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         */
        readonly aliasTarget?: CfnRecordSetGroup.AliasTargetProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
         */
        readonly comment?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Failover`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
         */
        readonly failover?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.GeoLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         */
        readonly geoLocation?: CfnRecordSetGroup.GeoLocationProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HealthCheckId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
         */
        readonly healthCheckId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
         */
        readonly hostedZoneName?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         */
        readonly multiValueAnswer?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
         */
        readonly name: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
         */
        readonly region?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.ResourceRecords`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
         */
        readonly resourceRecords?: string[];
        /**
         * `CfnRecordSetGroup.RecordSetProperty.SetIdentifier`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
         */
        readonly setIdentifier?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.TTL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
         */
        readonly ttl?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
         */
        readonly type: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Weight`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
         */
        readonly weight?: number;
    }
}
