<!--- Copyright 2021 eprbell --->

<!--- Licensed under the Apache License, Version 2.0 (the "License"); --->
<!--- you may not use this file except in compliance with the License. --->
<!--- You may obtain a copy of the License at --->

<!---     http://www.apache.org/licenses/LICENSE-2.0 --->

<!--- Unless required by applicable law or agreed to in writing, software --->
<!--- distributed under the License is distributed on an "AS IS" BASIS, --->
<!--- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. --->
<!--- See the License for the specific language governing permissions and --->
<!--- limitations under the License. --->

# RP2 Change Log

# v.0.9.6
* fixed a bug in timestamp check: in and out lots were not allowed to have the same timestamp, but in certain scenarios it could happen (e.g. high-frequency trading)
* fixed a subtle corner-case bug in LIFO, which caused the first gain/loss pair to be incorrect: the minimal input that reproduced the bug is now captured in one of the tests (test_data2.ods, sheet B1). This ensures there will not be a regression.
* disable a link check in user faq: the link was failing the check (incorrectly) on Github actions
* added large input test

# v0.9.5
* added new LIFO tests
* minor fixes

# v0.9.4
* added accounting-method programmable plugin infrastructure: by subclassing AbstractAccountingMethod it's now possible to add support for a new accounting method (previously only FIFO was hard-coded in)
* added accounting-method plugins: FIFO, LIFO
* added accounting-method-specific tests, plus additional tests of internal classes (both new and old)
* Added Legend sheet to tax_report_us output
* updated documentation to reflect changes in this version
* minor fixes

## v0.9.3
* added country-specific programmable plugin infrastructure: by subclassing AbstractCountry it's now possible to add support for a new country (currently only US is supported)
* abstracted out currency from APIs and code in general: references to "usd" have been changed to "fiat"
* updated documentation to reflect changes in this version

## v0.9.2
* Verified software is up to date for FY 2021
* Wrote several answers in User FAQ document
* Minor fixes

## v0.8.1
* Added several new tests (from/to_year command line option variations and new transaction types)
* Reworked time filter logic to fix two bugs related to -f and -t options:
  * with time filtering on, running sums reflected only filtered transactions, instead of all transactions (in other words, running sums should not be affected by filtering)
  * with time filtering on, number of fractions reflected also fractions with year higher than time filter
  * with time filtering on, sold lot percentages would be shown incorrectly in some cases
* Updated documentation: various fixes and improvements

## v0.8.0
* added new transaction types: AIRDROP, HARDFORK, INTEREST, MINING, STAKING, WAGES. Removed transaction type EARN, which used to encompass all the above types
* revisited output generators: rp2_report was renamed to rp2_full_report and mock_8949_us was renamed to tax_report_us. The tax_report_us plugin now generates one sheet per taxable event type: Airdrops, Capital Gains, Donations, Gifts, Hard Forks, Interest, Investment Expense, Mining, Staking, Wages.
* fixed bug in from/to_year logic: entry sets didn't consider the time filter in certain corner cases
* updated documentation to reflect above changes

## v0.7.3
* Added from/to_year command line option

## v0.7.2
* Minor fixes related to Pypi package distribution and upload

## v0.7.1
* Minor fixes related to Pypi package distribution and upload

## v0.7.0
* First version uploaded to Pypi
* Added pre-commit hooks
* Added bandit security checks
* Major revision of user and developer documentation
* Fixed lint errors
* Various bug fixes and improvements

## v0.6.0
* First version tracked in change log
* Added Python packaging support
* Switched to high-precision math (decimal.Decimal)
* Finished documentation (except FAQs)
* Added bumpversion
* Various bug fixes and improvements
