# Generated by Django 4.0.4 on 2022-05-05 09:24

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('name', models.CharField(max_length=32, verbose_name='部门名称')),
                ('organization_id', models.IntegerField(verbose_name='组织id')),
                ('is_deleted', models.BooleanField(default=False, verbose_name='部门是否删除, 默认False')),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='departments.department', verbose_name='上级部门id')),
            ],
            options={
                'db_table': 'department',
                'unique_together': {('name', 'parent')},
            },
        ),
        migrations.CreateModel(
            name='UserInformation',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(unique=True, verbose_name='用户id')),
                ('position', models.CharField(max_length=64, verbose_name='职位')),
                ('leader_user_id', models.IntegerField(verbose_name='直属领导id')),
            ],
            options={
                'db_table': 'user_information',
            },
        ),
        migrations.CreateModel(
            name='DepartmentUserMap',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='创建时间')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='最后更新时间')),
                ('user_id', models.IntegerField(verbose_name='用户id')),
                ('department', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='departments.department', verbose_name='部门id')),
            ],
            options={
                'db_table': 'department_user_map',
                'unique_together': {('department', 'user_id')},
            },
        ),
    ]
