# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = ['AuthBackendClient']


class AuthBackendClient(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 ec2_endpoint: Optional[pulumi.Input[str]] = None,
                 iam_endpoint: Optional[pulumi.Input[str]] = None,
                 iam_server_id_header_value: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 sts_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a AuthBackendClient resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The AWS access key that Vault should use for the
               auth backend.
        :param pulumi.Input[str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['access_key'] = access_key
            __props__['backend'] = backend
            __props__['ec2_endpoint'] = ec2_endpoint
            __props__['iam_endpoint'] = iam_endpoint
            __props__['iam_server_id_header_value'] = iam_server_id_header_value
            __props__['secret_key'] = secret_key
            __props__['sts_endpoint'] = sts_endpoint
        super(AuthBackendClient, __self__).__init__(
            'vault:aws/authBackendClient:AuthBackendClient',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            ec2_endpoint: Optional[pulumi.Input[str]] = None,
            iam_endpoint: Optional[pulumi.Input[str]] = None,
            iam_server_id_header_value: Optional[pulumi.Input[str]] = None,
            secret_key: Optional[pulumi.Input[str]] = None,
            sts_endpoint: Optional[pulumi.Input[str]] = None) -> 'AuthBackendClient':
        """
        Get an existing AuthBackendClient resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The AWS access key that Vault should use for the
               auth backend.
        :param pulumi.Input[str] backend: The path the AWS auth backend being configured was
               mounted at.  Defaults to `aws`.
        :param pulumi.Input[str] ec2_endpoint: Override the URL Vault uses when making EC2 API
               calls.
        :param pulumi.Input[str] iam_endpoint: Override the URL Vault uses when making IAM API
               calls.
        :param pulumi.Input[str] iam_server_id_header_value: The value to require in the
               `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
               that are used in the IAM auth method.
        :param pulumi.Input[str] secret_key: The AWS secret key that Vault should use for the
               auth backend.
        :param pulumi.Input[str] sts_endpoint: Override the URL Vault uses when making STS API
               calls.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_key"] = access_key
        __props__["backend"] = backend
        __props__["ec2_endpoint"] = ec2_endpoint
        __props__["iam_endpoint"] = iam_endpoint
        __props__["iam_server_id_header_value"] = iam_server_id_header_value
        __props__["secret_key"] = secret_key
        __props__["sts_endpoint"] = sts_endpoint
        return AuthBackendClient(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS access key that Vault should use for the
        auth backend.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        The path the AWS auth backend being configured was
        mounted at.  Defaults to `aws`.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="ec2Endpoint")
    def ec2_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Override the URL Vault uses when making EC2 API
        calls.
        """
        return pulumi.get(self, "ec2_endpoint")

    @property
    @pulumi.getter(name="iamEndpoint")
    def iam_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Override the URL Vault uses when making IAM API
        calls.
        """
        return pulumi.get(self, "iam_endpoint")

    @property
    @pulumi.getter(name="iamServerIdHeaderValue")
    def iam_server_id_header_value(self) -> pulumi.Output[Optional[str]]:
        """
        The value to require in the
        `X-Vault-AWS-IAM-Server-ID` header as part of `GetCallerIdentity` requests
        that are used in the IAM auth method.
        """
        return pulumi.get(self, "iam_server_id_header_value")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        The AWS secret key that Vault should use for the
        auth backend.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="stsEndpoint")
    def sts_endpoint(self) -> pulumi.Output[Optional[str]]:
        """
        Override the URL Vault uses when making STS API
        calls.
        """
        return pulumi.get(self, "sts_endpoint")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

