# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = ['SecretBackendRole']


class SecretBackendRole(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 default_sts_ttl: Optional[pulumi.Input[float]] = None,
                 iam_groups: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 max_sts_ttl: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 role_arns: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a SecretBackendRole resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[float] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[List[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[float] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[List[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[List[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            if credential_type is None:
                raise TypeError("Missing required property 'credential_type'")
            __props__['credential_type'] = credential_type
            __props__['default_sts_ttl'] = default_sts_ttl
            __props__['iam_groups'] = iam_groups
            __props__['max_sts_ttl'] = max_sts_ttl
            __props__['name'] = name
            __props__['policy_arns'] = policy_arns
            __props__['policy_document'] = policy_document
            __props__['role_arns'] = role_arns
        super(SecretBackendRole, __self__).__init__(
            'vault:aws/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            credential_type: Optional[pulumi.Input[str]] = None,
            default_sts_ttl: Optional[pulumi.Input[float]] = None,
            iam_groups: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            max_sts_ttl: Optional[pulumi.Input[float]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_arns: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            policy_document: Optional[pulumi.Input[str]] = None,
            role_arns: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[float] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[List[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[float] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[List[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[List[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["credential_type"] = credential_type
        __props__["default_sts_ttl"] = default_sts_ttl
        __props__["iam_groups"] = iam_groups
        __props__["max_sts_ttl"] = max_sts_ttl
        __props__["name"] = name
        __props__["policy_arns"] = policy_arns
        __props__["policy_document"] = policy_document
        __props__["role_arns"] = role_arns
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the AWS secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of credential to be used when
        retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
        `federation_token`.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="defaultStsTtl")
    def default_sts_ttl(self) -> pulumi.Output[float]:
        """
        The default TTL in seconds for STS credentials.
        When a TTL is not specified when STS credentials are requested,
        and a default TTL is specified on the role,
        then this default TTL will be used. Valid only when `credential_type` is one of
        `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "default_sts_ttl")

    @property
    @pulumi.getter(name="iamGroups")
    def iam_groups(self) -> pulumi.Output[Optional[List[str]]]:
        """
        A list of IAM group names. IAM users generated
        against this vault role will be added to these IAM Groups. For a credential
        type of `assumed_role` or `federation_token`, the policies sent to the
        corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
        policies from each group in `iam_groups` combined with the `policy_document`
        and `policy_arns` parameters.
        """
        return pulumi.get(self, "iam_groups")

    @property
    @pulumi.getter(name="maxStsTtl")
    def max_sts_ttl(self) -> pulumi.Output[float]:
        """
        The max allowed TTL in seconds for STS credentials
        (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
        one of `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "max_sts_ttl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Specifies a list of AWS managed policy ARNs. The
        behavior depends on the credential type. With `iam_user`, the policies will be
        attached to IAM users when they are requested. With `assumed_role` and
        `federation_token`, the policy ARNs will act as a filter on what the credentials
        can do, similar to `policy_document`. When `credential_type` is `iam_user` or
        `federation_token`, at least one of `policy_document` or `policy_arns` must
        be specified.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM policy document for the role. The
        behavior depends on the credential type. With `iam_user`, the policy document
        will be attached to the IAM user generated and augment the permissions the IAM
        user has. With `assumed_role` and `federation_token`, the policy document will
        act as a filter on what the credentials can do, similar to `policy_arns`.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="roleArns")
    def role_arns(self) -> pulumi.Output[Optional[List[str]]]:
        """
        Specifies the ARNs of the AWS roles this Vault role
        is allowed to assume. Required when `credential_type` is `assumed_role` and
        prohibited otherwise.
        """
        return pulumi.get(self, "role_arns")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

