# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'GetAccessCredentialsResult',
    'AwaitableGetAccessCredentialsResult',
    'get_access_credentials',
]

@pulumi.output_type
class GetAccessCredentialsResult:
    """
    A collection of values returned by getAccessCredentials.
    """
    def __init__(__self__, backend=None, client_id=None, client_secret=None, id=None, lease_duration=None, lease_id=None, lease_renewable=None, lease_start_time=None, max_cred_validation_seconds=None, num_seconds_between_tests=None, num_sequential_successes=None, role=None, validate_creds=None):
        if backend and not isinstance(backend, str):
            raise TypeError("Expected argument 'backend' to be a str")
        pulumi.set(__self__, "backend", backend)
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if client_secret and not isinstance(client_secret, str):
            raise TypeError("Expected argument 'client_secret' to be a str")
        pulumi.set(__self__, "client_secret", client_secret)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lease_duration and not isinstance(lease_duration, float):
            raise TypeError("Expected argument 'lease_duration' to be a float")
        pulumi.set(__self__, "lease_duration", lease_duration)
        if lease_id and not isinstance(lease_id, str):
            raise TypeError("Expected argument 'lease_id' to be a str")
        pulumi.set(__self__, "lease_id", lease_id)
        if lease_renewable and not isinstance(lease_renewable, bool):
            raise TypeError("Expected argument 'lease_renewable' to be a bool")
        pulumi.set(__self__, "lease_renewable", lease_renewable)
        if lease_start_time and not isinstance(lease_start_time, str):
            raise TypeError("Expected argument 'lease_start_time' to be a str")
        pulumi.set(__self__, "lease_start_time", lease_start_time)
        if max_cred_validation_seconds and not isinstance(max_cred_validation_seconds, float):
            raise TypeError("Expected argument 'max_cred_validation_seconds' to be a float")
        pulumi.set(__self__, "max_cred_validation_seconds", max_cred_validation_seconds)
        if num_seconds_between_tests and not isinstance(num_seconds_between_tests, float):
            raise TypeError("Expected argument 'num_seconds_between_tests' to be a float")
        pulumi.set(__self__, "num_seconds_between_tests", num_seconds_between_tests)
        if num_sequential_successes and not isinstance(num_sequential_successes, float):
            raise TypeError("Expected argument 'num_sequential_successes' to be a float")
        pulumi.set(__self__, "num_sequential_successes", num_sequential_successes)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if validate_creds and not isinstance(validate_creds, bool):
            raise TypeError("Expected argument 'validate_creds' to be a bool")
        pulumi.set(__self__, "validate_creds", validate_creds)

    @property
    @pulumi.getter
    def backend(self) -> str:
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        The client id for credentials to query the Azure APIs.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> str:
        """
        The client secret for credentials to query the Azure APIs.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="leaseDuration")
    def lease_duration(self) -> float:
        """
        The duration of the secret lease, in seconds relative
        to the time the data was requested. Once this time has passed any plan
        generated with this data may fail to apply.
        """
        return pulumi.get(self, "lease_duration")

    @property
    @pulumi.getter(name="leaseId")
    def lease_id(self) -> str:
        """
        The lease identifier assigned by Vault.
        """
        return pulumi.get(self, "lease_id")

    @property
    @pulumi.getter(name="leaseRenewable")
    def lease_renewable(self) -> bool:
        return pulumi.get(self, "lease_renewable")

    @property
    @pulumi.getter(name="leaseStartTime")
    def lease_start_time(self) -> str:
        return pulumi.get(self, "lease_start_time")

    @property
    @pulumi.getter(name="maxCredValidationSeconds")
    def max_cred_validation_seconds(self) -> Optional[float]:
        return pulumi.get(self, "max_cred_validation_seconds")

    @property
    @pulumi.getter(name="numSecondsBetweenTests")
    def num_seconds_between_tests(self) -> Optional[float]:
        return pulumi.get(self, "num_seconds_between_tests")

    @property
    @pulumi.getter(name="numSequentialSuccesses")
    def num_sequential_successes(self) -> Optional[float]:
        return pulumi.get(self, "num_sequential_successes")

    @property
    @pulumi.getter
    def role(self) -> str:
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="validateCreds")
    def validate_creds(self) -> Optional[bool]:
        return pulumi.get(self, "validate_creds")


class AwaitableGetAccessCredentialsResult(GetAccessCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccessCredentialsResult(
            backend=self.backend,
            client_id=self.client_id,
            client_secret=self.client_secret,
            id=self.id,
            lease_duration=self.lease_duration,
            lease_id=self.lease_id,
            lease_renewable=self.lease_renewable,
            lease_start_time=self.lease_start_time,
            max_cred_validation_seconds=self.max_cred_validation_seconds,
            num_seconds_between_tests=self.num_seconds_between_tests,
            num_sequential_successes=self.num_sequential_successes,
            role=self.role,
            validate_creds=self.validate_creds)


def get_access_credentials(backend: Optional[str] = None,
                           max_cred_validation_seconds: Optional[float] = None,
                           num_seconds_between_tests: Optional[float] = None,
                           num_sequential_successes: Optional[float] = None,
                           role: Optional[str] = None,
                           validate_creds: Optional[bool] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccessCredentialsResult:
    """
    Use this data source to access information about an existing resource.

    :param str backend: The path to the Azure secret backend to
           read credentials from, with no leading or trailing `/`s.
    :param float max_cred_validation_seconds: If 'validate_creds' is true, 
           the number of seconds after which to give up validating credentials. Defaults
           to 1,200 (20 minutes).
    :param float num_seconds_between_tests: If 'validate_creds' is true, 
           the number of seconds to wait between each test of generated credentials.
           Defaults to 7.
    :param float num_sequential_successes: If 'validate_creds' is true, 
           the number of sequential successes required to validate generated
           credentials. Defaults to 8.
    :param str role: The name of the Azure secret backend role to read
           credentials from, with no leading or trailing `/`s.
    :param bool validate_creds: Whether generated credentials should be 
           validated before being returned. Defaults to `false`, which returns
           credentials without checking whether they have fully propagated throughout
           Azure Active Directory. Designating `true` activates testing.
    """
    __args__ = dict()
    __args__['backend'] = backend
    __args__['maxCredValidationSeconds'] = max_cred_validation_seconds
    __args__['numSecondsBetweenTests'] = num_seconds_between_tests
    __args__['numSequentialSuccesses'] = num_sequential_successes
    __args__['role'] = role
    __args__['validateCreds'] = validate_creds
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('vault:azure/getAccessCredentials:getAccessCredentials', __args__, opts=opts, typ=GetAccessCredentialsResult).value

    return AwaitableGetAccessCredentialsResult(
        backend=__ret__.backend,
        client_id=__ret__.client_id,
        client_secret=__ret__.client_secret,
        id=__ret__.id,
        lease_duration=__ret__.lease_duration,
        lease_id=__ret__.lease_id,
        lease_renewable=__ret__.lease_renewable,
        lease_start_time=__ret__.lease_start_time,
        max_cred_validation_seconds=__ret__.max_cred_validation_seconds,
        num_seconds_between_tests=__ret__.num_seconds_between_tests,
        num_sequential_successes=__ret__.num_sequential_successes,
        role=__ret__.role,
        validate_creds=__ret__.validate_creds)
