# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'SecretBackendConnectionCassandra',
    'SecretBackendConnectionElasticsearch',
    'SecretBackendConnectionHana',
    'SecretBackendConnectionMongodb',
    'SecretBackendConnectionMongodbatlas',
    'SecretBackendConnectionMssql',
    'SecretBackendConnectionMysql',
    'SecretBackendConnectionMysqlAurora',
    'SecretBackendConnectionMysqlLegacy',
    'SecretBackendConnectionMysqlRds',
    'SecretBackendConnectionOracle',
    'SecretBackendConnectionPostgresql',
]

@pulumi.output_type
class SecretBackendConnectionCassandra(dict):
    def __init__(__self__, *,
                 connect_timeout: Optional[float] = None,
                 hosts: Optional[List[str]] = None,
                 insecure_tls: Optional[bool] = None,
                 password: Optional[str] = None,
                 pem_bundle: Optional[str] = None,
                 pem_json: Optional[str] = None,
                 port: Optional[float] = None,
                 protocol_version: Optional[float] = None,
                 tls: Optional[bool] = None,
                 username: Optional[str] = None):
        """
        :param float connect_timeout: The number of seconds to use as a connection
               timeout.
        :param List[str] hosts: The hosts to connect to.
        :param bool insecure_tls: Whether to skip verification of the server
               certificate when using TLS.
        :param str password: The password to be used in the connection.
        :param str pem_bundle: Concatenated PEM blocks configuring the certificate
               chain.
        :param str pem_json: A JSON structure configuring the certificate chain.
        :param float port: The default port to connect to if no port is specified as
               part of the host.
        :param float protocol_version: The CQL protocol version to use.
        :param bool tls: Whether to use TLS when connecting to Cassandra.
        :param str username: The username to be used in the connection.
        """
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if insecure_tls is not None:
            pulumi.set(__self__, "insecure_tls", insecure_tls)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pem_bundle is not None:
            pulumi.set(__self__, "pem_bundle", pem_bundle)
        if pem_json is not None:
            pulumi.set(__self__, "pem_json", pem_json)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[float]:
        """
        The number of seconds to use as a connection
        timeout.
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter
    def hosts(self) -> Optional[List[str]]:
        """
        The hosts to connect to.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter(name="insecureTls")
    def insecure_tls(self) -> Optional[bool]:
        """
        Whether to skip verification of the server
        certificate when using TLS.
        """
        return pulumi.get(self, "insecure_tls")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password to be used in the connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="pemBundle")
    def pem_bundle(self) -> Optional[str]:
        """
        Concatenated PEM blocks configuring the certificate
        chain.
        """
        return pulumi.get(self, "pem_bundle")

    @property
    @pulumi.getter(name="pemJson")
    def pem_json(self) -> Optional[str]:
        """
        A JSON structure configuring the certificate chain.
        """
        return pulumi.get(self, "pem_json")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The default port to connect to if no port is specified as
        part of the host.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional[float]:
        """
        The CQL protocol version to use.
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter
    def tls(self) -> Optional[bool]:
        """
        Whether to use TLS when connecting to Cassandra.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username to be used in the connection.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionElasticsearch(dict):
    def __init__(__self__, *,
                 password: str,
                 url: str,
                 username: str):
        """
        :param str password: The password to be used in the connection.
        :param str url: The URL for Elasticsearch's API. https requires certificate
               by trusted CA if used.
        :param str username: The username to be used in the connection.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password to be used in the connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The URL for Elasticsearch's API. https requires certificate
        by trusted CA if used.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username to be used in the connection.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionHana(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMongodb(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMongodbatlas(dict):
    def __init__(__self__, *,
                 private_key: str,
                 project_id: str,
                 public_key: str):
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        return pulumi.get(self, "public_key")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMssql(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMysql(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMysqlAurora(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMysqlLegacy(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionMysqlRds(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionOracle(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretBackendConnectionPostgresql(dict):
    def __init__(__self__, *,
                 connection_url: Optional[str] = None,
                 max_connection_lifetime: Optional[float] = None,
                 max_idle_connections: Optional[float] = None,
                 max_open_connections: Optional[float] = None):
        """
        :param str connection_url: A URL containing connection information. See
               the [Vault
               docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
               for an example.
        :param float max_connection_lifetime: The maximum number of seconds to keep
               a connection alive for.
        :param float max_idle_connections: The maximum number of idle connections to
               maintain.
        :param float max_open_connections: The maximum number of open connections to
               use.
        """
        if connection_url is not None:
            pulumi.set(__self__, "connection_url", connection_url)
        if max_connection_lifetime is not None:
            pulumi.set(__self__, "max_connection_lifetime", max_connection_lifetime)
        if max_idle_connections is not None:
            pulumi.set(__self__, "max_idle_connections", max_idle_connections)
        if max_open_connections is not None:
            pulumi.set(__self__, "max_open_connections", max_open_connections)

    @property
    @pulumi.getter(name="connectionUrl")
    def connection_url(self) -> Optional[str]:
        """
        A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
        """
        return pulumi.get(self, "connection_url")

    @property
    @pulumi.getter(name="maxConnectionLifetime")
    def max_connection_lifetime(self) -> Optional[float]:
        """
        The maximum number of seconds to keep
        a connection alive for.
        """
        return pulumi.get(self, "max_connection_lifetime")

    @property
    @pulumi.getter(name="maxIdleConnections")
    def max_idle_connections(self) -> Optional[float]:
        """
        The maximum number of idle connections to
        maintain.
        """
        return pulumi.get(self, "max_idle_connections")

    @property
    @pulumi.getter(name="maxOpenConnections")
    def max_open_connections(self) -> Optional[float]:
        """
        The maximum number of open connections to
        use.
        """
        return pulumi.get(self, "max_open_connections")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


