# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AuthBackend']


class AuthBackend(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 base_url: Optional[pulumi.Input[str]] = None,
                 bypass_okta_mfa: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendGroupArgs']]]]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 organization: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendUserArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a resource for managing an
        [Okta auth backend within Vault](https://www.vaultproject.io/docs/auth/okta.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.okta.AuthBackend("example",
            description="Demonstration of the Terraform Okta auth backend",
            groups=[vault.okta.AuthBackendGroupArgs(
                group_name="foo",
                policies=[
                    "one",
                    "two",
                ],
            )],
            organization="example",
            token="something that should be kept secret",
            users=[vault.okta.AuthBackendUserArgs(
                groups=["foo"],
                username="bar",
            )])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] base_url: The Okta url. Examples: oktapreview.com, okta.com
        :param pulumi.Input[bool] bypass_okta_mfa: When true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendGroupArgs']]]] groups: Associate Okta groups with policies within Vault.
               See below for more details.
        :param pulumi.Input[str] max_ttl: Maximum duration after which authentication will be expired
               [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        :param pulumi.Input[str] organization: The Okta organization. This will be the first part of the url `https://XXX.okta.com`
        :param pulumi.Input[str] path: Path to mount the Okta auth backend
        :param pulumi.Input[str] token: The Okta API token. This is required to query Okta for user group membership.
               If this is not supplied only locally configured groups will be enabled.
        :param pulumi.Input[str] ttl: Duration after which authentication will be expired.
               [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendUserArgs']]]] users: Associate Okta users with groups or policies within Vault.
               See below for more details.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['base_url'] = base_url
            __props__['bypass_okta_mfa'] = bypass_okta_mfa
            __props__['description'] = description
            __props__['groups'] = groups
            __props__['max_ttl'] = max_ttl
            if organization is None:
                raise TypeError("Missing required property 'organization'")
            __props__['organization'] = organization
            __props__['path'] = path
            __props__['token'] = token
            __props__['ttl'] = ttl
            __props__['users'] = users
            __props__['accessor'] = None
        super(AuthBackend, __self__).__init__(
            'vault:okta/authBackend:AuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[str]] = None,
            base_url: Optional[pulumi.Input[str]] = None,
            bypass_okta_mfa: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendGroupArgs']]]]] = None,
            max_ttl: Optional[pulumi.Input[str]] = None,
            organization: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            token: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendUserArgs']]]]] = None) -> 'AuthBackend':
        """
        Get an existing AuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        :param pulumi.Input[str] base_url: The Okta url. Examples: oktapreview.com, okta.com
        :param pulumi.Input[bool] bypass_okta_mfa: When true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendGroupArgs']]]] groups: Associate Okta groups with policies within Vault.
               See below for more details.
        :param pulumi.Input[str] max_ttl: Maximum duration after which authentication will be expired
               [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        :param pulumi.Input[str] organization: The Okta organization. This will be the first part of the url `https://XXX.okta.com`
        :param pulumi.Input[str] path: Path to mount the Okta auth backend
        :param pulumi.Input[str] token: The Okta API token. This is required to query Okta for user group membership.
               If this is not supplied only locally configured groups will be enabled.
        :param pulumi.Input[str] ttl: Duration after which authentication will be expired.
               [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        :param pulumi.Input[List[pulumi.Input[pulumi.InputType['AuthBackendUserArgs']]]] users: Associate Okta users with groups or policies within Vault.
               See below for more details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessor"] = accessor
        __props__["base_url"] = base_url
        __props__["bypass_okta_mfa"] = bypass_okta_mfa
        __props__["description"] = description
        __props__["groups"] = groups
        __props__["max_ttl"] = max_ttl
        __props__["organization"] = organization
        __props__["path"] = path
        __props__["token"] = token
        __props__["ttl"] = ttl
        __props__["users"] = users
        return AuthBackend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[str]:
        """
        The mount accessor related to the auth mount. It is useful for integration with [Identity Secrets Engine](https://www.vaultproject.io/docs/secrets/identity/index.html).
        """
        return pulumi.get(self, "accessor")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> pulumi.Output[Optional[str]]:
        """
        The Okta url. Examples: oktapreview.com, okta.com
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="bypassOktaMfa")
    def bypass_okta_mfa(self) -> pulumi.Output[Optional[bool]]:
        """
        When true, requests by Okta for a MFA check will be bypassed. This also disallows certain status checks on the account, such as whether the password is expired.
        """
        return pulumi.get(self, "bypass_okta_mfa")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the auth backend
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[List['outputs.AuthBackendGroup']]:
        """
        Associate Okta groups with policies within Vault.
        See below for more details.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Maximum duration after which authentication will be expired
        [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        The Okta organization. This will be the first part of the url `https://XXX.okta.com`
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        Path to mount the Okta auth backend
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        The Okta API token. This is required to query Okta for user group membership.
        If this is not supplied only locally configured groups will be enabled.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Duration after which authentication will be expired.
        [See the documentation for info on valid duration formats](https://golang.org/pkg/time/#ParseDuration).
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[List['outputs.AuthBackendUser']]:
        """
        Associate Okta users with groups or policies within Vault.
        See below for more details.
        """
        return pulumi.get(self, "users")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

