"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const clickhouse_generated_1 = require("./clickhouse.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return clickhouse_generated_1.RosDBCluster; } });
/**
 * A ROS resource type:  `ALIYUN::ClickHouse::DBCluster`
 */
class DBCluster extends ros.Resource {
    /**
     * Create a new `ALIYUN::ClickHouse::DBCluster`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBCluster = new clickhouse_generated_1.RosDBCluster(this, id, {
            dbNodeStorageType: props.dbNodeStorageType,
            dbNodeStorage: props.dbNodeStorage,
            encryptionType: props.encryptionType,
            category: props.category,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            dbClusterDescription: props.dbClusterDescription,
            period: props.period,
            encryptionKey: props.encryptionKey,
            dbClusterNetworkType: props.dbClusterNetworkType,
            dbClusterType: props.dbClusterType,
            vpcId: props.vpcId,
            dbClusterVersion: props.dbClusterVersion,
            dbNodeCount: props.dbNodeCount,
            usedTime: props.usedTime,
            paymentType: props.paymentType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrAliUid = rosDBCluster.attrAliUid;
        this.attrBid = rosDBCluster.attrBid;
        this.attrCategory = rosDBCluster.attrCategory;
        this.attrCommodityCode = rosDBCluster.attrCommodityCode;
        this.attrConnectionString = rosDBCluster.attrConnectionString;
        this.attrDbClusterDescription = rosDBCluster.attrDbClusterDescription;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbClusterNetworkType = rosDBCluster.attrDbClusterNetworkType;
        this.attrDbClusterType = rosDBCluster.attrDbClusterType;
        this.attrDbClusterVersion = rosDBCluster.attrDbClusterVersion;
        this.attrDbNodeClass = rosDBCluster.attrDbNodeClass;
        this.attrDbNodeCount = rosDBCluster.attrDbNodeCount;
        this.attrDbNodeStorage = rosDBCluster.attrDbNodeStorage;
        this.attrDbNodeStorageType = rosDBCluster.attrDbNodeStorageType;
        this.attrEncryptionKey = rosDBCluster.attrEncryptionKey;
        this.attrEncryptionType = rosDBCluster.attrEncryptionType;
        this.attrEngine = rosDBCluster.attrEngine;
        this.attrEngineVersion = rosDBCluster.attrEngineVersion;
        this.attrIsExpired = rosDBCluster.attrIsExpired;
        this.attrLockMode = rosDBCluster.attrLockMode;
        this.attrLockReason = rosDBCluster.attrLockReason;
        this.attrPaymentType = rosDBCluster.attrPaymentType;
        this.attrPeriod = rosDBCluster.attrPeriod;
        this.attrPort = rosDBCluster.attrPort;
        this.attrPublicConnectionString = rosDBCluster.attrPublicConnectionString;
        this.attrPublicPort = rosDBCluster.attrPublicPort;
        this.attrStorageType = rosDBCluster.attrStorageType;
        this.attrVSwitchId = rosDBCluster.attrVSwitchId;
        this.attrVpcCloudInstanceId = rosDBCluster.attrVpcCloudInstanceId;
        this.attrVpcId = rosDBCluster.attrVpcId;
        this.attrZoneId = rosDBCluster.attrZoneId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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