import { StateMachineFragment, State, IChainable, INextable } from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
/**
 * Interface for creating a Semaphore
 */
export interface SemaphoreProps {
    /**
     * The name of the semaphore.
     */
    readonly lockName: string;
    /**
     * The maximum number of concurrent executions for the given lock.
     */
    readonly limit: number;
    /**
     * The job (or chained jobs) to be semaphored.
     */
    readonly job: IChainNextable;
    /**
     * The State to go to after the semaphored job completes.
     */
    readonly nextState: State;
    /**
     *  Explicility allow the reuse of a named lock from a previously generated job. Throws an error if a different `limit` is specified. Default: false.
     */
    readonly reuseLock?: boolean;
    /**
     * Add detailed comments to lock related states. Significantly increases CloudFormation template size. Default: false.
     */
    readonly comments?: boolean;
    /**
     * Optionally set the DynamoDB table to have a specific read/write capacity with PROVISIONED billing.
     * Note: This property can only be set on the first instantiation of a `Semaphore` per stack
     * @default PAY_PER_REQUEST
     */
    readonly tableReadWriteCapacity?: TableReadWriteCapacity;
}
/**
 * Read and write capacity for a PROVISIONED billing DynamoDB table.
 */
export interface TableReadWriteCapacity {
    readonly readCapacity: number;
    readonly writeCapacity: number;
}
export interface IChainNextable extends IChainable, INextable {
}
/**
 * Generates a semaphore for a StepFunction job (or chained set of jobs) to limit parallelism across executions.
 */
export declare class Semaphore extends StateMachineFragment {
    /**
     * The names and associated concurrency limits and number of uses of the sempahores.
     */
    private static semaphoreTracker;
    /**
     * The DynamoDB table used to store semaphores.
     */
    private semaphoreTable;
    /**
     * The DynamoDB table used to store semaphores.
     */
    private tableName;
    readonly startState: State;
    readonly endStates: INextable[];
    constructor(scope: Construct, id: string, props: SemaphoreProps);
    private setUpMap;
    private ensureTable;
}
