# Generated by Django 3.1.2 on 2020-10-19 14:37

import uuid

import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import wagtail.core.blocks
import wagtail.core.fields
import wagtail.images.blocks
from django.conf import settings
from django.db import migrations, models

import cast.blocks


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0052_pagelogentry"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Audio",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("duration", models.DurationField(blank=True, null=True)),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("subtitle", models.CharField(blank=True, max_length=512, null=True)),
                ("m4a", models.FileField(blank=True, null=True, upload_to="cast_audio/")),
                ("mp3", models.FileField(blank=True, null=True, upload_to="cast_audio/")),
                ("oga", models.FileField(blank=True, null=True, upload_to="cast_audio/")),
                ("opus", models.FileField(blank=True, null=True, upload_to="cast_audio/")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Blog",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("author", models.CharField(blank=True, default=None, max_length=255, null=True)),
                ("description", models.CharField(max_length=500)),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False)),
                ("email", models.EmailField(blank=True, default=None, max_length=254, null=True)),
                (
                    "comments_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Whether comments are enabled for this blog.",
                        verbose_name="comments_enabled",
                    ),
                ),
                (
                    "itunes_categories",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A json dict of itunes categories pointing to lists of subcategories. Taken from this list https://validator.w3.org/feed/docs/error/InvalidItunesCategory.html",
                        max_length=512,
                        verbose_name="itunes_categories",
                    ),
                ),
                (
                    "keywords",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A comma-delimitedlist of up to 12 words for iTunes\n            searches. Perhaps include misspellings of the title.",
                        max_length=255,
                        verbose_name="keywords",
                    ),
                ),
                (
                    "explicit",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "yes"), (2, "no"), (3, "clean")],
                        default=1,
                        help_text="``Clean`` will put the clean iTunes graphic by it.",
                        verbose_name="explicit",
                    ),
                ),
                ("intro", wagtail.core.fields.RichTextField(blank=True)),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="Gallery",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="HomePage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "body",
                    wagtail.core.fields.StreamField(
                        [
                            ("heading", wagtail.core.blocks.CharBlock(classname="full title")),
                            ("paragraph", wagtail.core.blocks.RichTextBlock()),
                            ("image", wagtail.images.blocks.ImageChooserBlock(template="cast/image/image.html")),
                            ("gallery", cast.blocks.GalleryBlock(wagtail.images.blocks.ImageChooserBlock())),
                        ]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="Image",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "original",
                    models.ImageField(
                        height_field="original_height", upload_to="cast_images/originals", width_field="original_width"
                    ),
                ),
                ("original_height", models.PositiveIntegerField(blank=True, null=True)),
                ("original_width", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="cast_images",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ItunesArtWork",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                (
                    "original",
                    models.ImageField(
                        height_field="original_height",
                        upload_to="cast_images/itunes_artwork",
                        width_field="original_width",
                    ),
                ),
                ("original_height", models.PositiveIntegerField(blank=True, null=True)),
                ("original_width", models.PositiveIntegerField(blank=True, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Request",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("ip", models.GenericIPAddressField()),
                ("timestamp", models.DateTimeField()),
                ("status", models.PositiveSmallIntegerField()),
                ("size", models.PositiveIntegerField()),
                ("referer", models.CharField(blank=True, max_length=2048, null=True)),
                ("user_agent", models.CharField(blank=True, max_length=1024, null=True)),
                (
                    "method",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (1, "GET"),
                            (2, "HEAD"),
                            (3, "POST"),
                            (4, "PUT"),
                            (5, "PATCH"),
                            (6, "DELETE"),
                            (7, "OPTIONS"),
                            (8, "CONNECT"),
                            (8, "TRACE"),
                        ]
                    ),
                ),
                ("path", models.CharField(max_length=1024)),
                (
                    "protocol",
                    models.PositiveSmallIntegerField(choices=[(1, "HTTP/1.0"), (2, "HTTP/1.1"), (3, "HTTP/2.0")]),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Video",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("original", models.FileField(upload_to="cast_videos/")),
                ("poster", models.ImageField(blank=True, null=True, upload_to="cast_videos/poster/")),
                ("poster_seconds", models.FloatField(default=1)),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Post",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False)),
                ("pub_date", models.DateTimeField(blank=True, null=True)),
                ("visible_date", models.DateTimeField(default=django.utils.timezone.now)),
                (
                    "keywords",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="A comma-demlimitedlist of up to 12 words for iTunes\n            searches. Perhaps include misspellings of the title.",
                        max_length=255,
                        verbose_name="keywords",
                    ),
                ),
                (
                    "explicit",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "yes"), (2, "no"), (3, "clean")],
                        default=1,
                        help_text="``Clean`` will put the clean iTunes graphic by it.",
                        verbose_name="explicit",
                    ),
                ),
                (
                    "block",
                    models.BooleanField(
                        default=False,
                        help_text="Check to block this episode from iTunes because <br />its content might cause the entire show to be <br />removed from iTunes.",
                        verbose_name="block",
                    ),
                ),
                (
                    "comments_enabled",
                    models.BooleanField(
                        default=True,
                        help_text="Whether comments are enabled for this post.",
                        verbose_name="comments_enabled",
                    ),
                ),
                (
                    "body",
                    wagtail.core.fields.StreamField(
                        [
                            ("heading", wagtail.core.blocks.CharBlock(classname="full title")),
                            ("paragraph", wagtail.core.blocks.RichTextBlock()),
                            ("image", wagtail.images.blocks.ImageChooserBlock(template="cast/image/image.html")),
                            ("gallery", cast.blocks.GalleryBlock(wagtail.images.blocks.ImageChooserBlock())),
                        ]
                    ),
                ),
                ("audios", models.ManyToManyField(blank=True, to="cast.Audio")),
                ("galleries", models.ManyToManyField(blank=True, to="cast.Gallery")),
                ("images", models.ManyToManyField(blank=True, to="cast.Image")),
                (
                    "parent_blog",
                    models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to="cast.blog"),
                ),
                (
                    "podcast_audio",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="posts",
                        to="cast.audio",
                    ),
                ),
                ("videos", models.ManyToManyField(blank=True, to="cast.Video")),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.AddField(
            model_name="gallery",
            name="images",
            field=models.ManyToManyField(to="cast.Image"),
        ),
        migrations.AddField(
            model_name="gallery",
            name="user",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name="File",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="created"
                    ),
                ),
                (
                    "modified",
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now, editable=False, verbose_name="modified"
                    ),
                ),
                ("original", models.FileField(upload_to="cast_files/")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="blog",
            name="itunes_artwork",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to="cast.itunesartwork"
            ),
        ),
        migrations.CreateModel(
            name="ChapterMark",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("start", models.TimeField(verbose_name="Start time of chaptermark")),
                ("title", models.CharField(max_length=255)),
                ("link", models.URLField(blank=True, max_length=2000, null=True)),
                ("image", models.URLField(blank=True, max_length=2000, null=True)),
                (
                    "audio",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="chaptermarks", to="cast.audio"
                    ),
                ),
            ],
            options={
                "unique_together": {("audio", "start")},
            },
        ),
    ]
