"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'mechanicalturk';
        this.accessLevelList = {
            "Write": [
                "AcceptQualificationRequest",
                "ApproveAssignment",
                "AssociateQualificationWithWorker",
                "CreateAdditionalAssignmentsForHIT",
                "CreateHIT",
                "CreateHITType",
                "CreateHITWithHITType",
                "CreateQualificationType",
                "CreateWorkerBlock",
                "DeleteHIT",
                "DeleteQualificationType",
                "DeleteWorkerBlock",
                "DisassociateQualificationFromWorker",
                "NotifyWorkers",
                "RejectAssignment",
                "RejectQualificationRequest",
                "SendBonus",
                "SendTestEventNotification",
                "UpdateExpirationForHIT",
                "UpdateHITReviewStatus",
                "UpdateHITTypeOfHIT",
                "UpdateNotificationSettings",
                "UpdateQualificationType"
            ],
            "Read": [
                "GetAccountBalance",
                "GetAssignment",
                "GetFileUploadURL",
                "GetHIT",
                "GetQualificationScore",
                "GetQualificationType"
            ],
            "List": [
                "ListAssignmentsForHIT",
                "ListBonusPayments",
                "ListHITs",
                "ListHITsForQualificationType",
                "ListQualificationRequests",
                "ListQualificationTypes",
                "ListReviewPolicyResultsForHIT",
                "ListReviewableHITs",
                "ListWorkerBlocks",
                "ListWorkersWithQualificationType"
            ]
        };
    }
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest() {
        this.to('mechanicalturk:AcceptQualificationRequest');
        return this;
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment() {
        this.to('mechanicalturk:ApproveAssignment');
        return this;
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker() {
        this.to('mechanicalturk:AssociateQualificationWithWorker');
        return this;
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT() {
        this.to('mechanicalturk:CreateAdditionalAssignmentsForHIT');
        return this;
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT() {
        this.to('mechanicalturk:CreateHIT');
        return this;
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType() {
        this.to('mechanicalturk:CreateHITType');
        return this;
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType() {
        this.to('mechanicalturk:CreateHITWithHITType');
        return this;
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType() {
        this.to('mechanicalturk:CreateQualificationType');
        return this;
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock() {
        this.to('mechanicalturk:CreateWorkerBlock');
        return this;
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT() {
        this.to('mechanicalturk:DeleteHIT');
        return this;
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType() {
        this.to('mechanicalturk:DeleteQualificationType');
        return this;
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock() {
        this.to('mechanicalturk:DeleteWorkerBlock');
        return this;
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker() {
        this.to('mechanicalturk:DisassociateQualificationFromWorker');
        return this;
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance() {
        this.to('mechanicalturk:GetAccountBalance');
        return this;
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment() {
        this.to('mechanicalturk:GetAssignment');
        return this;
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL() {
        this.to('mechanicalturk:GetFileUploadURL');
        return this;
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT() {
        this.to('mechanicalturk:GetHIT');
        return this;
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore() {
        this.to('mechanicalturk:GetQualificationScore');
        return this;
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType() {
        this.to('mechanicalturk:GetQualificationType');
        return this;
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT() {
        this.to('mechanicalturk:ListAssignmentsForHIT');
        return this;
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments() {
        this.to('mechanicalturk:ListBonusPayments');
        return this;
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs() {
        this.to('mechanicalturk:ListHITs');
        return this;
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType() {
        this.to('mechanicalturk:ListHITsForQualificationType');
        return this;
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests() {
        this.to('mechanicalturk:ListQualificationRequests');
        return this;
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes() {
        this.to('mechanicalturk:ListQualificationTypes');
        return this;
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT() {
        this.to('mechanicalturk:ListReviewPolicyResultsForHIT');
        return this;
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs() {
        this.to('mechanicalturk:ListReviewableHITs');
        return this;
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks() {
        this.to('mechanicalturk:ListWorkerBlocks');
        return this;
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType() {
        this.to('mechanicalturk:ListWorkersWithQualificationType');
        return this;
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers() {
        this.to('mechanicalturk:NotifyWorkers');
        return this;
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment() {
        this.to('mechanicalturk:RejectAssignment');
        return this;
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest() {
        this.to('mechanicalturk:RejectQualificationRequest');
        return this;
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus() {
        this.to('mechanicalturk:SendBonus');
        return this;
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification() {
        this.to('mechanicalturk:SendTestEventNotification');
        return this;
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT() {
        this.to('mechanicalturk:UpdateExpirationForHIT');
        return this;
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus() {
        this.to('mechanicalturk:UpdateHITReviewStatus');
        return this;
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT() {
        this.to('mechanicalturk:UpdateHITTypeOfHIT');
        return this;
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings() {
        this.to('mechanicalturk:UpdateNotificationSettings');
        return this;
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType() {
        this.to('mechanicalturk:UpdateQualificationType');
        return this;
    }
}
exports.Mechanicalturk = Mechanicalturk;
//# sourceMappingURL=data:application/json;base64,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