"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Tag = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Tag extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [tag](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonresourcegrouptaggingapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'tag';
        this.accessLevelList = {
            "Read": [
                "DescribeReportCreation",
                "GetComplianceSummary",
                "GetResources",
                "GetTagKeys",
                "GetTagValues"
            ],
            "Write": [
                "StartReportCreation"
            ],
            "Tagging": [
                "TagResources",
                "UntagResources"
            ]
        };
    }
    /**
     * Describe the status of the StartReportCreation operation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_DescribeReportCreation.html
     */
    toDescribeReportCreation() {
        this.to('tag:DescribeReportCreation');
        return this;
    }
    /**
     * Get a table that shows counts of resources that are noncompliant with their effective tag policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetComplianceSummary.html
     */
    toGetComplianceSummary() {
        this.to('tag:GetComplianceSummary');
        return this;
    }
    /**
     * Get tagged AWS resources that match the given tag filters
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html
     */
    toGetResources() {
        this.to('tag:GetResources');
        return this;
    }
    /**
     * Get all tagKeys for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagKeys.html
     */
    toGetTagKeys() {
        this.to('tag:GetTagKeys');
        return this;
    }
    /**
     * Get all tagValues for the account in the specific region
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetTagValues.html
     */
    toGetTagValues() {
        this.to('tag:GetTagValues');
        return this;
    }
    /**
     * Generate a report that lists all tagged resources in accounts across your organization, and whether each resource is compliant with the effective tag policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_StartReportCreation.html
     */
    toStartReportCreation() {
        this.to('tag:StartReportCreation');
        return this;
    }
    /**
     * Add tags to AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_TagResources.html
     */
    toTagResources() {
        this.to('tag:TagResources');
        return this;
    }
    /**
     * Remove tags from AWS resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_UntagResources.html
     */
    toUntagResources() {
        this.to('tag:UntagResources');
        return this;
    }
}
exports.Tag = Tag;
//# sourceMappingURL=data:application/json;base64,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