import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Deepracer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [deepracer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsdeepracer.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to clone existing DeepRacer models
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-clone-trained-model
     */
    toCloneReinforcementLearningModel(): this;
    /**
     * Grants permission to create resources needed by DeepRacer on behalf of the user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toCreateAccountResources(): this;
    /**
     * Grants permission to submit DeepRacer models to be evaluated for leaderboards
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toCreateLeaderboardSubmission(): this;
    /**
     * Grants permission to create reinforcement learning models for DeepRacer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toCreateReinforcementLearningModel(): this;
    /**
     * Grants permission to delete resources created by DeepRacer on behalf of the user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toDeleteAccountResources(): this;
    /**
     * Grants permission to delete DeepRacer models
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toDeleteModel(): this;
    /**
     * Grants permission to retrieve the resources created by DeepRacer on behalf of the user
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetAccountResources(): this;
    /**
     * Grants permission to retrieve the user's alias for submitting DeepRacer models to leaderboards
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetAlias(): this;
    /**
     * Grants permission to retrieve information about existing DeepRacer models' evaluation jobs
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toGetEvaluation(): this;
    /**
     * Grants permission to retrieve information about how the latest submitted DeepRacer model for a user performed on a leaderboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLatestUserSubmission(): this;
    /**
     * Grants permission to retrieve information about leaderboards
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetLeaderboard(): this;
    /**
     * Grants permission to retrieve information about existing DeepRacer models
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetModel(): this;
    /**
     * Grants permission to retrieve information about the performance of a user's DeepRacer model that got placed on a leaderboard
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toGetRankedUserSubmission(): this;
    /**
     * Grants permission to retrieve information about DeepRacer tracks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toGetTrack(): this;
    /**
     * Grants permission to retrieve information about existing DeepRacer models' training job
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toGetTrainingJob(): this;
    /**
     * Grants permission to list DeepRacer models' evaluation jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toListEvaluations(): this;
    /**
     * Grants permission to list all the submissions of DeepRacer models of a user on a leaderboard
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboardSubmissions(): this;
    /**
     * Grants permission to list all the available leaderboards
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toListLeaderboards(): this;
    /**
     * Grants permission to list all existing DeepRacer models
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListModels(): this;
    /**
     * Grants permission to list all DeepRacer tracks
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     */
    toListTracks(): this;
    /**
     * Grants permission to list DeepRacer models' training jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toListTrainingJobs(): this;
    /**
     * Grants permission to set the user's alias for submitting DeepRacer models to leaderboards
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     */
    toSetAlias(): this;
    /**
     * Grants permission to evaluate DeepRacer models in a simulated environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStartEvaluation(): this;
    /**
     * Grants permission to stop DeepRacer model evaluations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     */
    toStopEvaluation(): this;
    /**
     * Grants permission to stop training DeepRacer models
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     */
    toStopTrainingReinforcementLearningModel(): this;
    /**
     * Grants permission to test reward functions for correctness
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html#deepracer-train-models-define-reward-function
     */
    toTestRewardFunction(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type reinforcement_learning_model to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onReinforcementLearningModel(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type training_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-training-model.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTrainingJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-get-started-test-in-simulator.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type leaderboard_evaluation_job to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onLeaderboardEvaluationJob(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type track to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-console-train-evaluate-models.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTrack(resourceId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type leaderboard to the statement
     *
     * https://docs.aws.amazon.com/deepracer/latest/developerguide/deepracer-submit-model-to-leaderboard.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onLeaderboard(resourceId: string, region?: string, partition?: string): this;
}
