"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Iot = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [iot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Iot extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iot](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'iot';
        this.accessLevelList = {
            "Write": [
                "AcceptCertificateTransfer",
                "AddThingToBillingGroup",
                "AddThingToThingGroup",
                "AssociateTargetsWithJob",
                "AttachSecurityProfile",
                "AttachThingPrincipal",
                "CancelAuditMitigationActionsTask",
                "CancelAuditTask",
                "CancelCertificateTransfer",
                "CancelJob",
                "CancelJobExecution",
                "ClearDefaultAuthorizer",
                "CloseTunnel",
                "Connect",
                "CreateAuditSuppression",
                "CreateAuthorizer",
                "CreateCertificateFromCsr",
                "CreateDimension",
                "CreateDomainConfiguration",
                "CreateJob",
                "CreateKeysAndCertificate",
                "CreateMitigationAction",
                "CreateOTAUpdate",
                "CreatePolicy",
                "CreatePolicyVersion",
                "CreateProvisioningClaim",
                "CreateProvisioningTemplate",
                "CreateProvisioningTemplateVersion",
                "CreateRoleAlias",
                "CreateScheduledAudit",
                "CreateSecurityProfile",
                "CreateStream",
                "CreateThing",
                "CreateTopicRule",
                "DeleteAccountAuditConfiguration",
                "DeleteAuditSuppression",
                "DeleteAuthorizer",
                "DeleteCACertificate",
                "DeleteCertificate",
                "DeleteDimension",
                "DeleteDomainConfiguration",
                "DeleteJob",
                "DeleteJobExecution",
                "DeleteMitigationAction",
                "DeleteOTAUpdate",
                "DeletePolicy",
                "DeletePolicyVersion",
                "DeleteProvisioningTemplate",
                "DeleteProvisioningTemplateVersion",
                "DeleteRegistrationCode",
                "DeleteRoleAlias",
                "DeleteScheduledAudit",
                "DeleteSecurityProfile",
                "DeleteStream",
                "DeleteThing",
                "DeleteThingShadow",
                "DeleteTopicRule",
                "DeleteV2LoggingLevel",
                "DeprecateThingType",
                "DetachSecurityProfile",
                "DetachThingPrincipal",
                "DisableTopicRule",
                "EnableTopicRule",
                "OpenTunnel",
                "Publish",
                "Receive",
                "RegisterCACertificate",
                "RegisterCertificate",
                "RegisterCertificateWithoutCA",
                "RegisterThing",
                "RejectCertificateTransfer",
                "RemoveThingFromBillingGroup",
                "RemoveThingFromThingGroup",
                "ReplaceTopicRule",
                "SetLoggingOptions",
                "SetV2LoggingLevel",
                "SetV2LoggingOptions",
                "StartAuditMitigationActionsTask",
                "StartNextPendingJobExecution",
                "StartOnDemandAuditTask",
                "StartThingRegistrationTask",
                "StopThingRegistrationTask",
                "Subscribe",
                "TransferCertificate",
                "UpdateAccountAuditConfiguration",
                "UpdateAuditSuppression",
                "UpdateAuthorizer",
                "UpdateBillingGroup",
                "UpdateCACertificate",
                "UpdateCertificate",
                "UpdateDimension",
                "UpdateDomainConfiguration",
                "UpdateDynamicThingGroup",
                "UpdateEventConfigurations",
                "UpdateIndexingConfiguration",
                "UpdateJob",
                "UpdateJobExecution",
                "UpdateMitigationAction",
                "UpdateProvisioningTemplate",
                "UpdateRoleAlias",
                "UpdateScheduledAudit",
                "UpdateSecurityProfile",
                "UpdateStream",
                "UpdateThing",
                "UpdateThingGroup",
                "UpdateThingGroupsForThing",
                "UpdateThingShadow"
            ],
            "Permissions management": [
                "AttachPolicy",
                "AttachPrincipalPolicy",
                "DetachPolicy",
                "DetachPrincipalPolicy",
                "SetDefaultAuthorizer",
                "SetDefaultPolicyVersion"
            ],
            "Tagging": [
                "CreateBillingGroup",
                "CreateDynamicThingGroup",
                "CreateThingGroup",
                "CreateThingType",
                "DeleteBillingGroup",
                "DeleteDynamicThingGroup",
                "DeleteThingGroup",
                "DeleteThingType",
                "TagResource",
                "UntagResource"
            ],
            "Read": [
                "DescribeAccountAuditConfiguration",
                "DescribeAuditFinding",
                "DescribeAuditMitigationActionsTask",
                "DescribeAuditSuppression",
                "DescribeAuditTask",
                "DescribeAuthorizer",
                "DescribeBillingGroup",
                "DescribeCACertificate",
                "DescribeCertificate",
                "DescribeDefaultAuthorizer",
                "DescribeDimension",
                "DescribeDomainConfiguration",
                "DescribeEndpoint",
                "DescribeEventConfigurations",
                "DescribeIndex",
                "DescribeJob",
                "DescribeJobExecution",
                "DescribeMitigationAction",
                "DescribeProvisioningTemplate",
                "DescribeProvisioningTemplateVersion",
                "DescribeRoleAlias",
                "DescribeScheduledAudit",
                "DescribeSecurityProfile",
                "DescribeStream",
                "DescribeThing",
                "DescribeThingGroup",
                "DescribeThingRegistrationTask",
                "DescribeThingType",
                "DescribeTunnel",
                "GetCardinality",
                "GetEffectivePolicies",
                "GetIndexingConfiguration",
                "GetJobDocument",
                "GetLoggingOptions",
                "GetOTAUpdate",
                "GetPendingJobExecutions",
                "GetPercentiles",
                "GetPolicy",
                "GetPolicyVersion",
                "GetRegistrationCode",
                "GetStatistics",
                "GetThingShadow",
                "GetTopicRule",
                "GetV2LoggingOptions",
                "SearchIndex",
                "TestAuthorization",
                "TestInvokeAuthorizer",
                "ValidateSecurityProfileBehaviors"
            ],
            "List": [
                "ListActiveViolations",
                "ListAttachedPolicies",
                "ListAuditFindings",
                "ListAuditMitigationActionsExecutions",
                "ListAuditMitigationActionsTasks",
                "ListAuditSuppressions",
                "ListAuditTasks",
                "ListAuthorizers",
                "ListBillingGroups",
                "ListCACertificates",
                "ListCertificates",
                "ListCertificatesByCA",
                "ListDimensions",
                "ListDomainConfigurations",
                "ListIndices",
                "ListJobExecutionsForJob",
                "ListJobExecutionsForThing",
                "ListJobs",
                "ListMitigationActions",
                "ListNamedShadowsForThing",
                "ListOTAUpdates",
                "ListOutgoingCertificates",
                "ListPolicies",
                "ListPolicyPrincipals",
                "ListPolicyVersions",
                "ListPrincipalPolicies",
                "ListPrincipalThings",
                "ListProvisioningTemplateVersions",
                "ListProvisioningTemplates",
                "ListRoleAliases",
                "ListScheduledAudits",
                "ListSecurityProfiles",
                "ListSecurityProfilesForTarget",
                "ListStreams",
                "ListTagsForResource",
                "ListTargetsForPolicy",
                "ListTargetsForSecurityProfile",
                "ListThingGroups",
                "ListThingGroupsForThing",
                "ListThingPrincipals",
                "ListThingRegistrationTaskReports",
                "ListThingRegistrationTasks",
                "ListThingTypes",
                "ListThings",
                "ListThingsInBillingGroup",
                "ListThingsInThingGroup",
                "ListTopicRules",
                "ListTunnels",
                "ListV2LoggingLevels",
                "ListViolationEvents"
            ]
        };
    }
    /**
     * Accepts a pending certificate transfer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AcceptCertificateTransfer.html
     */
    toAcceptCertificateTransfer() {
        this.to('iot:AcceptCertificateTransfer');
        return this;
    }
    /**
     * Adds a thing to the specified billing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AddThingToBillingGroup.html
     */
    toAddThingToBillingGroup() {
        this.to('iot:AddThingToBillingGroup');
        return this;
    }
    /**
     * Adds a thing to the specified thing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AddThingToThingGroup.html
     */
    toAddThingToThingGroup() {
        this.to('iot:AddThingToThingGroup');
        return this;
    }
    /**
     * Associates a group with a continuous job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AssociateTargetsWithJob.html
     */
    toAssociateTargetsWithJob() {
        this.to('iot:AssociateTargetsWithJob');
        return this;
    }
    /**
     * Attaches a policy to the specified target.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AttachPolicy.html
     */
    toAttachPolicy() {
        this.to('iot:AttachPolicy');
        return this;
    }
    /**
     * Attaches the specified policy to the specified principal (certificate or other credential).
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AttachPrincipalPolicy.html
     */
    toAttachPrincipalPolicy() {
        this.to('iot:AttachPrincipalPolicy');
        return this;
    }
    /**
     * Associates a Device Defender security profile with a thing group or with this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AttachSecurityProfile.html
     */
    toAttachSecurityProfile() {
        this.to('iot:AttachSecurityProfile');
        return this;
    }
    /**
     * Attaches the specified principal to the specified thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_AttachThingPrincipal.html
     */
    toAttachThingPrincipal() {
        this.to('iot:AttachThingPrincipal');
        return this;
    }
    /**
     * Cancels a mitigation action task that is in progress.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CancelAuditMitigationActionsTask.html
     */
    toCancelAuditMitigationActionsTask() {
        this.to('iot:CancelAuditMitigationActionsTask');
        return this;
    }
    /**
     * Cancels an audit that is in progress. The audit can be either scheduled or on-demand.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CancelAuditTask.html
     */
    toCancelAuditTask() {
        this.to('iot:CancelAuditTask');
        return this;
    }
    /**
     * Cancels a pending transfer for the specified certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CancelCertificateTransfer.html
     */
    toCancelCertificateTransfer() {
        this.to('iot:CancelCertificateTransfer');
        return this;
    }
    /**
     * Cancels a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CancelJob.html
     */
    toCancelJob() {
        this.to('iot:CancelJob');
        return this;
    }
    /**
     * Cancels a job execution on a particular device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CancelJobExecution.html
     */
    toCancelJobExecution() {
        this.to('iot:CancelJobExecution');
        return this;
    }
    /**
     * Clears the default authorizer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ClearDefaultAuthorizer.html
     */
    toClearDefaultAuthorizer() {
        this.to('iot:ClearDefaultAuthorizer');
        return this;
    }
    /**
     * Closes a tunnel.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifDelete()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CloseTunnel.html
     */
    toCloseTunnel() {
        this.to('iot:CloseTunnel');
        return this;
    }
    /**
     * Connect as the specified client
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toConnect() {
        this.to('iot:Connect');
        return this;
    }
    /**
     * Creates a Device Defender audit suppression.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateAuditSuppression.html
     */
    toCreateAuditSuppression() {
        this.to('iot:CreateAuditSuppression');
        return this;
    }
    /**
     * Creates an authorizer.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateAuthorizer.html
     */
    toCreateAuthorizer() {
        this.to('iot:CreateAuthorizer');
        return this;
    }
    /**
     * Creates a billing group.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateBillingGroup.html
     */
    toCreateBillingGroup() {
        this.to('iot:CreateBillingGroup');
        return this;
    }
    /**
     * Creates an X.509 certificate using the specified certificate signing request.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCertificateFromCsr.html
     */
    toCreateCertificateFromCsr() {
        this.to('iot:CreateCertificateFromCsr');
        return this;
    }
    /**
     * Defines a dimension that can be used to to limit the scope of a metric used in a security profile.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateDimension.html
     */
    toCreateDimension() {
        this.to('iot:CreateDimension');
        return this;
    }
    /**
     * Creates a domain configuration.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifDomainName()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateDomainConfiguration.html
     */
    toCreateDomainConfiguration() {
        this.to('iot:CreateDomainConfiguration');
        return this;
    }
    /**
     * Creates a Dynamic Thing Group
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateDynamicThingGroup.html
     */
    toCreateDynamicThingGroup() {
        this.to('iot:CreateDynamicThingGroup');
        return this;
    }
    /**
     * Creates a job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateJob.html
     */
    toCreateJob() {
        this.to('iot:CreateJob');
        return this;
    }
    /**
     * Creates a 2048 bit RSA key pair and issues an X.509 certificate using the issued public key.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateKeysAndCertificate.html
     */
    toCreateKeysAndCertificate() {
        this.to('iot:CreateKeysAndCertificate');
        return this;
    }
    /**
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateMitigationAction.html
     */
    toCreateMitigationAction() {
        this.to('iot:CreateMitigationAction');
        return this;
    }
    /**
     * Creates an OTA update job.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateOTAUpdate.html
     */
    toCreateOTAUpdate() {
        this.to('iot:CreateOTAUpdate');
        return this;
    }
    /**
     * Creates an AWS IoT policy.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreatePolicy.html
     */
    toCreatePolicy() {
        this.to('iot:CreatePolicy');
        return this;
    }
    /**
     * Creates a new version of the specified AWS IoT policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreatePolicyVersion.html
     */
    toCreatePolicyVersion() {
        this.to('iot:CreatePolicyVersion');
        return this;
    }
    /**
     * Creates a provisioning claim.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningClaim.html
     */
    toCreateProvisioningClaim() {
        this.to('iot:CreateProvisioningClaim');
        return this;
    }
    /**
     * Creates a fleet provisioning template.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplate.html
     */
    toCreateProvisioningTemplate() {
        this.to('iot:CreateProvisioningTemplate');
        return this;
    }
    /**
     * Creates a new version of a fleet provisioning template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateProvisioningTemplateVersion.html
     */
    toCreateProvisioningTemplateVersion() {
        this.to('iot:CreateProvisioningTemplateVersion');
        return this;
    }
    /**
     * Creates a role alias.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateRoleAlias.html
     */
    toCreateRoleAlias() {
        this.to('iot:CreateRoleAlias');
        return this;
    }
    /**
     * Creates a scheduled audit that is run at a specified time interval.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateScheduledAudit.html
     */
    toCreateScheduledAudit() {
        this.to('iot:CreateScheduledAudit');
        return this;
    }
    /**
     * Creates a Device Defender security profile.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateSecurityProfile.html
     */
    toCreateSecurityProfile() {
        this.to('iot:CreateSecurityProfile');
        return this;
    }
    /**
     * Creates a new AWS IoT stream
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateStream.html
     */
    toCreateStream() {
        this.to('iot:CreateStream');
        return this;
    }
    /**
     * Creates a thing in the thing registry.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateThing.html
     */
    toCreateThing() {
        this.to('iot:CreateThing');
        return this;
    }
    /**
     * Creates a thing group.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateThingGroup.html
     */
    toCreateThingGroup() {
        this.to('iot:CreateThingGroup');
        return this;
    }
    /**
     * Creates a new thing type.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateThingType.html
     */
    toCreateThingType() {
        this.to('iot:CreateThingType');
        return this;
    }
    /**
     * Creates a rule.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_CreateTopicRule.html
     */
    toCreateTopicRule() {
        this.to('iot:CreateTopicRule');
        return this;
    }
    /**
     * Deletes the audit configuration associated with the account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteAccountAuditConfiguration.html
     */
    toDeleteAccountAuditConfiguration() {
        this.to('iot:DeleteAccountAuditConfiguration');
        return this;
    }
    /**
     * Deletes a Device Defender audit suppression.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteAuditSuppression.html
     */
    toDeleteAuditSuppression() {
        this.to('iot:DeleteAuditSuppression');
        return this;
    }
    /**
     * Deletes the specified authorizer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteAuthorizer.html
     */
    toDeleteAuthorizer() {
        this.to('iot:DeleteAuthorizer');
        return this;
    }
    /**
     * Deletes the specified billing group.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteBillingGroup.html
     */
    toDeleteBillingGroup() {
        this.to('iot:DeleteBillingGroup');
        return this;
    }
    /**
     * Deletes a registered CA certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteCACertificate.html
     */
    toDeleteCACertificate() {
        this.to('iot:DeleteCACertificate');
        return this;
    }
    /**
     * Deletes the specified certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteCertificate.html
     */
    toDeleteCertificate() {
        this.to('iot:DeleteCertificate');
        return this;
    }
    /**
     * Removes the specified dimension from your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteDimension.html
     */
    toDeleteDimension() {
        this.to('iot:DeleteDimension');
        return this;
    }
    /**
     * Deletes a domain configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteDomainConfiguration.html
     */
    toDeleteDomainConfiguration() {
        this.to('iot:DeleteDomainConfiguration');
        return this;
    }
    /**
     * Deletes the specified Dynamic Thing Group
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteDynamicThingGroup.html
     */
    toDeleteDynamicThingGroup() {
        this.to('iot:DeleteDynamicThingGroup');
        return this;
    }
    /**
     * Deletes a job and its related job executions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteJob.html
     */
    toDeleteJob() {
        this.to('iot:DeleteJob');
        return this;
    }
    /**
     * Deletes a job execution.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteJobExecution.html
     */
    toDeleteJobExecution() {
        this.to('iot:DeleteJobExecution');
        return this;
    }
    /**
     * Deletes a defined mitigation action from your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteMitigationAction.html
     */
    toDeleteMitigationAction() {
        this.to('iot:DeleteMitigationAction');
        return this;
    }
    /**
     * Deletes an OTA update job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteOTAUpdate.html
     */
    toDeleteOTAUpdate() {
        this.to('iot:DeleteOTAUpdate');
        return this;
    }
    /**
     * Deletes the specified policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeletePolicy.html
     */
    toDeletePolicy() {
        this.to('iot:DeletePolicy');
        return this;
    }
    /**
     * Deletes the specified version of the specified policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeletePolicyVersion.html
     */
    toDeletePolicyVersion() {
        this.to('iot:DeletePolicyVersion');
        return this;
    }
    /**
     * Deletes a fleet provisioning template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteProvisioningTemplate.html
     */
    toDeleteProvisioningTemplate() {
        this.to('iot:DeleteProvisioningTemplate');
        return this;
    }
    /**
     * Deletes a fleet provisioning template version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteProvisioningTemplateVersion.html
     */
    toDeleteProvisioningTemplateVersion() {
        this.to('iot:DeleteProvisioningTemplateVersion');
        return this;
    }
    /**
     * Deletes a CA certificate registration code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteRegistrationCode.html
     */
    toDeleteRegistrationCode() {
        this.to('iot:DeleteRegistrationCode');
        return this;
    }
    /**
     * Deletes the specified role alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteRoleAlias.html
     */
    toDeleteRoleAlias() {
        this.to('iot:DeleteRoleAlias');
        return this;
    }
    /**
     * Deletes a scheduled audit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteScheduledAudit.html
     */
    toDeleteScheduledAudit() {
        this.to('iot:DeleteScheduledAudit');
        return this;
    }
    /**
     * Deletes a Device Defender security profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteSecurityProfile.html
     */
    toDeleteSecurityProfile() {
        this.to('iot:DeleteSecurityProfile');
        return this;
    }
    /**
     * Deletes a specified stream.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteStream.html
     */
    toDeleteStream() {
        this.to('iot:DeleteStream');
        return this;
    }
    /**
     * Deletes the specified thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThing.html
     */
    toDeleteThing() {
        this.to('iot:DeleteThing');
        return this;
    }
    /**
     * Deletes the specified thing group.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThingGroup.html
     */
    toDeleteThingGroup() {
        this.to('iot:DeleteThingGroup');
        return this;
    }
    /**
     * Deletes the specified thing shadow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toDeleteThingShadow() {
        this.to('iot:DeleteThingShadow');
        return this;
    }
    /**
     * Deletes the specified thing type.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteThingType.html
     */
    toDeleteThingType() {
        this.to('iot:DeleteThingType');
        return this;
    }
    /**
     * Deletes the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteTopicRule.html
     */
    toDeleteTopicRule() {
        this.to('iot:DeleteTopicRule');
        return this;
    }
    /**
     * Deletes the specified v2 logging level.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeleteV2LoggingLevel.html
     */
    toDeleteV2LoggingLevel() {
        this.to('iot:DeleteV2LoggingLevel');
        return this;
    }
    /**
     * Deprecates the specified thing type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DeprecateThingType.html
     */
    toDeprecateThingType() {
        this.to('iot:DeprecateThingType');
        return this;
    }
    /**
     * Gets information about audit configurations for the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAccountAuditConfiguration.html
     */
    toDescribeAccountAuditConfiguration() {
        this.to('iot:DescribeAccountAuditConfiguration');
        return this;
    }
    /**
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of the issue, and when the audit that returned the finding was started.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html
     */
    toDescribeAuditFinding() {
        this.to('iot:DescribeAuditFinding');
        return this;
    }
    /**
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit findings.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditMitigationActionsTask.html
     */
    toDescribeAuditMitigationActionsTask() {
        this.to('iot:DescribeAuditMitigationActionsTask');
        return this;
    }
    /**
     * Gets information about a Device Defender audit suppression.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditSuppression.html
     */
    toDescribeAuditSuppression() {
        this.to('iot:DescribeAuditSuppression');
        return this;
    }
    /**
     * Gets information about a Device Defender audit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditTask.html
     */
    toDescribeAuditTask() {
        this.to('iot:DescribeAuditTask');
        return this;
    }
    /**
     * Describes an authorizer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuthorizer.html
     */
    toDescribeAuthorizer() {
        this.to('iot:DescribeAuthorizer');
        return this;
    }
    /**
     * Gets information about the specified billing group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeBillingGroup.html
     */
    toDescribeBillingGroup() {
        this.to('iot:DescribeBillingGroup');
        return this;
    }
    /**
     * Describes a registered CA certificate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeCACertificate.html
     */
    toDescribeCACertificate() {
        this.to('iot:DescribeCACertificate');
        return this;
    }
    /**
     * Gets information about the specified certificate.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeCertificate.html
     */
    toDescribeCertificate() {
        this.to('iot:DescribeCertificate');
        return this;
    }
    /**
     * Describes the default authorizer.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeDefaultAuthorizer.html
     */
    toDescribeDefaultAuthorizer() {
        this.to('iot:DescribeDefaultAuthorizer');
        return this;
    }
    /**
     * Provides details about a dimension that is defined in your AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeDimension.html
     */
    toDescribeDimension() {
        this.to('iot:DescribeDimension');
        return this;
    }
    /**
     * Gets information about the domain configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeDomainConfiguration.html
     */
    toDescribeDomainConfiguration() {
        this.to('iot:DescribeDomainConfiguration');
        return this;
    }
    /**
     * Returns a unique endpoint specific to the AWS account making the call.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeEndpoint.html
     */
    toDescribeEndpoint() {
        this.to('iot:DescribeEndpoint');
        return this;
    }
    /**
     * Returns account event configurations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeEventConfigurations.html
     */
    toDescribeEventConfigurations() {
        this.to('iot:DescribeEventConfigurations');
        return this;
    }
    /**
     * Gets information about the specified index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeIndex.html
     */
    toDescribeIndex() {
        this.to('iot:DescribeIndex');
        return this;
    }
    /**
     * Describes a job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeJob.html
     */
    toDescribeJob() {
        this.to('iot:DescribeJob');
        return this;
    }
    /**
     * Describes a job execution.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeJobExecution.html
     */
    toDescribeJobExecution() {
        this.to('iot:DescribeJobExecution');
        return this;
    }
    /**
     * Gets information about a mitigation action.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeMitigationAction.html
     */
    toDescribeMitigationAction() {
        this.to('iot:DescribeMitigationAction');
        return this;
    }
    /**
     * Returns information about a fleet provisioning template.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeProvisioningTemplate.html
     */
    toDescribeProvisioningTemplate() {
        this.to('iot:DescribeProvisioningTemplate');
        return this;
    }
    /**
     * Returns information about a fleet provisioning template version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeProvisioningTemplateVersion.html
     */
    toDescribeProvisioningTemplateVersion() {
        this.to('iot:DescribeProvisioningTemplateVersion');
        return this;
    }
    /**
     * Describes a role alias.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeRoleAlias.html
     */
    toDescribeRoleAlias() {
        this.to('iot:DescribeRoleAlias');
        return this;
    }
    /**
     * Gets information about a scheduled audit.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeScheduledAudit.html
     */
    toDescribeScheduledAudit() {
        this.to('iot:DescribeScheduledAudit');
        return this;
    }
    /**
     * Gets information about a Device Defender security profile.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeSecurityProfile.html
     */
    toDescribeSecurityProfile() {
        this.to('iot:DescribeSecurityProfile');
        return this;
    }
    /**
     * Gets information about the specified stream.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeStream.html
     */
    toDescribeStream() {
        this.to('iot:DescribeStream');
        return this;
    }
    /**
     * Gets information about the specified thing.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeThing.html
     */
    toDescribeThing() {
        this.to('iot:DescribeThing');
        return this;
    }
    /**
     * Gets information about the specified thing group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeThingGroup.html
     */
    toDescribeThingGroup() {
        this.to('iot:DescribeThingGroup');
        return this;
    }
    /**
     * Gets information about the bulk thing registration task.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeThingRegistrationTask.html
     */
    toDescribeThingRegistrationTask() {
        this.to('iot:DescribeThingRegistrationTask');
        return this;
    }
    /**
     * Gets information about the specified thing type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeThingType.html
     */
    toDescribeThingType() {
        this.to('iot:DescribeThingType');
        return this;
    }
    /**
     * Describes a tunnel.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeTunnel.html
     */
    toDescribeTunnel() {
        this.to('iot:DescribeTunnel');
        return this;
    }
    /**
     * Detaches a policy from the specified target.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DetachPolicy.html
     */
    toDetachPolicy() {
        this.to('iot:DetachPolicy');
        return this;
    }
    /**
     * Removes the specified policy from the specified certificate.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DetachPrincipalPolicy.html
     */
    toDetachPrincipalPolicy() {
        this.to('iot:DetachPrincipalPolicy');
        return this;
    }
    /**
     * Disassociates a Device Defender security profile from a thing group or from this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DetachSecurityProfile.html
     */
    toDetachSecurityProfile() {
        this.to('iot:DetachSecurityProfile');
        return this;
    }
    /**
     * Detaches the specified principal from the specified thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DetachThingPrincipal.html
     */
    toDetachThingPrincipal() {
        this.to('iot:DetachThingPrincipal');
        return this;
    }
    /**
     * Disables the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_DisableTopicRule.html
     */
    toDisableTopicRule() {
        this.to('iot:DisableTopicRule');
        return this;
    }
    /**
     * Enables the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_EnableTopicRule.html
     */
    toEnableTopicRule() {
        this.to('iot:EnableTopicRule');
        return this;
    }
    /**
     * Get cardinality for IoT fleet index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetCardinality.html
     */
    toGetCardinality() {
        this.to('iot:GetCardinality');
        return this;
    }
    /**
     * Gets effective policies.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetEffectivePolicies.html
     */
    toGetEffectivePolicies() {
        this.to('iot:GetEffectivePolicies');
        return this;
    }
    /**
     * Gets current fleet indexing configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetIndexingConfiguration.html
     */
    toGetIndexingConfiguration() {
        this.to('iot:GetIndexingConfiguration');
        return this;
    }
    /**
     * Gets a job document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetJobDocument.html
     */
    toGetJobDocument() {
        this.to('iot:GetJobDocument');
        return this;
    }
    /**
     * Gets the logging options.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetLoggingOptions.html
     */
    toGetLoggingOptions() {
        this.to('iot:GetLoggingOptions');
        return this;
    }
    /**
     * Gets the information about the OTA update job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetOTAUpdate.html
     */
    toGetOTAUpdate() {
        this.to('iot:GetOTAUpdate');
        return this;
    }
    /**
     * Gets the list of all jobs for a thing that are not in a terminal state.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetPendingJobExecutions.html
     */
    toGetPendingJobExecutions() {
        this.to('iot:GetPendingJobExecutions');
        return this;
    }
    /**
     * Get percentiles for IoT fleet index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetPercentiles.html
     */
    toGetPercentiles() {
        this.to('iot:GetPercentiles');
        return this;
    }
    /**
     * Gets information about the specified policy with the policy document of the default version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetPolicy.html
     */
    toGetPolicy() {
        this.to('iot:GetPolicy');
        return this;
    }
    /**
     * Gets information about the specified policy version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetPolicyVersion.html
     */
    toGetPolicyVersion() {
        this.to('iot:GetPolicyVersion');
        return this;
    }
    /**
     * Gets a registration code used to register a CA certificate with AWS IoT.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetRegistrationCode.html
     */
    toGetRegistrationCode() {
        this.to('iot:GetRegistrationCode');
        return this;
    }
    /**
     * Get statistics for IoT fleet index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetStatistics.html
     */
    toGetStatistics() {
        this.to('iot:GetStatistics');
        return this;
    }
    /**
     * Gets the thing shadow.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toGetThingShadow() {
        this.to('iot:GetThingShadow');
        return this;
    }
    /**
     * Gets information about the specified rule.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetTopicRule.html
     */
    toGetTopicRule() {
        this.to('iot:GetTopicRule');
        return this;
    }
    /**
     * Gets v2 logging options.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_GetV2LoggingOptions.html
     */
    toGetV2LoggingOptions() {
        this.to('iot:GetV2LoggingOptions');
        return this;
    }
    /**
     * Lists the active violations for a given Device Defender security profile or Thing.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListActiveViolations.html
     */
    toListActiveViolations() {
        this.to('iot:ListActiveViolations');
        return this;
    }
    /**
     * Lists the policies attached to the specified thing group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAttachedPolicies.html
     */
    toListAttachedPolicies() {
        this.to('iot:ListAttachedPolicies');
        return this;
    }
    /**
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuditFindings.html
     */
    toListAuditFindings() {
        this.to('iot:ListAuditFindings');
        return this;
    }
    /**
     * Gets the status of audit mitigation action tasks that were executed.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuditMitigationActionsExecutions.html
     */
    toListAuditMitigationActionsExecutions() {
        this.to('iot:ListAuditMitigationActionsExecutions');
        return this;
    }
    /**
     * Gets a list of audit mitigation action tasks that match the specified filters.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuditMitigationActionsTasks.html
     */
    toListAuditMitigationActionsTasks() {
        this.to('iot:ListAuditMitigationActionsTasks');
        return this;
    }
    /**
     * Lists your Device Defender audit suppressions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuditSuppressions.html
     */
    toListAuditSuppressions() {
        this.to('iot:ListAuditSuppressions');
        return this;
    }
    /**
     * Lists the Device Defender audits that have been performed during a given time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuditTasks.html
     */
    toListAuditTasks() {
        this.to('iot:ListAuditTasks');
        return this;
    }
    /**
     * Lists the authorizers registered in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListAuthorizers.html
     */
    toListAuthorizers() {
        this.to('iot:ListAuthorizers');
        return this;
    }
    /**
     * Lists all billing groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListBillingGroups.html
     */
    toListBillingGroups() {
        this.to('iot:ListBillingGroups');
        return this;
    }
    /**
     * Lists the CA certificates registered for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListCACertificates.html
     */
    toListCACertificates() {
        this.to('iot:ListCACertificates');
        return this;
    }
    /**
     * Lists your certificates.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListCertificates.html
     */
    toListCertificates() {
        this.to('iot:ListCertificates');
        return this;
    }
    /**
     * List the device certificates signed by the specified CA certificate.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListCertificatesByCA.html
     */
    toListCertificatesByCA() {
        this.to('iot:ListCertificatesByCA');
        return this;
    }
    /**
     * Lists the dimensions that are defined for your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListDimensions.html
     */
    toListDimensions() {
        this.to('iot:ListDimensions');
        return this;
    }
    /**
     * Lists the domain configuration created by your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListDomainConfigurations.html
     */
    toListDomainConfigurations() {
        this.to('iot:ListDomainConfigurations');
        return this;
    }
    /**
     * Lists all indices for fleet index
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListIndices.html
     */
    toListIndices() {
        this.to('iot:ListIndices');
        return this;
    }
    /**
     * Lists the job executions for a job.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListJobExecutionsForJob.html
     */
    toListJobExecutionsForJob() {
        this.to('iot:ListJobExecutionsForJob');
        return this;
    }
    /**
     * Lists the job executions for the specified thing.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListJobExecutionsForThing.html
     */
    toListJobExecutionsForThing() {
        this.to('iot:ListJobExecutionsForThing');
        return this;
    }
    /**
     * Lists jobs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListJobs.html
     */
    toListJobs() {
        this.to('iot:ListJobs');
        return this;
    }
    /**
     * Gets a list of all mitigation actions that match the specified filter criteria.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListMitigationActions.html
     */
    toListMitigationActions() {
        this.to('iot:ListMitigationActions');
        return this;
    }
    /**
     * Lists all named shadows for a given thing.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListNamedShadowsForThing.html
     */
    toListNamedShadowsForThing() {
        this.to('iot:ListNamedShadowsForThing');
        return this;
    }
    /**
     * Lists OTA update jobs in the account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListOTAUpdates.html
     */
    toListOTAUpdates() {
        this.to('iot:ListOTAUpdates');
        return this;
    }
    /**
     * Lists certificates that are being transfered but not yet accepted.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListOutgoingCertificates.html
     */
    toListOutgoingCertificates() {
        this.to('iot:ListOutgoingCertificates');
        return this;
    }
    /**
     * Lists your policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListPolicies.html
     */
    toListPolicies() {
        this.to('iot:ListPolicies');
        return this;
    }
    /**
     * Lists the principals associated with the specified policy.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListPolicyPrincipals.html
     */
    toListPolicyPrincipals() {
        this.to('iot:ListPolicyPrincipals');
        return this;
    }
    /**
     * Lists the versions of the specified policy, and identifies the default version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListPolicyVersions.html
     */
    toListPolicyVersions() {
        this.to('iot:ListPolicyVersions');
        return this;
    }
    /**
     * Lists the policies attached to the specified principal. If you use an Amazon Cognito identity, the ID needs to be in Amazon Cognito Identity format.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListPrincipalPolicies.html
     */
    toListPrincipalPolicies() {
        this.to('iot:ListPrincipalPolicies');
        return this;
    }
    /**
     * Lists the things associated with the specified principal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListPrincipalThings.html
     */
    toListPrincipalThings() {
        this.to('iot:ListPrincipalThings');
        return this;
    }
    /**
     * A list of fleet provisioning template versions.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListProvisioningTemplateVersions.html
     */
    toListProvisioningTemplateVersions() {
        this.to('iot:ListProvisioningTemplateVersions');
        return this;
    }
    /**
     * Lists the fleet provisioning templates in your AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListProvisioningTemplates.html
     */
    toListProvisioningTemplates() {
        this.to('iot:ListProvisioningTemplates');
        return this;
    }
    /**
     * Lists role aliases.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListRoleAliases.html
     */
    toListRoleAliases() {
        this.to('iot:ListRoleAliases');
        return this;
    }
    /**
     * Lists all of your scheduled audits.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListScheduledAudits.html
     */
    toListScheduledAudits() {
        this.to('iot:ListScheduledAudits');
        return this;
    }
    /**
     * Lists the Device Defender security profiles you have created.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html
     */
    toListSecurityProfiles() {
        this.to('iot:ListSecurityProfiles');
        return this;
    }
    /**
     * Lists the Device Defender security profiles attached to a target.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfilesForTarget.html
     */
    toListSecurityProfilesForTarget() {
        this.to('iot:ListSecurityProfilesForTarget');
        return this;
    }
    /**
     * Lists the streams in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListStreams.html
     */
    toListStreams() {
        this.to('iot:ListStreams');
        return this;
    }
    /**
     * Lists all tags for a given resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        this.to('iot:ListTagsForResource');
        return this;
    }
    /**
     * List targets for the specified policy.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListTargetsForPolicy.html
     */
    toListTargetsForPolicy() {
        this.to('iot:ListTargetsForPolicy');
        return this;
    }
    /**
     * Lists the targets associated with a given Device Defender security profile.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListTargetsForSecurityProfile.html
     */
    toListTargetsForSecurityProfile() {
        this.to('iot:ListTargetsForSecurityProfile');
        return this;
    }
    /**
     * Lists all thing groups.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingGroups.html
     */
    toListThingGroups() {
        this.to('iot:ListThingGroups');
        return this;
    }
    /**
     * List thing groups to which the specified thing belongs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingGroupsForThing.html
     */
    toListThingGroupsForThing() {
        this.to('iot:ListThingGroupsForThing');
        return this;
    }
    /**
     * Lists the principals associated with the specified thing.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingPrincipals.html
     */
    toListThingPrincipals() {
        this.to('iot:ListThingPrincipals');
        return this;
    }
    /**
     * Lists information about bulk thing registration tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingRegistrationTaskReports.html
     */
    toListThingRegistrationTaskReports() {
        this.to('iot:ListThingRegistrationTaskReports');
        return this;
    }
    /**
     * Lists bulk thing registration tasks.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingRegistrationTasks.html
     */
    toListThingRegistrationTasks() {
        this.to('iot:ListThingRegistrationTasks');
        return this;
    }
    /**
     * Lists all thing types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingTypes.html
     */
    toListThingTypes() {
        this.to('iot:ListThingTypes');
        return this;
    }
    /**
     * Lists all things.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThings.html
     */
    toListThings() {
        this.to('iot:ListThings');
        return this;
    }
    /**
     * Lists all things in the specified billing group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingsInBillingGroup.html
     */
    toListThingsInBillingGroup() {
        this.to('iot:ListThingsInBillingGroup');
        return this;
    }
    /**
     * Lists all things in the specified thing group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListThingsInThingGroup.html
     */
    toListThingsInThingGroup() {
        this.to('iot:ListThingsInThingGroup');
        return this;
    }
    /**
     * Lists the rules for the specific topic.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListTopicRules.html
     */
    toListTopicRules() {
        this.to('iot:ListTopicRules');
        return this;
    }
    /**
     * Lists tunnels.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListTunnels.html
     */
    toListTunnels() {
        this.to('iot:ListTunnels');
        return this;
    }
    /**
     * Lists the v2 logging levels.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListV2LoggingLevels.html
     */
    toListV2LoggingLevels() {
        this.to('iot:ListV2LoggingLevels');
        return this;
    }
    /**
     * Lists the Device Defender security profile violations discovered during the given time period.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ListViolationEvents.html
     */
    toListViolationEvents() {
        this.to('iot:ListViolationEvents');
        return this;
    }
    /**
     * Opens a tunnel.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     * - .ifThingGroupArn()
     * - .ifTunnelDestinationService()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_OpenTunnel.html
     */
    toOpenTunnel() {
        this.to('iot:OpenTunnel');
        return this;
    }
    /**
     * Publish to the specified topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toPublish() {
        this.to('iot:Publish');
        return this;
    }
    /**
     * Receive from the specified topic.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toReceive() {
        this.to('iot:Receive');
        return this;
    }
    /**
     * Registers a CA certificate with AWS IoT.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCACertificate.html
     */
    toRegisterCACertificate() {
        this.to('iot:RegisterCACertificate');
        return this;
    }
    /**
     * Registers a device certificate with AWS IoT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificate.html
     */
    toRegisterCertificate() {
        this.to('iot:RegisterCertificate');
        return this;
    }
    /**
     * Registers a device certificate with AWS IoT without a registered CA (certificate authority).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterCertificateWithoutCA.html
     */
    toRegisterCertificateWithoutCA() {
        this.to('iot:RegisterCertificateWithoutCA');
        return this;
    }
    /**
     * Registers your thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RegisterThing.html
     */
    toRegisterThing() {
        this.to('iot:RegisterThing');
        return this;
    }
    /**
     * Rejects a pending certificate transfer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RejectCertificateTransfer.html
     */
    toRejectCertificateTransfer() {
        this.to('iot:RejectCertificateTransfer');
        return this;
    }
    /**
     * Removes thing from the specified billing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RemoveThingFromBillingGroup.html
     */
    toRemoveThingFromBillingGroup() {
        this.to('iot:RemoveThingFromBillingGroup');
        return this;
    }
    /**
     * Removes thing from the specified thing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_RemoveThingFromThingGroup.html
     */
    toRemoveThingFromThingGroup() {
        this.to('iot:RemoveThingFromThingGroup');
        return this;
    }
    /**
     * Replaces the specified rule.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ReplaceTopicRule.html
     */
    toReplaceTopicRule() {
        this.to('iot:ReplaceTopicRule');
        return this;
    }
    /**
     * Search IoT fleet index
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SearchIndex.html
     */
    toSearchIndex() {
        this.to('iot:SearchIndex');
        return this;
    }
    /**
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an authorizer.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SetDefaultAuthorizer.html
     */
    toSetDefaultAuthorizer() {
        this.to('iot:SetDefaultAuthorizer');
        return this;
    }
    /**
     * Sets the specified version of the specified policy as the policy's default (operative) version.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SetDefaultPolicyVersion.html
     */
    toSetDefaultPolicyVersion() {
        this.to('iot:SetDefaultPolicyVersion');
        return this;
    }
    /**
     * Sets the logging options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SetLoggingOptions.html
     */
    toSetLoggingOptions() {
        this.to('iot:SetLoggingOptions');
        return this;
    }
    /**
     * Sets the v2 logging level.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SetV2LoggingLevel.html
     */
    toSetV2LoggingLevel() {
        this.to('iot:SetV2LoggingLevel');
        return this;
    }
    /**
     * Sets the v2 logging options.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_SetV2LoggingOptions.html
     */
    toSetV2LoggingOptions() {
        this.to('iot:SetV2LoggingOptions');
        return this;
    }
    /**
     * Starts a task that applies a set of mitigation actions to the specified target.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_StartAuditMitigationActionsTask.html
     */
    toStartAuditMitigationActionsTask() {
        this.to('iot:StartAuditMitigationActionsTask');
        return this;
    }
    /**
     * Gets and starts the next pending job execution for a thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_StartNextPendingJobExecution.html
     */
    toStartNextPendingJobExecution() {
        this.to('iot:StartNextPendingJobExecution');
        return this;
    }
    /**
     * Starts an on-demand Device Defender audit.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_StartOnDemandAuditTask.html
     */
    toStartOnDemandAuditTask() {
        this.to('iot:StartOnDemandAuditTask');
        return this;
    }
    /**
     * Starts a bulk thing registration task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_StartThingRegistrationTask.html
     */
    toStartThingRegistrationTask() {
        this.to('iot:StartThingRegistrationTask');
        return this;
    }
    /**
     * Stops a bulk thing registration task.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_StopThingRegistrationTask.html
     */
    toStopThingRegistrationTask() {
        this.to('iot:StopThingRegistrationTask');
        return this;
    }
    /**
     * Subscribe to the specified TopicFilter.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toSubscribe() {
        this.to('iot:Subscribe');
        return this;
    }
    /**
     * Tag a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_TagResource.html
     */
    toTagResource() {
        this.to('iot:TagResource');
        return this;
    }
    /**
     * Test the policies evaluation for group policies
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_TestAuthorization.html
     */
    toTestAuthorization() {
        this.to('iot:TestAuthorization');
        return this;
    }
    /**
     * Invoke the specified custom authorizer for testing purposes.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_TestInvokeAuthorizer.html
     */
    toTestInvokeAuthorizer() {
        this.to('iot:TestInvokeAuthorizer');
        return this;
    }
    /**
     * Transfers the specified certificate to the specified AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_TransferCertificate.html
     */
    toTransferCertificate() {
        this.to('iot:TransferCertificate');
        return this;
    }
    /**
     * Untag a specified resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UntagResource.html
     */
    toUntagResource() {
        this.to('iot:UntagResource');
        return this;
    }
    /**
     * Configures or reconfigures the Device Defender audit settings for this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateAccountAuditConfiguration.html
     */
    toUpdateAccountAuditConfiguration() {
        this.to('iot:UpdateAccountAuditConfiguration');
        return this;
    }
    /**
     * Updates a Device Defender audit suppression.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateAuditSuppression.html
     */
    toUpdateAuditSuppression() {
        this.to('iot:UpdateAuditSuppression');
        return this;
    }
    /**
     * Updates an authorizer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateAuthorizer.html
     */
    toUpdateAuthorizer() {
        this.to('iot:UpdateAuthorizer');
        return this;
    }
    /**
     * Updates information associated with the specified billing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateBillingGroup.html
     */
    toUpdateBillingGroup() {
        this.to('iot:UpdateBillingGroup');
        return this;
    }
    /**
     * Updates a registered CA certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateCACertificate.html
     */
    toUpdateCACertificate() {
        this.to('iot:UpdateCACertificate');
        return this;
    }
    /**
     * Updates the status of the specified certificate. This operation is idempotent.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateCertificate.html
     */
    toUpdateCertificate() {
        this.to('iot:UpdateCertificate');
        return this;
    }
    /**
     * Updates the definition for a dimension.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateDimension.html
     */
    toUpdateDimension() {
        this.to('iot:UpdateDimension');
        return this;
    }
    /**
     * Updates a domain configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateDomainConfiguration.html
     */
    toUpdateDomainConfiguration() {
        this.to('iot:UpdateDomainConfiguration');
        return this;
    }
    /**
     * Updates a Dynamic Thing Group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateDynamicThingGroup.html
     */
    toUpdateDynamicThingGroup() {
        this.to('iot:UpdateDynamicThingGroup');
        return this;
    }
    /**
     * Updates event configurations.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateEventConfigurations.html
     */
    toUpdateEventConfigurations() {
        this.to('iot:UpdateEventConfigurations');
        return this;
    }
    /**
     * Updates fleet indexing configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateIndexingConfiguration.html
     */
    toUpdateIndexingConfiguration() {
        this.to('iot:UpdateIndexingConfiguration');
        return this;
    }
    /**
     * Updates a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateJob.html
     */
    toUpdateJob() {
        this.to('iot:UpdateJob');
        return this;
    }
    /**
     * Updates a job execution.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateJobExecution.html
     */
    toUpdateJobExecution() {
        this.to('iot:UpdateJobExecution');
        return this;
    }
    /**
     * Updates the definition for the specified mitigation action.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateMitigationAction.html
     */
    toUpdateMitigationAction() {
        this.to('iot:UpdateMitigationAction');
        return this;
    }
    /**
     * Updates a fleet provisioning template.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateProvisioningTemplate.html
     */
    toUpdateProvisioningTemplate() {
        this.to('iot:UpdateProvisioningTemplate');
        return this;
    }
    /**
     * Updates the role alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateRoleAlias.html
     */
    toUpdateRoleAlias() {
        this.to('iot:UpdateRoleAlias');
        return this;
    }
    /**
     * Updates a scheduled audit, including what checks are performed and how often the audit takes place.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateScheduledAudit.html
     */
    toUpdateScheduledAudit() {
        this.to('iot:UpdateScheduledAudit');
        return this;
    }
    /**
     * Updates a Device Defender security profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateSecurityProfile.html
     */
    toUpdateSecurityProfile() {
        this.to('iot:UpdateSecurityProfile');
        return this;
    }
    /**
     * Updates the data for a stream.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateStream.html
     */
    toUpdateStream() {
        this.to('iot:UpdateStream');
        return this;
    }
    /**
     * Updates information associated with the specified thing.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateThing.html
     */
    toUpdateThing() {
        this.to('iot:UpdateThing');
        return this;
    }
    /**
     * Updates information associated with the specified thing group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateThingGroup.html
     */
    toUpdateThingGroup() {
        this.to('iot:UpdateThingGroup');
        return this;
    }
    /**
     * Updates the thing groups to which the thing belongs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateThingGroupsForThing.html
     */
    toUpdateThingGroupsForThing() {
        this.to('iot:UpdateThingGroupsForThing');
        return this;
    }
    /**
     * Updates the thing shadow.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/policy-actions.html
     */
    toUpdateThingShadow() {
        this.to('iot:UpdateThingShadow');
        return this;
    }
    /**
     * Validates a Device Defender security profile behaviors specification.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iot/latest/apireference/API_ValidateSecurityProfileBehaviors.html
     */
    toValidateSecurityProfileBehaviors() {
        this.to('iot:ValidateSecurityProfileBehaviors');
        return this;
    }
    /**
     * Adds a resource of type client to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-message-broker.html
     *
     * @param clientId - Identifier for the clientId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onClient(clientId, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:client/${ClientId}';
        arn = arn.replace('${ClientId}', clientId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type index to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-indexing.html
     *
     * @param indexName - Identifier for the indexName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onIndex(indexName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:index/${IndexName}';
        arn = arn.replace('${IndexName}', indexName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type job to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-jobs.html
     *
     * @param jobId - Identifier for the jobId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onJob(jobId, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:job/${JobId}';
        arn = arn.replace('${JobId}', jobId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type tunnel to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-tunnels.html
     *
     * @param tunnelId - Identifier for the tunnelId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onTunnel(tunnelId, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:tunnel/${TunnelId}';
        arn = arn.replace('${TunnelId}', tunnelId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type thing to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html
     *
     * @param thingName - Identifier for the thingName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onThing(thingName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:thing/${ThingName}';
        arn = arn.replace('${ThingName}', thingName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type thinggroup to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-groups.html
     *
     * @param thingGroupName - Identifier for the thingGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onThinggroup(thingGroupName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:thinggroup/${ThingGroupName}';
        arn = arn.replace('${ThingGroupName}', thingGroupName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type billinggroup to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/billing-groups.html
     *
     * @param billingGroupName - Identifier for the billingGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBillinggroup(billingGroupName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:billinggroup/${BillingGroupName}';
        arn = arn.replace('${BillingGroupName}', billingGroupName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type dynamicthinggroup to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/dynamic-thing-groups.html
     *
     * @param thingGroupName - Identifier for the thingGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDynamicthinggroup(thingGroupName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:thinggroup/${ThingGroupName}';
        arn = arn.replace('${ThingGroupName}', thingGroupName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type thingtype to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/thing-types.html
     *
     * @param thingTypeName - Identifier for the thingTypeName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onThingtype(thingTypeName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:thingtype/${ThingTypeName}';
        arn = arn.replace('${ThingTypeName}', thingTypeName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type topic to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-message-broker.html
     *
     * @param topicName - Identifier for the topicName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTopic(topicName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:topic/${TopicName}';
        arn = arn.replace('${TopicName}', topicName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type topicfilter to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/topics.html
     *
     * @param topicFilter - Identifier for the topicFilter.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onTopicfilter(topicFilter, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:topicfilter/${TopicFilter}';
        arn = arn.replace('${TopicFilter}', topicFilter);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type rolealias to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html
     *
     * @param roleAlias - Identifier for the roleAlias.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRolealias(roleAlias, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:rolealias/${RoleAlias}';
        arn = arn.replace('${RoleAlias}', roleAlias);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type authorizer to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/custom-authorizer.html
     *
     * @param authorizerName - Identifier for the authorizerName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAuthorizer(authorizerName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:authorizer/${AuthorizerName}';
        arn = arn.replace('${AuthorizerName}', authorizerName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type policy to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-policies.html
     *
     * @param policyName - Identifier for the policyName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onPolicy(policyName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:policy/${PolicyName}';
        arn = arn.replace('${PolicyName}', policyName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type cert to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-certs.html
     *
     * @param certificate - Identifier for the certificate.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCert(certificate, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:cert/${Certificate}';
        arn = arn.replace('${Certificate}', certificate);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type cacert to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/x509-certs.html
     *
     * @param cACertificate - Identifier for the cACertificate.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onCacert(cACertificate, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:cacert/${CACertificate}';
        arn = arn.replace('${CACertificate}', cACertificate);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type stream to the statement
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/freertos-ota-dev.html
     *
     * @param streamId - Identifier for the streamId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStream(streamId, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:stream/${StreamId}';
        arn = arn.replace('${StreamId}', streamId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type otaupdate to the statement
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/freertos-ota-dev.html
     *
     * @param otaUpdateId - Identifier for the otaUpdateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onOtaupdate(otaUpdateId, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:otaupdate/${OtaUpdateId}';
        arn = arn.replace('${OtaUpdateId}', otaUpdateId);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type scheduledaudit to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-audit.html
     *
     * @param scheduleName - Identifier for the scheduleName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScheduledaudit(scheduleName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:scheduledaudit/${ScheduleName}';
        arn = arn.replace('${ScheduleName}', scheduleName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type mitigationaction to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html
     *
     * @param mitigationActionName - Identifier for the mitigationActionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMitigationaction(mitigationActionName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:mitigationaction/${MitigationActionName}';
        arn = arn.replace('${MitigationActionName}', mitigationActionName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type securityprofile to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html
     *
     * @param securityProfileName - Identifier for the securityProfileName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onSecurityprofile(securityProfileName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:securityprofile/${SecurityProfileName}';
        arn = arn.replace('${SecurityProfileName}', securityProfileName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type dimension to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html
     *
     * @param dimensionName - Identifier for the dimensionName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDimension(dimensionName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:dimension/${DimensionName}';
        arn = arn.replace('${DimensionName}', dimensionName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type rule to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html
     *
     * @param ruleName - Identifier for the ruleName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRule(ruleName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:rule/${RuleName}';
        arn = arn.replace('${RuleName}', ruleName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type provisioningtemplate to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/provision-template.html
     *
     * @param provisioningTemplate - Identifier for the provisioningTemplate.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onProvisioningtemplate(provisioningTemplate, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:provisioningtemplate/${ProvisioningTemplate}';
        arn = arn.replace('${ProvisioningTemplate}', provisioningTemplate);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * Adds a resource of type domainconfiguration to the statement
     *
     * https://docs.aws.amazon.com/iot/latest/developerguide/domain-configuration.html
     *
     * @param domainConfigurationName - Identifier for the domainConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onDomainconfiguration(domainConfigurationName, account, region, partition) {
        var arn = 'arn:${Partition}:iot:${Region}:${Account}:domainconfiguration/${DomainConfigurationName}';
        arn = arn.replace('${DomainConfigurationName}', domainConfigurationName);
        arn = arn.replace('${Account}', account || '*');
        arn = arn.replace('${Region}', region || '*');
        arn = arn.replace('${Partition}', partition || 'aws');
        return this.on(arn);
    }
    /**
     * The flag indicating whether or not to also delete an IoT Tunnel immediately
     *
     * Applies to actions:
     * - .toCloseTunnel()
     *
     * @param value `true` or `false`. **Default:** `true`
     */
    ifDelete(value) {
        return this.if(`iot:Delete`, (typeof value !== 'undefined' ? value : true), 'Bool');
    }
    /**
     * Filters actions based on the domain name of an IoT DomainConfiguration
     *
     * Applies to actions:
     * - .toCreateDomainConfiguration()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDomainName(value, operator) {
        return this.if(`iot:DomainName`, value, operator || 'StringLike');
    }
    /**
     * The list of all IoT Thing Group ARNs that the destination IoT Thing belongs to for an IoT Tunnel
     *
     * Applies to actions:
     * - .toOpenTunnel()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifThingGroupArn(value, operator) {
        return this.if(`iot:ThingGroupArn`, value, operator || 'StringLike');
    }
    /**
     * The list of all destination services for an IoT Tunnel
     *
     * Applies to actions:
     * - .toOpenTunnel()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTunnelDestinationService(value, operator) {
        return this.if(`iot:TunnelDestinationService`, value, operator || 'StringLike');
    }
}
exports.Iot = Iot;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzaW90LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzaW90LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLHNDQUFzRDtBQUV0RDs7OztHQUlHO0FBQ0gsTUFBYSxHQUFJLFNBQVEsd0JBQWU7SUFHdEM7Ozs7T0FJRztJQUNILFlBQWEsR0FBWTtRQUN2QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFSTixrQkFBYSxHQUFHLEtBQUssQ0FBQztRQWdzRm5CLG9CQUFlLEdBQW9CO1lBQzNDLE9BQU8sRUFBRTtnQkFDUCwyQkFBMkI7Z0JBQzNCLHdCQUF3QjtnQkFDeEIsc0JBQXNCO2dCQUN0Qix5QkFBeUI7Z0JBQ3pCLHVCQUF1QjtnQkFDdkIsc0JBQXNCO2dCQUN0QixrQ0FBa0M7Z0JBQ2xDLGlCQUFpQjtnQkFDakIsMkJBQTJCO2dCQUMzQixXQUFXO2dCQUNYLG9CQUFvQjtnQkFDcEIsd0JBQXdCO2dCQUN4QixhQUFhO2dCQUNiLFNBQVM7Z0JBQ1Qsd0JBQXdCO2dCQUN4QixrQkFBa0I7Z0JBQ2xCLDBCQUEwQjtnQkFDMUIsaUJBQWlCO2dCQUNqQiwyQkFBMkI7Z0JBQzNCLFdBQVc7Z0JBQ1gsMEJBQTBCO2dCQUMxQix3QkFBd0I7Z0JBQ3hCLGlCQUFpQjtnQkFDakIsY0FBYztnQkFDZCxxQkFBcUI7Z0JBQ3JCLHlCQUF5QjtnQkFDekIsNEJBQTRCO2dCQUM1QixtQ0FBbUM7Z0JBQ25DLGlCQUFpQjtnQkFDakIsc0JBQXNCO2dCQUN0Qix1QkFBdUI7Z0JBQ3ZCLGNBQWM7Z0JBQ2QsYUFBYTtnQkFDYixpQkFBaUI7Z0JBQ2pCLGlDQUFpQztnQkFDakMsd0JBQXdCO2dCQUN4QixrQkFBa0I7Z0JBQ2xCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2dCQUNuQixpQkFBaUI7Z0JBQ2pCLDJCQUEyQjtnQkFDM0IsV0FBVztnQkFDWCxvQkFBb0I7Z0JBQ3BCLHdCQUF3QjtnQkFDeEIsaUJBQWlCO2dCQUNqQixjQUFjO2dCQUNkLHFCQUFxQjtnQkFDckIsNEJBQTRCO2dCQUM1QixtQ0FBbUM7Z0JBQ25DLHdCQUF3QjtnQkFDeEIsaUJBQWlCO2dCQUNqQixzQkFBc0I7Z0JBQ3RCLHVCQUF1QjtnQkFDdkIsY0FBYztnQkFDZCxhQUFhO2dCQUNiLG1CQUFtQjtnQkFDbkIsaUJBQWlCO2dCQUNqQixzQkFBc0I7Z0JBQ3RCLG9CQUFvQjtnQkFDcEIsdUJBQXVCO2dCQUN2QixzQkFBc0I7Z0JBQ3RCLGtCQUFrQjtnQkFDbEIsaUJBQWlCO2dCQUNqQixZQUFZO2dCQUNaLFNBQVM7Z0JBQ1QsU0FBUztnQkFDVCx1QkFBdUI7Z0JBQ3ZCLHFCQUFxQjtnQkFDckIsOEJBQThCO2dCQUM5QixlQUFlO2dCQUNmLDJCQUEyQjtnQkFDM0IsNkJBQTZCO2dCQUM3QiwyQkFBMkI7Z0JBQzNCLGtCQUFrQjtnQkFDbEIsbUJBQW1CO2dCQUNuQixtQkFBbUI7Z0JBQ25CLHFCQUFxQjtnQkFDckIsaUNBQWlDO2dCQUNqQyw4QkFBOEI7Z0JBQzlCLHdCQUF3QjtnQkFDeEIsNEJBQTRCO2dCQUM1QiwyQkFBMkI7Z0JBQzNCLFdBQVc7Z0JBQ1gscUJBQXFCO2dCQUNyQixpQ0FBaUM7Z0JBQ2pDLHdCQUF3QjtnQkFDeEIsa0JBQWtCO2dCQUNsQixvQkFBb0I7Z0JBQ3BCLHFCQUFxQjtnQkFDckIsbUJBQW1CO2dCQUNuQixpQkFBaUI7Z0JBQ2pCLDJCQUEyQjtnQkFDM0IseUJBQXlCO2dCQUN6QiwyQkFBMkI7Z0JBQzNCLDZCQUE2QjtnQkFDN0IsV0FBVztnQkFDWCxvQkFBb0I7Z0JBQ3BCLHdCQUF3QjtnQkFDeEIsNEJBQTRCO2dCQUM1QixpQkFBaUI7Z0JBQ2pCLHNCQUFzQjtnQkFDdEIsdUJBQXVCO2dCQUN2QixjQUFjO2dCQUNkLGFBQWE7Z0JBQ2Isa0JBQWtCO2dCQUNsQiwyQkFBMkI7Z0JBQzNCLG1CQUFtQjthQUNwQjtZQUNELHdCQUF3QixFQUFFO2dCQUN4QixjQUFjO2dCQUNkLHVCQUF1QjtnQkFDdkIsY0FBYztnQkFDZCx1QkFBdUI7Z0JBQ3ZCLHNCQUFzQjtnQkFDdEIseUJBQXlCO2FBQzFCO1lBQ0QsU0FBUyxFQUFFO2dCQUNULG9CQUFvQjtnQkFDcEIseUJBQXlCO2dCQUN6QixrQkFBa0I7Z0JBQ2xCLGlCQUFpQjtnQkFDakIsb0JBQW9CO2dCQUNwQix5QkFBeUI7Z0JBQ3pCLGtCQUFrQjtnQkFDbEIsaUJBQWlCO2dCQUNqQixhQUFhO2dCQUNiLGVBQWU7YUFDaEI7WUFDRCxNQUFNLEVBQUU7Z0JBQ04sbUNBQW1DO2dCQUNuQyxzQkFBc0I7Z0JBQ3RCLG9DQUFvQztnQkFDcEMsMEJBQTBCO2dCQUMxQixtQkFBbUI7Z0JBQ25CLG9CQUFvQjtnQkFDcEIsc0JBQXNCO2dCQUN0Qix1QkFBdUI7Z0JBQ3ZCLHFCQUFxQjtnQkFDckIsMkJBQTJCO2dCQUMzQixtQkFBbUI7Z0JBQ25CLDZCQUE2QjtnQkFDN0Isa0JBQWtCO2dCQUNsQiw2QkFBNkI7Z0JBQzdCLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYixzQkFBc0I7Z0JBQ3RCLDBCQUEwQjtnQkFDMUIsOEJBQThCO2dCQUM5QixxQ0FBcUM7Z0JBQ3JDLG1CQUFtQjtnQkFDbkIsd0JBQXdCO2dCQUN4Qix5QkFBeUI7Z0JBQ3pCLGdCQUFnQjtnQkFDaEIsZUFBZTtnQkFDZixvQkFBb0I7Z0JBQ3BCLCtCQUErQjtnQkFDL0IsbUJBQW1CO2dCQUNuQixnQkFBZ0I7Z0JBQ2hCLGdCQUFnQjtnQkFDaEIsc0JBQXNCO2dCQUN0QiwwQkFBMEI7Z0JBQzFCLGdCQUFnQjtnQkFDaEIsbUJBQW1CO2dCQUNuQixjQUFjO2dCQUNkLHlCQUF5QjtnQkFDekIsZ0JBQWdCO2dCQUNoQixXQUFXO2dCQUNYLGtCQUFrQjtnQkFDbEIscUJBQXFCO2dCQUNyQixlQUFlO2dCQUNmLGdCQUFnQjtnQkFDaEIsY0FBYztnQkFDZCxxQkFBcUI7Z0JBQ3JCLGFBQWE7Z0JBQ2IsbUJBQW1CO2dCQUNuQixzQkFBc0I7Z0JBQ3RCLGtDQUFrQzthQUNuQztZQUNELE1BQU0sRUFBRTtnQkFDTixzQkFBc0I7Z0JBQ3RCLHNCQUFzQjtnQkFDdEIsbUJBQW1CO2dCQUNuQixzQ0FBc0M7Z0JBQ3RDLGlDQUFpQztnQkFDakMsdUJBQXVCO2dCQUN2QixnQkFBZ0I7Z0JBQ2hCLGlCQUFpQjtnQkFDakIsbUJBQW1CO2dCQUNuQixvQkFBb0I7Z0JBQ3BCLGtCQUFrQjtnQkFDbEIsc0JBQXNCO2dCQUN0QixnQkFBZ0I7Z0JBQ2hCLDBCQUEwQjtnQkFDMUIsYUFBYTtnQkFDYix5QkFBeUI7Z0JBQ3pCLDJCQUEyQjtnQkFDM0IsVUFBVTtnQkFDVix1QkFBdUI7Z0JBQ3ZCLDBCQUEwQjtnQkFDMUIsZ0JBQWdCO2dCQUNoQiwwQkFBMEI7Z0JBQzFCLGNBQWM7Z0JBQ2Qsc0JBQXNCO2dCQUN0QixvQkFBb0I7Z0JBQ3BCLHVCQUF1QjtnQkFDdkIscUJBQXFCO2dCQUNyQixrQ0FBa0M7Z0JBQ2xDLDJCQUEyQjtnQkFDM0IsaUJBQWlCO2dCQUNqQixxQkFBcUI7Z0JBQ3JCLHNCQUFzQjtnQkFDdEIsK0JBQStCO2dCQUMvQixhQUFhO2dCQUNiLHFCQUFxQjtnQkFDckIsc0JBQXNCO2dCQUN0QiwrQkFBK0I7Z0JBQy9CLGlCQUFpQjtnQkFDakIseUJBQXlCO2dCQUN6QixxQkFBcUI7Z0JBQ3JCLGtDQUFrQztnQkFDbEMsNEJBQTRCO2dCQUM1QixnQkFBZ0I7Z0JBQ2hCLFlBQVk7Z0JBQ1osMEJBQTBCO2dCQUMxQix3QkFBd0I7Z0JBQ3hCLGdCQUFnQjtnQkFDaEIsYUFBYTtnQkFDYixxQkFBcUI7Z0JBQ3JCLHFCQUFxQjthQUN0QjtTQUNGLENBQUM7SUEvNUZGLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzVCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7UUFDckMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNyQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxJQUFJLENBQUMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDaEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFdBQVc7UUFDaEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUN6QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBQ2xDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksU0FBUztRQUNkLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDdkIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7OztPQVdHO0lBQ0ksMkJBQTJCO1FBQ2hDLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUN6QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3pCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDL0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7Ozs7Ozs7T0FVRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzVCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksNEJBQTRCO1FBQ2pDLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMxQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO1FBQ2pELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM1QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUMzQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7OztPQVVHO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBQ2xDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztRQUNqQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDekMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDekIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDL0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDNUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1DQUFtQztRQUN4QyxJQUFJLENBQUMsRUFBRSxDQUFDLHVDQUF1QyxDQUFDLENBQUM7UUFDakQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNyQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM1QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUMzQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQ0FBbUM7UUFDeEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1Q0FBdUMsQ0FBQyxDQUFDO1FBQ2pELE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0NBQW9DO1FBQ3pDLElBQUksQ0FBQyxFQUFFLENBQUMsd0NBQXdDLENBQUMsQ0FBQztRQUNsRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7UUFDckMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksNkJBQTZCO1FBQ2xDLElBQUksQ0FBQyxFQUFFLENBQUMsaUNBQWlDLENBQUMsQ0FBQztRQUMzQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZUFBZTtRQUNwQixJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7UUFDN0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7UUFDNUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUNBQXFDO1FBQzFDLElBQUksQ0FBQyxFQUFFLENBQUMseUNBQXlDLENBQUMsQ0FBQztRQUNuRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQzlCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGVBQWU7UUFDcEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO1FBQzdCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksK0JBQStCO1FBQ3BDLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztRQUM3QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksY0FBYztRQUNuQixJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDNUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxFQUFFLENBQUMsMkJBQTJCLENBQUMsQ0FBQztRQUNyQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztRQUNqQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztRQUM1QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3pCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDaEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUM3QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxnQkFBZ0I7UUFDckIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQzlCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzVCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0NBQXNDO1FBQzNDLElBQUksQ0FBQyxFQUFFLENBQUMsMENBQTBDLENBQUMsQ0FBQztRQUNwRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHVCQUF1QjtRQUM1QixJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7UUFDckMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUM5QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUM5QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQzNCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHlCQUF5QjtRQUM5QixJQUFJLENBQUMsRUFBRSxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFDdkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUN6QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxVQUFVO1FBQ2YsSUFBSSxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUN4QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDBCQUEwQjtRQUMvQixJQUFJLENBQUMsRUFBRSxDQUFDLDhCQUE4QixDQUFDLENBQUM7UUFDeEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksZ0JBQWdCO1FBQ3JCLElBQUksQ0FBQyxFQUFFLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUM5QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwwQkFBMEI7UUFDL0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw4QkFBOEIsQ0FBQyxDQUFDO1FBQ3hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzVCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsd0JBQXdCLENBQUMsQ0FBQztRQUNsQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLElBQUksQ0FBQyxFQUFFLENBQUMsc0NBQXNDLENBQUMsQ0FBQztRQUNoRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDL0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7UUFDN0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxzQkFBc0I7UUFDM0IsSUFBSSxDQUFDLEVBQUUsQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQ3BDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLCtCQUErQjtRQUNwQyxJQUFJLENBQUMsRUFBRSxDQUFDLG1DQUFtQyxDQUFDLENBQUM7UUFDN0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksaUJBQWlCO1FBQ3RCLElBQUksQ0FBQyxFQUFFLENBQUMscUJBQXFCLENBQUMsQ0FBQztRQUMvQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO1FBQ3ZDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0NBQWtDO1FBQ3ZDLElBQUksQ0FBQyxFQUFFLENBQUMsc0NBQXNDLENBQUMsQ0FBQztRQUNoRCxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksWUFBWTtRQUNqQixJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDMUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMEJBQTBCO1FBQy9CLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztRQUN4QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx3QkFBd0I7UUFDN0IsSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO1FBQ3RDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDOUIsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxxQkFBcUI7UUFDMUIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1FBQ25DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLFlBQVk7UUFDakIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQzFCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFNBQVM7UUFDZCxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLFNBQVM7UUFDZCxJQUFJLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksOEJBQThCO1FBQ25DLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztRQUM1QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUM3QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUN6QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxrQkFBa0I7UUFDdkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO1FBQ2hDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQzNCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG1CQUFtQjtRQUN4QixJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFDakMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDhCQUE4QjtRQUNuQyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7UUFDNUMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDekMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3pCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7Ozs7O09BVUc7SUFDSSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxFQUFFLENBQUMsaUJBQWlCLENBQUMsQ0FBQztRQUMzQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHNCQUFzQjtRQUMzQixJQUFJLENBQUMsRUFBRSxDQUFDLDBCQUEwQixDQUFDLENBQUM7UUFDcEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kscUJBQXFCO1FBQzFCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxFQUFFLENBQUMsbUJBQW1CLENBQUMsQ0FBQztRQUM3QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQ0FBaUM7UUFDdEMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQ0FBcUMsQ0FBQyxDQUFDO1FBQy9DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHdCQUF3QjtRQUM3QixJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksa0JBQWtCO1FBQ3ZCLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztRQUNoQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxvQkFBb0I7UUFDekIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO1FBQ2xDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksbUJBQW1CO1FBQ3hCLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztRQUNqQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxpQkFBaUI7UUFDdEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1FBQy9CLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDJCQUEyQjtRQUNoQyxJQUFJLENBQUMsRUFBRSxDQUFDLCtCQUErQixDQUFDLENBQUM7UUFDekMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0kseUJBQXlCO1FBQzlCLElBQUksQ0FBQyxFQUFFLENBQUMsNkJBQTZCLENBQUMsQ0FBQztRQUN2QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSwyQkFBMkI7UUFDaEMsSUFBSSxDQUFDLEVBQUUsQ0FBQywrQkFBK0IsQ0FBQyxDQUFDO1FBQ3pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLDZCQUE2QjtRQUNsQyxJQUFJLENBQUMsRUFBRSxDQUFDLGlDQUFpQyxDQUFDLENBQUM7UUFDM0MsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksV0FBVztRQUNoQixJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3pCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksd0JBQXdCO1FBQzdCLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztRQUN0QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSw0QkFBNEI7UUFDakMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQzFDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGlCQUFpQjtRQUN0QixJQUFJLENBQUMsRUFBRSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDL0IsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxFQUFFLENBQUMsMEJBQTBCLENBQUMsQ0FBQztRQUNwQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSx1QkFBdUI7UUFDNUIsSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO1FBQ3JDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGNBQWM7UUFDbkIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQzVCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO1FBQzNCLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtCQUFrQjtRQUN2QixJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDaEMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBRUQ7Ozs7OztPQU1HO0lBQ0ksMkJBQTJCO1FBQ2hDLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztRQUN6QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7SUFFRDs7Ozs7O09BTUc7SUFDSSxtQkFBbUI7UUFDeEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztJQUVEOzs7Ozs7T0FNRztJQUNJLGtDQUFrQztRQUN2QyxJQUFJLENBQUMsRUFBRSxDQUFDLHNDQUFzQyxDQUFDLENBQUM7UUFDaEQsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDO0lBNE9EOzs7Ozs7Ozs7T0FTRztJQUNJLFFBQVEsQ0FBQyxRQUFnQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JGLElBQUksR0FBRyxHQUFHLDhEQUE4RCxDQUFDO1FBQ3pFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUMzQyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLE9BQU8sQ0FBQyxTQUFpQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JGLElBQUksR0FBRyxHQUFHLDhEQUE4RCxDQUFDO1FBQ3pFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUM3QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLEtBQUssQ0FBQyxLQUFhLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDL0UsSUFBSSxHQUFHLEdBQUcsd0RBQXdELENBQUM7UUFDbkUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBQ3JDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksUUFBUSxDQUFDLFFBQWdCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckYsSUFBSSxHQUFHLEdBQUcsOERBQThELENBQUM7UUFDekUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQzNDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksT0FBTyxDQUFDLFNBQWlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckYsSUFBSSxHQUFHLEdBQUcsOERBQThELENBQUM7UUFDekUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQzdDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksWUFBWSxDQUFDLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDL0YsSUFBSSxHQUFHLEdBQUcsd0VBQXdFLENBQUM7UUFDbkYsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsbUJBQW1CLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDdkQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxjQUFjLENBQUMsZ0JBQXdCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDbkcsSUFBSSxHQUFHLEdBQUcsNEVBQTRFLENBQUM7UUFDdkYsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMscUJBQXFCLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztRQUMzRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLG1CQUFtQixDQUFDLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDdEcsSUFBSSxHQUFHLEdBQUcsd0VBQXdFLENBQUM7UUFDbkYsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsbUJBQW1CLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDdkQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxXQUFXLENBQUMsYUFBcUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUM3RixJQUFJLEdBQUcsR0FBRyxzRUFBc0UsQ0FBQztRQUNqRixHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxrQkFBa0IsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUNyRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLE9BQU8sQ0FBQyxTQUFpQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3JGLElBQUksR0FBRyxHQUFHLDhEQUE4RCxDQUFDO1FBQ3pFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLENBQUMsQ0FBQztRQUM3QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7T0FTRztJQUNJLGFBQWEsQ0FBQyxXQUFtQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQzdGLElBQUksR0FBRyxHQUFHLHNFQUFzRSxDQUFDO1FBQ2pGLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGdCQUFnQixFQUFFLFdBQVcsQ0FBQyxDQUFDO1FBQ2pELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksV0FBVyxDQUFDLFNBQWlCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDekYsSUFBSSxHQUFHLEdBQUcsa0VBQWtFLENBQUM7UUFDN0UsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBQzdDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksWUFBWSxDQUFDLGNBQXNCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDL0YsSUFBSSxHQUFHLEdBQUcsd0VBQXdFLENBQUM7UUFDbkYsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsbUJBQW1CLEVBQUUsY0FBYyxDQUFDLENBQUM7UUFDdkQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxRQUFRLENBQUMsVUFBa0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN2RixJQUFJLEdBQUcsR0FBRyxnRUFBZ0UsQ0FBQztRQUMzRSxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxlQUFlLEVBQUUsVUFBVSxDQUFDLENBQUM7UUFDL0MsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7O09BU0c7SUFDSSxNQUFNLENBQUMsV0FBbUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUN0RixJQUFJLEdBQUcsR0FBRywrREFBK0QsQ0FBQztRQUMxRSxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUNqRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLFFBQVEsQ0FBQyxhQUFxQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQzFGLElBQUksR0FBRyxHQUFHLG1FQUFtRSxDQUFDO1FBQzlFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGtCQUFrQixFQUFFLGFBQWEsQ0FBQyxDQUFDO1FBQ3JELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksUUFBUSxDQUFDLFFBQWdCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDckYsSUFBSSxHQUFHLEdBQUcsOERBQThELENBQUM7UUFDekUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsYUFBYSxFQUFFLFFBQVEsQ0FBQyxDQUFDO1FBQzNDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksV0FBVyxDQUFDLFdBQW1CLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDM0YsSUFBSSxHQUFHLEdBQUcsb0VBQW9FLENBQUM7UUFDL0UsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLEVBQUUsV0FBVyxDQUFDLENBQUM7UUFDakQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxnQkFBZ0IsQ0FBQyxZQUFvQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ2pHLElBQUksR0FBRyxHQUFHLDBFQUEwRSxDQUFDO1FBQ3JGLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGlCQUFpQixFQUFFLFlBQVksQ0FBQyxDQUFDO1FBQ25ELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksa0JBQWtCLENBQUMsb0JBQTRCLEVBQUUsT0FBZ0IsRUFBRSxNQUFlLEVBQUUsU0FBa0I7UUFDM0csSUFBSSxHQUFHLEdBQUcsb0ZBQW9GLENBQUM7UUFDL0YsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMseUJBQXlCLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztRQUNuRSxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLGlCQUFpQixDQUFDLG1CQUEyQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ3pHLElBQUksR0FBRyxHQUFHLGtGQUFrRixDQUFDO1FBQzdGLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLHdCQUF3QixFQUFFLG1CQUFtQixDQUFDLENBQUM7UUFDakUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxXQUFXLENBQUMsYUFBcUIsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUM3RixJQUFJLEdBQUcsR0FBRyxzRUFBc0UsQ0FBQztRQUNqRixHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxrQkFBa0IsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUNyRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLE1BQU0sQ0FBQyxRQUFnQixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQ25GLElBQUksR0FBRyxHQUFHLDREQUE0RCxDQUFDO1FBQ3ZFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGFBQWEsRUFBRSxRQUFRLENBQUMsQ0FBQztRQUMzQyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2hELEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxNQUFNLElBQUksR0FBRyxDQUFDLENBQUM7UUFDOUMsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLFNBQVMsSUFBSSxLQUFLLENBQUMsQ0FBQztRQUN0RCxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztJQUVEOzs7Ozs7Ozs7Ozs7T0FZRztJQUNJLHNCQUFzQixDQUFDLG9CQUE0QixFQUFFLE9BQWdCLEVBQUUsTUFBZSxFQUFFLFNBQWtCO1FBQy9HLElBQUksR0FBRyxHQUFHLHdGQUF3RixDQUFDO1FBQ25HLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLHlCQUF5QixFQUFFLG9CQUFvQixDQUFDLENBQUM7UUFDbkUsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsWUFBWSxFQUFFLE9BQU8sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUNoRCxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxXQUFXLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQzlDLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLGNBQWMsRUFBRSxTQUFTLElBQUksS0FBSyxDQUFDLENBQUM7UUFDdEQsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ3RCLENBQUM7SUFFRDs7Ozs7Ozs7Ozs7O09BWUc7SUFDSSxxQkFBcUIsQ0FBQyx1QkFBK0IsRUFBRSxPQUFnQixFQUFFLE1BQWUsRUFBRSxTQUFrQjtRQUNqSCxJQUFJLEdBQUcsR0FBRywwRkFBMEYsQ0FBQztRQUNyRyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyw0QkFBNEIsRUFBRSx1QkFBdUIsQ0FBQyxDQUFDO1FBQ3pFLEdBQUcsR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLFlBQVksRUFBRSxPQUFPLElBQUksR0FBRyxDQUFDLENBQUM7UUFDaEQsR0FBRyxHQUFHLEdBQUcsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLE1BQU0sSUFBSSxHQUFHLENBQUMsQ0FBQztRQUM5QyxHQUFHLEdBQUcsR0FBRyxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUUsU0FBUyxJQUFJLEtBQUssQ0FBQyxDQUFDO1FBQ3RELE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBRUQ7Ozs7Ozs7T0FPRztJQUNJLFFBQVEsQ0FBQyxLQUFlO1FBQzdCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxZQUFZLEVBQUUsQ0FBQyxPQUFPLEtBQUssS0FBSyxXQUFXLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7SUFDdEYsQ0FBQztJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksWUFBWSxDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDeEUsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGdCQUFnQixFQUFFLEtBQUssRUFBRSxRQUFRLElBQUksWUFBWSxDQUFDLENBQUM7SUFDcEUsQ0FBQztJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksZUFBZSxDQUFDLEtBQXdCLEVBQUUsUUFBNEI7UUFDM0UsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixFQUFFLEtBQUssRUFBRSxRQUFRLElBQUksWUFBWSxDQUFDLENBQUM7SUFDdkUsQ0FBQztJQUVEOzs7Ozs7OztPQVFHO0lBQ0ksMEJBQTBCLENBQUMsS0FBd0IsRUFBRSxRQUE0QjtRQUN0RixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLEVBQUUsS0FBSyxFQUFFLFFBQVEsSUFBSSxZQUFZLENBQUMsQ0FBQztJQUNsRixDQUFDO0NBQ0Y7QUFqL0dELGtCQWkvR0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tIFwiLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbFwiO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50LCBPcGVyYXRvciB9IGZyb20gXCIuLi9zaGFyZWRcIjtcblxuLyoqXG4gKiBTdGF0ZW1lbnQgcHJvdmlkZXIgZm9yIHNlcnZpY2UgW2lvdF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3NlcnZpY2UtYXV0aG9yaXphdGlvbi9sYXRlc3QvcmVmZXJlbmNlL2xpc3RfYXdzaW90Lmh0bWwpLlxuICpcbiAqIEBwYXJhbSBzaWQgW1NJRF0oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19zaWQuaHRtbCkgb2YgdGhlIHN0YXRlbWVudFxuICovXG5leHBvcnQgY2xhc3MgSW90IGV4dGVuZHMgUG9saWN5U3RhdGVtZW50IHtcbiAgcHVibGljIHNlcnZpY2VQcmVmaXggPSAnaW90JztcblxuICAvKipcbiAgICogU3RhdGVtZW50IHByb3ZpZGVyIGZvciBzZXJ2aWNlIFtpb3RdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9zZXJ2aWNlLWF1dGhvcml6YXRpb24vbGF0ZXN0L3JlZmVyZW5jZS9saXN0X2F3c2lvdC5odG1sKS5cbiAgICpcbiAgICogQHBhcmFtIHNpZCBbU0lEXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX3NpZC5odG1sKSBvZiB0aGUgc3RhdGVtZW50XG4gICAqL1xuICBjb25zdHJ1Y3RvciAoc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBY2NlcHRzIGEgcGVuZGluZyBjZXJ0aWZpY2F0ZSB0cmFuc2Zlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0FjY2VwdENlcnRpZmljYXRlVHJhbnNmZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQWNjZXB0Q2VydGlmaWNhdGVUcmFuc2ZlcigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6QWNjZXB0Q2VydGlmaWNhdGVUcmFuc2ZlcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSB0aGluZyB0byB0aGUgc3BlY2lmaWVkIGJpbGxpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9BZGRUaGluZ1RvQmlsbGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FkZFRoaW5nVG9CaWxsaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OkFkZFRoaW5nVG9CaWxsaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgdGhpbmcgdG8gdGhlIHNwZWNpZmllZCB0aGluZyBncm91cC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0FkZFRoaW5nVG9UaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0FkZFRoaW5nVG9UaGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpBZGRUaGluZ1RvVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEFzc29jaWF0ZXMgYSBncm91cCB3aXRoIGEgY29udGludW91cyBqb2IuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9Bc3NvY2lhdGVUYXJnZXRzV2l0aEpvYi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Bc3NvY2lhdGVUYXJnZXRzV2l0aEpvYigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6QXNzb2NpYXRlVGFyZ2V0c1dpdGhKb2InKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBBdHRhY2hlcyBhIHBvbGljeSB0byB0aGUgc3BlY2lmaWVkIHRhcmdldC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBQZXJtaXNzaW9ucyBtYW5hZ2VtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQXR0YWNoUG9saWN5Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0F0dGFjaFBvbGljeSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6QXR0YWNoUG9saWN5Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQXR0YWNoZXMgdGhlIHNwZWNpZmllZCBwb2xpY3kgdG8gdGhlIHNwZWNpZmllZCBwcmluY2lwYWwgKGNlcnRpZmljYXRlIG9yIG90aGVyIGNyZWRlbnRpYWwpLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9BdHRhY2hQcmluY2lwYWxQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQXR0YWNoUHJpbmNpcGFsUG9saWN5KCkge1xuICAgIHRoaXMudG8oJ2lvdDpBdHRhY2hQcmluY2lwYWxQb2xpY3knKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBBc3NvY2lhdGVzIGEgRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGUgd2l0aCBhIHRoaW5nIGdyb3VwIG9yIHdpdGggdGhpcyBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQXR0YWNoU2VjdXJpdHlQcm9maWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0F0dGFjaFNlY3VyaXR5UHJvZmlsZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6QXR0YWNoU2VjdXJpdHlQcm9maWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQXR0YWNoZXMgdGhlIHNwZWNpZmllZCBwcmluY2lwYWwgdG8gdGhlIHNwZWNpZmllZCB0aGluZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0F0dGFjaFRoaW5nUHJpbmNpcGFsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0F0dGFjaFRoaW5nUHJpbmNpcGFsKCkge1xuICAgIHRoaXMudG8oJ2lvdDpBdHRhY2hUaGluZ1ByaW5jaXBhbCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENhbmNlbHMgYSBtaXRpZ2F0aW9uIGFjdGlvbiB0YXNrIHRoYXQgaXMgaW4gcHJvZ3Jlc3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DYW5jZWxBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFzay5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DYW5jZWxBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFzaygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q2FuY2VsQXVkaXRNaXRpZ2F0aW9uQWN0aW9uc1Rhc2snKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDYW5jZWxzIGFuIGF1ZGl0IHRoYXQgaXMgaW4gcHJvZ3Jlc3MuIFRoZSBhdWRpdCBjYW4gYmUgZWl0aGVyIHNjaGVkdWxlZCBvciBvbi1kZW1hbmQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DYW5jZWxBdWRpdFRhc2suaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ2FuY2VsQXVkaXRUYXNrKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDYW5jZWxBdWRpdFRhc2snKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDYW5jZWxzIGEgcGVuZGluZyB0cmFuc2ZlciBmb3IgdGhlIHNwZWNpZmllZCBjZXJ0aWZpY2F0ZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NhbmNlbENlcnRpZmljYXRlVHJhbnNmZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ2FuY2VsQ2VydGlmaWNhdGVUcmFuc2ZlcigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q2FuY2VsQ2VydGlmaWNhdGVUcmFuc2ZlcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENhbmNlbHMgYSBqb2IuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DYW5jZWxKb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ2FuY2VsSm9iKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDYW5jZWxKb2InKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDYW5jZWxzIGEgam9iIGV4ZWN1dGlvbiBvbiBhIHBhcnRpY3VsYXIgZGV2aWNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ2FuY2VsSm9iRXhlY3V0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NhbmNlbEpvYkV4ZWN1dGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q2FuY2VsSm9iRXhlY3V0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ2xlYXJzIHRoZSBkZWZhdWx0IGF1dGhvcml6ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DbGVhckRlZmF1bHRBdXRob3JpemVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NsZWFyRGVmYXVsdEF1dGhvcml6ZXIoKSB7XG4gICAgdGhpcy50bygnaW90OkNsZWFyRGVmYXVsdEF1dGhvcml6ZXInKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDbG9zZXMgYSB0dW5uZWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZEZWxldGUoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Nsb3NlVHVubmVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Nsb3NlVHVubmVsKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDbG9zZVR1bm5lbCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbm5lY3QgYXMgdGhlIHNwZWNpZmllZCBjbGllbnRcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9wb2xpY3ktYWN0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9Db25uZWN0KCkge1xuICAgIHRoaXMudG8oJ2lvdDpDb25uZWN0Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIERldmljZSBEZWZlbmRlciBhdWRpdCBzdXBwcmVzc2lvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZUF1ZGl0U3VwcHJlc3Npb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQXVkaXRTdXBwcmVzc2lvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlQXVkaXRTdXBwcmVzc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYW4gYXV0aG9yaXplci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZUF1dGhvcml6ZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQXV0aG9yaXplcigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlQXV0aG9yaXplcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBiaWxsaW5nIGdyb3VwLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVCaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlQmlsbGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVCaWxsaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGFuIFguNTA5IGNlcnRpZmljYXRlIHVzaW5nIHRoZSBzcGVjaWZpZWQgY2VydGlmaWNhdGUgc2lnbmluZyByZXF1ZXN0LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlQ2VydGlmaWNhdGVGcm9tQ3NyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUNlcnRpZmljYXRlRnJvbUNzcigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlQ2VydGlmaWNhdGVGcm9tQ3NyJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVmaW5lcyBhIGRpbWVuc2lvbiB0aGF0IGNhbiBiZSB1c2VkIHRvIHRvIGxpbWl0IHRoZSBzY29wZSBvZiBhIG1ldHJpYyB1c2VkIGluIGEgc2VjdXJpdHkgcHJvZmlsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZURpbWVuc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVEaW1lbnNpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZURpbWVuc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBkb21haW4gY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKiAtIC5pZkRvbWFpbk5hbWUoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZURvbWFpbkNvbmZpZ3VyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlRG9tYWluQ29uZmlndXJhdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlRG9tYWluQ29uZmlndXJhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBEeW5hbWljIFRoaW5nIEdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZUR5bmFtaWNUaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUR5bmFtaWNUaGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVEeW5hbWljVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBqb2IuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVKb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlSm9iKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVKb2InKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgMjA0OCBiaXQgUlNBIGtleSBwYWlyIGFuZCBpc3N1ZXMgYW4gWC41MDkgY2VydGlmaWNhdGUgdXNpbmcgdGhlIGlzc3VlZCBwdWJsaWMga2V5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlS2V5c0FuZENlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZUtleXNBbmRDZXJ0aWZpY2F0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlS2V5c0FuZENlcnRpZmljYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVmaW5lcyBhbiBhY3Rpb24gdGhhdCBjYW4gYmUgYXBwbGllZCB0byBhdWRpdCBmaW5kaW5ncyBieSB1c2luZyBTdGFydEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNUYXNrLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlTWl0aWdhdGlvbkFjdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVNaXRpZ2F0aW9uQWN0aW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVNaXRpZ2F0aW9uQWN0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhbiBPVEEgdXBkYXRlIGpvYi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZU9UQVVwZGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVPVEFVcGRhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZU9UQVVwZGF0ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYW4gQVdTIElvVCBwb2xpY3kuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUG9saWN5KCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVQb2xpY3knKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgbmV3IHZlcnNpb24gb2YgdGhlIHNwZWNpZmllZCBBV1MgSW9UIHBvbGljeS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZVBvbGljeVZlcnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUG9saWN5VmVyc2lvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlUG9saWN5VmVyc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBwcm92aXNpb25pbmcgY2xhaW0uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVQcm92aXNpb25pbmdDbGFpbS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVQcm92aXNpb25pbmdDbGFpbSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlUHJvdmlzaW9uaW5nQ2xhaW0nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgZmxlZXQgcHJvdmlzaW9uaW5nIHRlbXBsYXRlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIG5ldyB2ZXJzaW9uIG9mIGEgZmxlZXQgcHJvdmlzaW9uaW5nIHRlbXBsYXRlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlVmVyc2lvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIHJvbGUgYWxpYXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVSb2xlQWxpYXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlUm9sZUFsaWFzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVSb2xlQWxpYXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgc2NoZWR1bGVkIGF1ZGl0IHRoYXQgaXMgcnVuIGF0IGEgc3BlY2lmaWVkIHRpbWUgaW50ZXJ2YWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVTY2hlZHVsZWRBdWRpdC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVTY2hlZHVsZWRBdWRpdCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlU2NoZWR1bGVkQXVkaXQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVTZWN1cml0eVByb2ZpbGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU2VjdXJpdHlQcm9maWxlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVTZWN1cml0eVByb2ZpbGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgbmV3IEFXUyBJb1Qgc3RyZWFtXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVTdHJlYW0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlU3RyZWFtKCkge1xuICAgIHRoaXMudG8oJ2lvdDpDcmVhdGVTdHJlYW0nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgdGhpbmcgaW4gdGhlIHRoaW5nIHJlZ2lzdHJ5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlVGhpbmcuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvQ3JlYXRlVGhpbmcoKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZVRoaW5nJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIHRoaW5nIGdyb3VwLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9DcmVhdGVUaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVRoaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZVRoaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGVzIGEgbmV3IHRoaW5nIHR5cGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0NyZWF0ZVRoaW5nVHlwZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9DcmVhdGVUaGluZ1R5cGUoKSB7XG4gICAgdGhpcy50bygnaW90OkNyZWF0ZVRoaW5nVHlwZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBydWxlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfQ3JlYXRlVG9waWNSdWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0NyZWF0ZVRvcGljUnVsZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6Q3JlYXRlVG9waWNSdWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyB0aGUgYXVkaXQgY29uZmlndXJhdGlvbiBhc3NvY2lhdGVkIHdpdGggdGhlIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUFjY291bnRBdWRpdENvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZUFjY291bnRBdWRpdENvbmZpZ3VyYXRpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIGEgRGV2aWNlIERlZmVuZGVyIGF1ZGl0IHN1cHByZXNzaW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlQXVkaXRTdXBwcmVzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVBdWRpdFN1cHByZXNzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVBdWRpdFN1cHByZXNzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyB0aGUgc3BlY2lmaWVkIGF1dGhvcml6ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVBdXRob3JpemVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUF1dGhvcml6ZXIoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZUF1dGhvcml6ZXInKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIHRoZSBzcGVjaWZpZWQgYmlsbGluZyBncm91cC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBUYWdnaW5nXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlQmlsbGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUJpbGxpbmdHcm91cCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlQmlsbGluZ0dyb3VwJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyBhIHJlZ2lzdGVyZWQgQ0EgY2VydGlmaWNhdGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVDQUNlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUNBQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZUNBQ2VydGlmaWNhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIHRoZSBzcGVjaWZpZWQgY2VydGlmaWNhdGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVDZXJ0aWZpY2F0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVDZXJ0aWZpY2F0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlQ2VydGlmaWNhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW1vdmVzIHRoZSBzcGVjaWZpZWQgZGltZW5zaW9uIGZyb20geW91ciBBV1MgYWNjb3VudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZURpbWVuc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVEaW1lbnNpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZURpbWVuc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBkb21haW4gY29uZmlndXJhdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZURvbWFpbkNvbmZpZ3VyYXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlRG9tYWluQ29uZmlndXJhdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlRG9tYWluQ29uZmlndXJhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgdGhlIHNwZWNpZmllZCBEeW5hbWljIFRoaW5nIEdyb3VwXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogVGFnZ2luZ1xuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZUR5bmFtaWNUaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUR5bmFtaWNUaGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVEeW5hbWljVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBqb2IgYW5kIGl0cyByZWxhdGVkIGpvYiBleGVjdXRpb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlSm9iLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZUpvYigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlSm9iJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyBhIGpvYiBleGVjdXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVKb2JFeGVjdXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlSm9iRXhlY3V0aW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVKb2JFeGVjdXRpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIGEgZGVmaW5lZCBtaXRpZ2F0aW9uIGFjdGlvbiBmcm9tIHlvdXIgQVdTIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVNaXRpZ2F0aW9uQWN0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZU1pdGlnYXRpb25BY3Rpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZU1pdGlnYXRpb25BY3Rpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIGFuIE9UQSB1cGRhdGUgam9iLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlT1RBVXBkYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZU9UQVVwZGF0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlT1RBVXBkYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyB0aGUgc3BlY2lmaWVkIHBvbGljeS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVBvbGljeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVQb2xpY3koKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVBvbGljeScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgdGhlIHNwZWNpZmllZCB2ZXJzaW9uIG9mIHRoZSBzcGVjaWZpZWQgcG9saWN5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlUG9saWN5VmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVQb2xpY3lWZXJzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVQb2xpY3lWZXJzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyBhIGZsZWV0IHByb3Zpc2lvbmluZyB0ZW1wbGF0ZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVQcm92aXNpb25pbmdUZW1wbGF0ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBmbGVldCBwcm92aXNpb25pbmcgdGVtcGxhdGUgdmVyc2lvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlVmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVByb3Zpc2lvbmluZ1RlbXBsYXRlVmVyc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBDQSBjZXJ0aWZpY2F0ZSByZWdpc3RyYXRpb24gY29kZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVJlZ2lzdHJhdGlvbkNvZGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlUmVnaXN0cmF0aW9uQ29kZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlUmVnaXN0cmF0aW9uQ29kZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgdGhlIHNwZWNpZmllZCByb2xlIGFsaWFzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlUm9sZUFsaWFzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVJvbGVBbGlhcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlUm9sZUFsaWFzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyBhIHNjaGVkdWxlZCBhdWRpdC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVNjaGVkdWxlZEF1ZGl0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVNjaGVkdWxlZEF1ZGl0KCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVTY2hlZHVsZWRBdWRpdCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBEZXZpY2UgRGVmZW5kZXIgc2VjdXJpdHkgcHJvZmlsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVNlY3VyaXR5UHJvZmlsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVTZWN1cml0eVByb2ZpbGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVNlY3VyaXR5UHJvZmlsZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgYSBzcGVjaWZpZWQgc3RyZWFtLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlU3RyZWFtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVN0cmVhbSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVsZXRlU3RyZWFtJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyB0aGUgc3BlY2lmaWVkIHRoaW5nLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlVGhpbmcuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlVGhpbmcoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVRoaW5nJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVsZXRlcyB0aGUgc3BlY2lmaWVkIHRoaW5nIGdyb3VwLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVUaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVRoaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVRoaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIHRoZSBzcGVjaWZpZWQgdGhpbmcgc2hhZG93LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3BvbGljeS1hY3Rpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RlbGV0ZVRoaW5nU2hhZG93KCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVUaGluZ1NoYWRvdycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgdGhlIHNwZWNpZmllZCB0aGluZyB0eXBlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZWxldGVUaGluZ1R5cGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlVGhpbmdUeXBlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZWxldGVUaGluZ1R5cGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWxldGVzIHRoZSBzcGVjaWZpZWQgcnVsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RlbGV0ZVRvcGljUnVsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZWxldGVUb3BpY1J1bGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVRvcGljUnVsZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlbGV0ZXMgdGhlIHNwZWNpZmllZCB2MiBsb2dnaW5nIGxldmVsLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVsZXRlVjJMb2dnaW5nTGV2ZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVsZXRlVjJMb2dnaW5nTGV2ZWwoKSB7XG4gICAgdGhpcy50bygnaW90OkRlbGV0ZVYyTG9nZ2luZ0xldmVsJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVwcmVjYXRlcyB0aGUgc3BlY2lmaWVkIHRoaW5nIHR5cGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXByZWNhdGVUaGluZ1R5cGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVwcmVjYXRlVGhpbmdUeXBlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXByZWNhdGVUaGluZ1R5cGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IGF1ZGl0IGNvbmZpZ3VyYXRpb25zIGZvciB0aGUgYWNjb3VudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQWNjb3VudEF1ZGl0Q29uZmlndXJhdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCBhIHNpbmdsZSBhdWRpdCBmaW5kaW5nLiBQcm9wZXJ0aWVzIGluY2x1ZGUgdGhlIHJlYXNvbiBmb3Igbm9uY29tcGxpYW5jZSwgdGhlIHNldmVyaXR5IG9mIHRoZSBpc3N1ZSwgYW5kIHdoZW4gdGhlIGF1ZGl0IHRoYXQgcmV0dXJuZWQgdGhlIGZpbmRpbmcgd2FzIHN0YXJ0ZWQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQXVkaXRGaW5kaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQXVkaXRGaW5kaW5nKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZUF1ZGl0RmluZGluZycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgYW4gYXVkaXQgbWl0aWdhdGlvbiB0YXNrIHRoYXQgaXMgdXNlZCB0byBhcHBseSBtaXRpZ2F0aW9uIGFjdGlvbnMgdG8gYSBzZXQgb2YgYXVkaXQgZmluZGluZ3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQXVkaXRNaXRpZ2F0aW9uQWN0aW9uc1Rhc2suaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFzaygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFzaycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgYSBEZXZpY2UgRGVmZW5kZXIgYXVkaXQgc3VwcHJlc3Npb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQXVkaXRTdXBwcmVzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUF1ZGl0U3VwcHJlc3Npb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlQXVkaXRTdXBwcmVzc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgYSBEZXZpY2UgRGVmZW5kZXIgYXVkaXQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlQXVkaXRUYXNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQXVkaXRUYXNrKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZUF1ZGl0VGFzaycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlcyBhbiBhdXRob3JpemVyLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUF1dGhvcml6ZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVBdXRob3JpemVyKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZUF1dGhvcml6ZXInKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IHRoZSBzcGVjaWZpZWQgYmlsbGluZyBncm91cC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVCaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVCaWxsaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlQmlsbGluZ0dyb3VwJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVzY3JpYmVzIGEgcmVnaXN0ZXJlZCBDQSBjZXJ0aWZpY2F0ZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVDQUNlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQ0FDZXJ0aWZpY2F0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVDQUNlcnRpZmljYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgc3BlY2lmaWVkIGNlcnRpZmljYXRlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUNlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlQ2VydGlmaWNhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXNjcmliZXMgdGhlIGRlZmF1bHQgYXV0aG9yaXplci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVEZWZhdWx0QXV0aG9yaXplci5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURlZmF1bHRBdXRob3JpemVyKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZURlZmF1bHRBdXRob3JpemVyJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUHJvdmlkZXMgZGV0YWlscyBhYm91dCBhIGRpbWVuc2lvbiB0aGF0IGlzIGRlZmluZWQgaW4geW91ciBBV1MgYWNjb3VudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVEaW1lbnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVEaW1lbnNpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlRGltZW5zaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgZG9tYWluIGNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlRG9tYWluQ29uZmlndXJhdGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZURvbWFpbkNvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlRG9tYWluQ29uZmlndXJhdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYSB1bmlxdWUgZW5kcG9pbnQgc3BlY2lmaWMgdG8gdGhlIEFXUyBhY2NvdW50IG1ha2luZyB0aGUgY2FsbC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVFbmRwb2ludC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZUVuZHBvaW50KCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZUVuZHBvaW50Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBhY2NvdW50IGV2ZW50IGNvbmZpZ3VyYXRpb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZUV2ZW50Q29uZmlndXJhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVFdmVudENvbmZpZ3VyYXRpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZUV2ZW50Q29uZmlndXJhdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IHRoZSBzcGVjaWZpZWQgaW5kZXguXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlSW5kZXguaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVJbmRleCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVJbmRleCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlcyBhIGpvYi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVKb2IuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVKb2IoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlSm9iJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGVzY3JpYmVzIGEgam9iIGV4ZWN1dGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVKb2JFeGVjdXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVKb2JFeGVjdXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlSm9iRXhlY3V0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCBhIG1pdGlnYXRpb24gYWN0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZU1pdGlnYXRpb25BY3Rpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVNaXRpZ2F0aW9uQWN0aW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZU1pdGlnYXRpb25BY3Rpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGluZm9ybWF0aW9uIGFib3V0IGEgZmxlZXQgcHJvdmlzaW9uaW5nIHRlbXBsYXRlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZVByb3Zpc2lvbmluZ1RlbXBsYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUHJvdmlzaW9uaW5nVGVtcGxhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlUHJvdmlzaW9uaW5nVGVtcGxhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm5zIGluZm9ybWF0aW9uIGFib3V0IGEgZmxlZXQgcHJvdmlzaW9uaW5nIHRlbXBsYXRlIHZlcnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZVByb3Zpc2lvbmluZ1RlbXBsYXRlVmVyc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERlc2NyaWJlcyBhIHJvbGUgYWxpYXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlUm9sZUFsaWFzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlUm9sZUFsaWFzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZVJvbGVBbGlhcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgYSBzY2hlZHVsZWQgYXVkaXQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlU2NoZWR1bGVkQXVkaXQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVTY2hlZHVsZWRBdWRpdCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVTY2hlZHVsZWRBdWRpdCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgYSBEZXZpY2UgRGVmZW5kZXIgc2VjdXJpdHkgcHJvZmlsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVTZWN1cml0eVByb2ZpbGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVTZWN1cml0eVByb2ZpbGUoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlU2VjdXJpdHlQcm9maWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgc3BlY2lmaWVkIHN0cmVhbS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGVzY3JpYmVTdHJlYW0uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGVzY3JpYmVTdHJlYW0oKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlU3RyZWFtJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgc3BlY2lmaWVkIHRoaW5nLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZVRoaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVGhpbmcoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlVGhpbmcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGluZm9ybWF0aW9uIGFib3V0IHRoZSBzcGVjaWZpZWQgdGhpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVGhpbmdHcm91cC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVRoaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OkRlc2NyaWJlVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgdGhlIGJ1bGsgdGhpbmcgcmVnaXN0cmF0aW9uIHRhc2suXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVGhpbmdSZWdpc3RyYXRpb25UYXNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVGhpbmdSZWdpc3RyYXRpb25UYXNrKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZVRoaW5nUmVnaXN0cmF0aW9uVGFzaycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHNwZWNpZmllZCB0aGluZyB0eXBlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXNjcmliZVRoaW5nVHlwZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXNjcmliZVRoaW5nVHlwZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGVzY3JpYmVUaGluZ1R5cGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEZXNjcmliZXMgYSB0dW5uZWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0Rlc2NyaWJlVHVubmVsLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0Rlc2NyaWJlVHVubmVsKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXNjcmliZVR1bm5lbCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIERldGFjaGVzIGEgcG9saWN5IGZyb20gdGhlIHNwZWNpZmllZCB0YXJnZXQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0RldGFjaFBvbGljeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EZXRhY2hQb2xpY3koKSB7XG4gICAgdGhpcy50bygnaW90OkRldGFjaFBvbGljeScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbW92ZXMgdGhlIHNwZWNpZmllZCBwb2xpY3kgZnJvbSB0aGUgc3BlY2lmaWVkIGNlcnRpZmljYXRlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFBlcm1pc3Npb25zIG1hbmFnZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9EZXRhY2hQcmluY2lwYWxQb2xpY3kuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGV0YWNoUHJpbmNpcGFsUG9saWN5KCkge1xuICAgIHRoaXMudG8oJ2lvdDpEZXRhY2hQcmluY2lwYWxQb2xpY3knKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBEaXNhc3NvY2lhdGVzIGEgRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGUgZnJvbSBhIHRoaW5nIGdyb3VwIG9yIGZyb20gdGhpcyBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGV0YWNoU2VjdXJpdHlQcm9maWxlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0RldGFjaFNlY3VyaXR5UHJvZmlsZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6RGV0YWNoU2VjdXJpdHlQcm9maWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGV0YWNoZXMgdGhlIHNwZWNpZmllZCBwcmluY2lwYWwgZnJvbSB0aGUgc3BlY2lmaWVkIHRoaW5nLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGV0YWNoVGhpbmdQcmluY2lwYWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRGV0YWNoVGhpbmdQcmluY2lwYWwoKSB7XG4gICAgdGhpcy50bygnaW90OkRldGFjaFRoaW5nUHJpbmNpcGFsJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRGlzYWJsZXMgdGhlIHNwZWNpZmllZCBydWxlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfRGlzYWJsZVRvcGljUnVsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9EaXNhYmxlVG9waWNSdWxlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpEaXNhYmxlVG9waWNSdWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogRW5hYmxlcyB0aGUgc3BlY2lmaWVkIHJ1bGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9FbmFibGVUb3BpY1J1bGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvRW5hYmxlVG9waWNSdWxlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpFbmFibGVUb3BpY1J1bGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXQgY2FyZGluYWxpdHkgZm9yIElvVCBmbGVldCBpbmRleFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRDYXJkaW5hbGl0eS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRDYXJkaW5hbGl0eSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6R2V0Q2FyZGluYWxpdHknKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGVmZmVjdGl2ZSBwb2xpY2llcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0RWZmZWN0aXZlUG9saWNpZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0RWZmZWN0aXZlUG9saWNpZXMoKSB7XG4gICAgdGhpcy50bygnaW90OkdldEVmZmVjdGl2ZVBvbGljaWVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBjdXJyZW50IGZsZWV0IGluZGV4aW5nIGNvbmZpZ3VyYXRpb25cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0SW5kZXhpbmdDb25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldEluZGV4aW5nQ29uZmlndXJhdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6R2V0SW5kZXhpbmdDb25maWd1cmF0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBhIGpvYiBkb2N1bWVudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0Sm9iRG9jdW1lbnQuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0Sm9iRG9jdW1lbnQoKSB7XG4gICAgdGhpcy50bygnaW90OkdldEpvYkRvY3VtZW50Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgbG9nZ2luZyBvcHRpb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRMb2dnaW5nT3B0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRMb2dnaW5nT3B0aW9ucygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6R2V0TG9nZ2luZ09wdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIHRoZSBpbmZvcm1hdGlvbiBhYm91dCB0aGUgT1RBIHVwZGF0ZSBqb2IuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldE9UQVVwZGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRPVEFVcGRhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OkdldE9UQVVwZGF0ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdGhlIGxpc3Qgb2YgYWxsIGpvYnMgZm9yIGEgdGhpbmcgdGhhdCBhcmUgbm90IGluIGEgdGVybWluYWwgc3RhdGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldFBlbmRpbmdKb2JFeGVjdXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFBlbmRpbmdKb2JFeGVjdXRpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpHZXRQZW5kaW5nSm9iRXhlY3V0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCBwZXJjZW50aWxlcyBmb3IgSW9UIGZsZWV0IGluZGV4XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldFBlcmNlbnRpbGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFBlcmNlbnRpbGVzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpHZXRQZXJjZW50aWxlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHNwZWNpZmllZCBwb2xpY3kgd2l0aCB0aGUgcG9saWN5IGRvY3VtZW50IG9mIHRoZSBkZWZhdWx0IHZlcnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldFBvbGljeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRQb2xpY3koKSB7XG4gICAgdGhpcy50bygnaW90OkdldFBvbGljeScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgaW5mb3JtYXRpb24gYWJvdXQgdGhlIHNwZWNpZmllZCBwb2xpY3kgdmVyc2lvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0UG9saWN5VmVyc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRQb2xpY3lWZXJzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpHZXRQb2xpY3lWZXJzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBhIHJlZ2lzdHJhdGlvbiBjb2RlIHVzZWQgdG8gcmVnaXN0ZXIgYSBDQSBjZXJ0aWZpY2F0ZSB3aXRoIEFXUyBJb1QuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldFJlZ2lzdHJhdGlvbkNvZGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0UmVnaXN0cmF0aW9uQ29kZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6R2V0UmVnaXN0cmF0aW9uQ29kZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCBzdGF0aXN0aWNzIGZvciBJb1QgZmxlZXQgaW5kZXhcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfR2V0U3RhdGlzdGljcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRTdGF0aXN0aWNzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpHZXRTdGF0aXN0aWNzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgdGhpbmcgc2hhZG93LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvcG9saWN5LWFjdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvR2V0VGhpbmdTaGFkb3coKSB7XG4gICAgdGhpcy50bygnaW90OkdldFRoaW5nU2hhZG93Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBpbmZvcm1hdGlvbiBhYm91dCB0aGUgc3BlY2lmaWVkIHJ1bGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0dldFRvcGljUnVsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9HZXRUb3BpY1J1bGUoKSB7XG4gICAgdGhpcy50bygnaW90OkdldFRvcGljUnVsZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEdldHMgdjIgbG9nZ2luZyBvcHRpb25zLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFJlYWRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9HZXRWMkxvZ2dpbmdPcHRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0dldFYyTG9nZ2luZ09wdGlvbnMoKSB7XG4gICAgdGhpcy50bygnaW90OkdldFYyTG9nZ2luZ09wdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgYWN0aXZlIHZpb2xhdGlvbnMgZm9yIGEgZ2l2ZW4gRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGUgb3IgVGhpbmcuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RBY3RpdmVWaW9sYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBY3RpdmVWaW9sYXRpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0QWN0aXZlVmlvbGF0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBwb2xpY2llcyBhdHRhY2hlZCB0byB0aGUgc3BlY2lmaWVkIHRoaW5nIGdyb3VwLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0QXR0YWNoZWRQb2xpY2llcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QXR0YWNoZWRQb2xpY2llcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdEF0dGFjaGVkUG9saWNpZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgZmluZGluZ3MgKHJlc3VsdHMpIG9mIGEgRGV2aWNlIERlZmVuZGVyIGF1ZGl0IG9yIG9mIHRoZSBhdWRpdHMgcGVyZm9ybWVkIGR1cmluZyBhIHNwZWNpZmllZCB0aW1lIHBlcmlvZC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEF1ZGl0RmluZGluZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEF1ZGl0RmluZGluZ3MoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RBdWRpdEZpbmRpbmdzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgc3RhdHVzIG9mIGF1ZGl0IG1pdGlnYXRpb24gYWN0aW9uIHRhc2tzIHRoYXQgd2VyZSBleGVjdXRlZC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNFeGVjdXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBdWRpdE1pdGlnYXRpb25BY3Rpb25zRXhlY3V0aW9ucygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNFeGVjdXRpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBhIGxpc3Qgb2YgYXVkaXQgbWl0aWdhdGlvbiBhY3Rpb24gdGFza3MgdGhhdCBtYXRjaCB0aGUgc3BlY2lmaWVkIGZpbHRlcnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFza3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNUYXNrcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNUYXNrcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHlvdXIgRGV2aWNlIERlZmVuZGVyIGF1ZGl0IHN1cHByZXNzaW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEF1ZGl0U3VwcHJlc3Npb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RBdWRpdFN1cHByZXNzaW9ucygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdEF1ZGl0U3VwcHJlc3Npb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIERldmljZSBEZWZlbmRlciBhdWRpdHMgdGhhdCBoYXZlIGJlZW4gcGVyZm9ybWVkIGR1cmluZyBhIGdpdmVuIHRpbWUgcGVyaW9kLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0QXVkaXRUYXNrcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QXVkaXRUYXNrcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdEF1ZGl0VGFza3MnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgYXV0aG9yaXplcnMgcmVnaXN0ZXJlZCBpbiB5b3VyIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RBdXRob3JpemVycy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0QXV0aG9yaXplcnMoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RBdXRob3JpemVycycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFsbCBiaWxsaW5nIGdyb3Vwcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEJpbGxpbmdHcm91cHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEJpbGxpbmdHcm91cHMoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RCaWxsaW5nR3JvdXBzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIENBIGNlcnRpZmljYXRlcyByZWdpc3RlcmVkIGZvciB5b3VyIEFXUyBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0Q0FDZXJ0aWZpY2F0ZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdENBQ2VydGlmaWNhdGVzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0Q0FDZXJ0aWZpY2F0ZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB5b3VyIGNlcnRpZmljYXRlcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdENlcnRpZmljYXRlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Q2VydGlmaWNhdGVzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0Q2VydGlmaWNhdGVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCB0aGUgZGV2aWNlIGNlcnRpZmljYXRlcyBzaWduZWQgYnkgdGhlIHNwZWNpZmllZCBDQSBjZXJ0aWZpY2F0ZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdENlcnRpZmljYXRlc0J5Q0EuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdENlcnRpZmljYXRlc0J5Q0EoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RDZXJ0aWZpY2F0ZXNCeUNBJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIGRpbWVuc2lvbnMgdGhhdCBhcmUgZGVmaW5lZCBmb3IgeW91ciBBV1MgYWNjb3VudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdERpbWVuc2lvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdERpbWVuc2lvbnMoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3REaW1lbnNpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIGRvbWFpbiBjb25maWd1cmF0aW9uIGNyZWF0ZWQgYnkgeW91ciBBV1MgYWNjb3VudC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdERvbWFpbkNvbmZpZ3VyYXRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3REb21haW5Db25maWd1cmF0aW9ucygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdERvbWFpbkNvbmZpZ3VyYXRpb25zJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgYWxsIGluZGljZXMgZm9yIGZsZWV0IGluZGV4XG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RJbmRpY2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RJbmRpY2VzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0SW5kaWNlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBqb2IgZXhlY3V0aW9ucyBmb3IgYSBqb2IuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RKb2JFeGVjdXRpb25zRm9ySm9iLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RKb2JFeGVjdXRpb25zRm9ySm9iKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0Sm9iRXhlY3V0aW9uc0ZvckpvYicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBqb2IgZXhlY3V0aW9ucyBmb3IgdGhlIHNwZWNpZmllZCB0aGluZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEpvYkV4ZWN1dGlvbnNGb3JUaGluZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0Sm9iRXhlY3V0aW9uc0ZvclRoaW5nKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0Sm9iRXhlY3V0aW9uc0ZvclRoaW5nJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgam9icy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdEpvYnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdEpvYnMoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RKb2JzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogR2V0cyBhIGxpc3Qgb2YgYWxsIG1pdGlnYXRpb24gYWN0aW9ucyB0aGF0IG1hdGNoIHRoZSBzcGVjaWZpZWQgZmlsdGVyIGNyaXRlcmlhLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0TWl0aWdhdGlvbkFjdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdE1pdGlnYXRpb25BY3Rpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0TWl0aWdhdGlvbkFjdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyBhbGwgbmFtZWQgc2hhZG93cyBmb3IgYSBnaXZlbiB0aGluZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdE5hbWVkU2hhZG93c0ZvclRoaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3ROYW1lZFNoYWRvd3NGb3JUaGluZygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdE5hbWVkU2hhZG93c0ZvclRoaW5nJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgT1RBIHVwZGF0ZSBqb2JzIGluIHRoZSBhY2NvdW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0T1RBVXBkYXRlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0T1RBVXBkYXRlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdE9UQVVwZGF0ZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyBjZXJ0aWZpY2F0ZXMgdGhhdCBhcmUgYmVpbmcgdHJhbnNmZXJlZCBidXQgbm90IHlldCBhY2NlcHRlZC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdE91dGdvaW5nQ2VydGlmaWNhdGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RPdXRnb2luZ0NlcnRpZmljYXRlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdE91dGdvaW5nQ2VydGlmaWNhdGVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgeW91ciBwb2xpY2llcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQb2xpY2llcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFBvbGljaWVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIHByaW5jaXBhbHMgYXNzb2NpYXRlZCB3aXRoIHRoZSBzcGVjaWZpZWQgcG9saWN5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0UG9saWN5UHJpbmNpcGFscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UG9saWN5UHJpbmNpcGFscygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFBvbGljeVByaW5jaXBhbHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgdmVyc2lvbnMgb2YgdGhlIHNwZWNpZmllZCBwb2xpY3ksIGFuZCBpZGVudGlmaWVzIHRoZSBkZWZhdWx0IHZlcnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RQb2xpY3lWZXJzaW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0UG9saWN5VmVyc2lvbnMoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RQb2xpY3lWZXJzaW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBwb2xpY2llcyBhdHRhY2hlZCB0byB0aGUgc3BlY2lmaWVkIHByaW5jaXBhbC4gSWYgeW91IHVzZSBhbiBBbWF6b24gQ29nbml0byBpZGVudGl0eSwgdGhlIElEIG5lZWRzIHRvIGJlIGluIEFtYXpvbiBDb2duaXRvIElkZW50aXR5IGZvcm1hdC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFByaW5jaXBhbFBvbGljaWVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcmluY2lwYWxQb2xpY2llcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFByaW5jaXBhbFBvbGljaWVzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIHRoaW5ncyBhc3NvY2lhdGVkIHdpdGggdGhlIHNwZWNpZmllZCBwcmluY2lwYWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RQcmluY2lwYWxUaGluZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFByaW5jaXBhbFRoaW5ncygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFByaW5jaXBhbFRoaW5ncycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIEEgbGlzdCBvZiBmbGVldCBwcm92aXNpb25pbmcgdGVtcGxhdGUgdmVyc2lvbnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0UHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBmbGVldCBwcm92aXNpb25pbmcgdGVtcGxhdGVzIGluIHlvdXIgQVdTIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RQcm92aXNpb25pbmdUZW1wbGF0ZXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFByb3Zpc2lvbmluZ1RlbXBsYXRlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFByb3Zpc2lvbmluZ1RlbXBsYXRlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHJvbGUgYWxpYXNlcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFJvbGVBbGlhc2VzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RSb2xlQWxpYXNlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFJvbGVBbGlhc2VzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgYWxsIG9mIHlvdXIgc2NoZWR1bGVkIGF1ZGl0cy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFNjaGVkdWxlZEF1ZGl0cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2NoZWR1bGVkQXVkaXRzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0U2NoZWR1bGVkQXVkaXRzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgdGhlIERldmljZSBEZWZlbmRlciBzZWN1cml0eSBwcm9maWxlcyB5b3UgaGF2ZSBjcmVhdGVkLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0U2VjdXJpdHlQcm9maWxlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VjdXJpdHlQcm9maWxlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFNlY3VyaXR5UHJvZmlsZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGVzIGF0dGFjaGVkIHRvIGEgdGFyZ2V0LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0U2VjdXJpdHlQcm9maWxlc0ZvclRhcmdldC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0U2VjdXJpdHlQcm9maWxlc0ZvclRhcmdldCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFNlY3VyaXR5UHJvZmlsZXNGb3JUYXJnZXQnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgc3RyZWFtcyBpbiB5b3VyIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RTdHJlYW1zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RTdHJlYW1zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0U3RyZWFtcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFsbCB0YWdzIGZvciBhIGdpdmVuIHJlc291cmNlLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VGFnc0ZvclJlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUYWdzRm9yUmVzb3VyY2UoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RUYWdzRm9yUmVzb3VyY2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0IHRhcmdldHMgZm9yIHRoZSBzcGVjaWZpZWQgcG9saWN5LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VGFyZ2V0c0ZvclBvbGljeS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGFyZ2V0c0ZvclBvbGljeSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRhcmdldHNGb3JQb2xpY3knKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgdGFyZ2V0cyBhc3NvY2lhdGVkIHdpdGggYSBnaXZlbiBEZXZpY2UgRGVmZW5kZXIgc2VjdXJpdHkgcHJvZmlsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFRhcmdldHNGb3JTZWN1cml0eVByb2ZpbGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRhcmdldHNGb3JTZWN1cml0eVByb2ZpbGUoKSB7XG4gICAgdGhpcy50bygnaW90Okxpc3RUYXJnZXRzRm9yU2VjdXJpdHlQcm9maWxlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgYWxsIHRoaW5nIGdyb3Vwcy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFRoaW5nR3JvdXBzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUaGluZ0dyb3VwcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRoaW5nR3JvdXBzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdCB0aGluZyBncm91cHMgdG8gd2hpY2ggdGhlIHNwZWNpZmllZCB0aGluZyBiZWxvbmdzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VGhpbmdHcm91cHNGb3JUaGluZy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGhpbmdHcm91cHNGb3JUaGluZygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRoaW5nR3JvdXBzRm9yVGhpbmcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgcHJpbmNpcGFscyBhc3NvY2lhdGVkIHdpdGggdGhlIHNwZWNpZmllZCB0aGluZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFRoaW5nUHJpbmNpcGFscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGhpbmdQcmluY2lwYWxzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0VGhpbmdQcmluY2lwYWxzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogTGlzdHMgaW5mb3JtYXRpb24gYWJvdXQgYnVsayB0aGluZyByZWdpc3RyYXRpb24gdGFza3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RUaGluZ1JlZ2lzdHJhdGlvblRhc2tSZXBvcnRzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUaGluZ1JlZ2lzdHJhdGlvblRhc2tSZXBvcnRzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0VGhpbmdSZWdpc3RyYXRpb25UYXNrUmVwb3J0cycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGJ1bGsgdGhpbmcgcmVnaXN0cmF0aW9uIHRhc2tzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VGhpbmdSZWdpc3RyYXRpb25UYXNrcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VGhpbmdSZWdpc3RyYXRpb25UYXNrcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRoaW5nUmVnaXN0cmF0aW9uVGFza3MnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyBhbGwgdGhpbmcgdHlwZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RUaGluZ1R5cGVzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b0xpc3RUaGluZ1R5cGVzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0VGhpbmdUeXBlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFsbCB0aGluZ3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RUaGluZ3MuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRoaW5ncygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRoaW5ncycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIGFsbCB0aGluZ3MgaW4gdGhlIHNwZWNpZmllZCBiaWxsaW5nIGdyb3VwLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VGhpbmdzSW5CaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRoaW5nc0luQmlsbGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0VGhpbmdzSW5CaWxsaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyBhbGwgdGhpbmdzIGluIHRoZSBzcGVjaWZpZWQgdGhpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RUaGluZ3NJblRoaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFRoaW5nc0luVGhpbmdHcm91cCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRoaW5nc0luVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBydWxlcyBmb3IgdGhlIHNwZWNpZmljIHRvcGljLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VG9waWNSdWxlcy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VG9waWNSdWxlcygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFRvcGljUnVsZXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0dW5uZWxzLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IExpc3RcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9MaXN0VHVubmVscy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VHVubmVscygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFR1bm5lbHMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBMaXN0cyB0aGUgdjIgbG9nZ2luZyBsZXZlbHMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogTGlzdFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX0xpc3RWMkxvZ2dpbmdMZXZlbHMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvTGlzdFYyTG9nZ2luZ0xldmVscygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6TGlzdFYyTG9nZ2luZ0xldmVscycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3RzIHRoZSBEZXZpY2UgRGVmZW5kZXIgc2VjdXJpdHkgcHJvZmlsZSB2aW9sYXRpb25zIGRpc2NvdmVyZWQgZHVyaW5nIHRoZSBnaXZlbiB0aW1lIHBlcmlvZC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBMaXN0XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfTGlzdFZpb2xhdGlvbkV2ZW50cy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9MaXN0VmlvbGF0aW9uRXZlbnRzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpMaXN0VmlvbGF0aW9uRXZlbnRzJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogT3BlbnMgYSB0dW5uZWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXF1ZXN0VGFnKClcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICogLSAuaWZUaGluZ0dyb3VwQXJuKClcbiAgICogLSAuaWZUdW5uZWxEZXN0aW5hdGlvblNlcnZpY2UoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX09wZW5UdW5uZWwuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvT3BlblR1bm5lbCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6T3BlblR1bm5lbCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFB1Ymxpc2ggdG8gdGhlIHNwZWNpZmllZCB0b3BpYy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9wb2xpY3ktYWN0aW9ucy5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9QdWJsaXNoKCkge1xuICAgIHRoaXMudG8oJ2lvdDpQdWJsaXNoJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmVjZWl2ZSBmcm9tIHRoZSBzcGVjaWZpZWQgdG9waWMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvcG9saWN5LWFjdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVjZWl2ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6UmVjZWl2ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlZ2lzdGVycyBhIENBIGNlcnRpZmljYXRlIHdpdGggQVdTIElvVC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1JlcXVlc3RUYWcoKVxuICAgKiAtIC5pZkF3c1RhZ0tleXMoKVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1JlZ2lzdGVyQ0FDZXJ0aWZpY2F0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9SZWdpc3RlckNBQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OlJlZ2lzdGVyQ0FDZXJ0aWZpY2F0ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlZ2lzdGVycyBhIGRldmljZSBjZXJ0aWZpY2F0ZSB3aXRoIEFXUyBJb1QuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9SZWdpc3RlckNlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1JlZ2lzdGVyQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OlJlZ2lzdGVyQ2VydGlmaWNhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZWdpc3RlcnMgYSBkZXZpY2UgY2VydGlmaWNhdGUgd2l0aCBBV1MgSW9UIHdpdGhvdXQgYSByZWdpc3RlcmVkIENBIChjZXJ0aWZpY2F0ZSBhdXRob3JpdHkpLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfUmVnaXN0ZXJDZXJ0aWZpY2F0ZVdpdGhvdXRDQS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9SZWdpc3RlckNlcnRpZmljYXRlV2l0aG91dENBKCkge1xuICAgIHRoaXMudG8oJ2lvdDpSZWdpc3RlckNlcnRpZmljYXRlV2l0aG91dENBJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogUmVnaXN0ZXJzIHlvdXIgdGhpbmcuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9SZWdpc3RlclRoaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1JlZ2lzdGVyVGhpbmcoKSB7XG4gICAgdGhpcy50bygnaW90OlJlZ2lzdGVyVGhpbmcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZWplY3RzIGEgcGVuZGluZyBjZXJ0aWZpY2F0ZSB0cmFuc2Zlci5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1JlamVjdENlcnRpZmljYXRlVHJhbnNmZXIuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVqZWN0Q2VydGlmaWNhdGVUcmFuc2ZlcigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6UmVqZWN0Q2VydGlmaWNhdGVUcmFuc2ZlcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlbW92ZXMgdGhpbmcgZnJvbSB0aGUgc3BlY2lmaWVkIGJpbGxpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9SZW1vdmVUaGluZ0Zyb21CaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVtb3ZlVGhpbmdGcm9tQmlsbGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpSZW1vdmVUaGluZ0Zyb21CaWxsaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW1vdmVzIHRoaW5nIGZyb20gdGhlIHNwZWNpZmllZCB0aGluZyBncm91cC5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1JlbW92ZVRoaW5nRnJvbVRoaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVtb3ZlVGhpbmdGcm9tVGhpbmdHcm91cCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6UmVtb3ZlVGhpbmdGcm9tVGhpbmdHcm91cCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFJlcGxhY2VzIHRoZSBzcGVjaWZpZWQgcnVsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1JlcGxhY2VUb3BpY1J1bGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvUmVwbGFjZVRvcGljUnVsZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6UmVwbGFjZVRvcGljUnVsZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFNlYXJjaCBJb1QgZmxlZXQgaW5kZXhcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfU2VhcmNoSW5kZXguaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU2VhcmNoSW5kZXgoKSB7XG4gICAgdGhpcy50bygnaW90OlNlYXJjaEluZGV4Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU2V0cyB0aGUgZGVmYXVsdCBhdXRob3JpemVyLiBUaGlzIHdpbGwgYmUgdXNlZCBpZiBhIHdlYnNvY2tldCBjb25uZWN0aW9uIGlzIG1hZGUgd2l0aG91dCBzcGVjaWZ5aW5nIGFuIGF1dGhvcml6ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1NldERlZmF1bHRBdXRob3JpemVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NldERlZmF1bHRBdXRob3JpemVyKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTZXREZWZhdWx0QXV0aG9yaXplcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFNldHMgdGhlIHNwZWNpZmllZCB2ZXJzaW9uIG9mIHRoZSBzcGVjaWZpZWQgcG9saWN5IGFzIHRoZSBwb2xpY3kncyBkZWZhdWx0IChvcGVyYXRpdmUpIHZlcnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUGVybWlzc2lvbnMgbWFuYWdlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1NldERlZmF1bHRQb2xpY3lWZXJzaW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NldERlZmF1bHRQb2xpY3lWZXJzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTZXREZWZhdWx0UG9saWN5VmVyc2lvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFNldHMgdGhlIGxvZ2dpbmcgb3B0aW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1NldExvZ2dpbmdPcHRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NldExvZ2dpbmdPcHRpb25zKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTZXRMb2dnaW5nT3B0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFNldHMgdGhlIHYyIGxvZ2dpbmcgbGV2ZWwuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9TZXRWMkxvZ2dpbmdMZXZlbC5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TZXRWMkxvZ2dpbmdMZXZlbCgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6U2V0VjJMb2dnaW5nTGV2ZWwnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBTZXRzIHRoZSB2MiBsb2dnaW5nIG9wdGlvbnMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9TZXRWMkxvZ2dpbmdPcHRpb25zLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1NldFYyTG9nZ2luZ09wdGlvbnMoKSB7XG4gICAgdGhpcy50bygnaW90OlNldFYyTG9nZ2luZ09wdGlvbnMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBTdGFydHMgYSB0YXNrIHRoYXQgYXBwbGllcyBhIHNldCBvZiBtaXRpZ2F0aW9uIGFjdGlvbnMgdG8gdGhlIHNwZWNpZmllZCB0YXJnZXQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9TdGFydEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNUYXNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0QXVkaXRNaXRpZ2F0aW9uQWN0aW9uc1Rhc2soKSB7XG4gICAgdGhpcy50bygnaW90OlN0YXJ0QXVkaXRNaXRpZ2F0aW9uQWN0aW9uc1Rhc2snKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIGFuZCBzdGFydHMgdGhlIG5leHQgcGVuZGluZyBqb2IgZXhlY3V0aW9uIGZvciBhIHRoaW5nLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfU3RhcnROZXh0UGVuZGluZ0pvYkV4ZWN1dGlvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdGFydE5leHRQZW5kaW5nSm9iRXhlY3V0aW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTdGFydE5leHRQZW5kaW5nSm9iRXhlY3V0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU3RhcnRzIGFuIG9uLWRlbWFuZCBEZXZpY2UgRGVmZW5kZXIgYXVkaXQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9TdGFydE9uRGVtYW5kQXVkaXRUYXNrLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1N0YXJ0T25EZW1hbmRBdWRpdFRhc2soKSB7XG4gICAgdGhpcy50bygnaW90OlN0YXJ0T25EZW1hbmRBdWRpdFRhc2snKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBTdGFydHMgYSBidWxrIHRoaW5nIHJlZ2lzdHJhdGlvbiB0YXNrLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfU3RhcnRUaGluZ1JlZ2lzdHJhdGlvblRhc2suaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3RhcnRUaGluZ1JlZ2lzdHJhdGlvblRhc2soKSB7XG4gICAgdGhpcy50bygnaW90OlN0YXJ0VGhpbmdSZWdpc3RyYXRpb25UYXNrJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU3RvcHMgYSBidWxrIHRoaW5nIHJlZ2lzdHJhdGlvbiB0YXNrLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfU3RvcFRoaW5nUmVnaXN0cmF0aW9uVGFzay5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9TdG9wVGhpbmdSZWdpc3RyYXRpb25UYXNrKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTdG9wVGhpbmdSZWdpc3RyYXRpb25UYXNrJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogU3Vic2NyaWJlIHRvIHRoZSBzcGVjaWZpZWQgVG9waWNGaWx0ZXIuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvcG9saWN5LWFjdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvU3Vic2NyaWJlKCkge1xuICAgIHRoaXMudG8oJ2lvdDpTdWJzY3JpYmUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBUYWcgYSBzcGVjaWZpZWQgcmVzb3VyY2VcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBUYWdnaW5nXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVxdWVzdFRhZygpXG4gICAqIC0gLmlmQXdzVGFnS2V5cygpXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVGFnUmVzb3VyY2UuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGFnUmVzb3VyY2UoKSB7XG4gICAgdGhpcy50bygnaW90OlRhZ1Jlc291cmNlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVGVzdCB0aGUgcG9saWNpZXMgZXZhbHVhdGlvbiBmb3IgZ3JvdXAgcG9saWNpZXNcbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBSZWFkXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVGVzdEF1dGhvcml6YXRpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVGVzdEF1dGhvcml6YXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OlRlc3RBdXRob3JpemF0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogSW52b2tlIHRoZSBzcGVjaWZpZWQgY3VzdG9tIGF1dGhvcml6ZXIgZm9yIHRlc3RpbmcgcHVycG9zZXMuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1Rlc3RJbnZva2VBdXRob3JpemVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1Rlc3RJbnZva2VBdXRob3JpemVyKCkge1xuICAgIHRoaXMudG8oJ2lvdDpUZXN0SW52b2tlQXV0aG9yaXplcicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFRyYW5zZmVycyB0aGUgc3BlY2lmaWVkIGNlcnRpZmljYXRlIHRvIHRoZSBzcGVjaWZpZWQgQVdTIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9UcmFuc2ZlckNlcnRpZmljYXRlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1RyYW5zZmVyQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OlRyYW5zZmVyQ2VydGlmaWNhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVbnRhZyBhIHNwZWNpZmllZCByZXNvdXJjZVxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFRhZ2dpbmdcbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NUYWdLZXlzKClcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VbnRhZ1Jlc291cmNlLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VudGFnUmVzb3VyY2UoKSB7XG4gICAgdGhpcy50bygnaW90OlVudGFnUmVzb3VyY2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBDb25maWd1cmVzIG9yIHJlY29uZmlndXJlcyB0aGUgRGV2aWNlIERlZmVuZGVyIGF1ZGl0IHNldHRpbmdzIGZvciB0aGlzIGFjY291bnQuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUFjY291bnRBdWRpdENvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZUFjY291bnRBdWRpdENvbmZpZ3VyYXRpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGEgRGV2aWNlIERlZmVuZGVyIGF1ZGl0IHN1cHByZXNzaW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQXVkaXRTdXBwcmVzc2lvbi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVBdWRpdFN1cHByZXNzaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVBdWRpdFN1cHByZXNzaW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyBhbiBhdXRob3JpemVyXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVBdXRob3JpemVyLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUF1dGhvcml6ZXIoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZUF1dGhvcml6ZXInKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGluZm9ybWF0aW9uIGFzc29jaWF0ZWQgd2l0aCB0aGUgc3BlY2lmaWVkIGJpbGxpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVCaWxsaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQmlsbGluZ0dyb3VwKCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVCaWxsaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGEgcmVnaXN0ZXJlZCBDQSBjZXJ0aWZpY2F0ZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZUNBQ2VydGlmaWNhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQ0FDZXJ0aWZpY2F0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlQ0FDZXJ0aWZpY2F0ZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgdGhlIHN0YXR1cyBvZiB0aGUgc3BlY2lmaWVkIGNlcnRpZmljYXRlLiBUaGlzIG9wZXJhdGlvbiBpcyBpZGVtcG90ZW50LlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlQ2VydGlmaWNhdGUuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlQ2VydGlmaWNhdGUoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZUNlcnRpZmljYXRlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyB0aGUgZGVmaW5pdGlvbiBmb3IgYSBkaW1lbnNpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVEaW1lbnNpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRGltZW5zaW9uKCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVEaW1lbnNpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGEgZG9tYWluIGNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVEb21haW5Db25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZURvbWFpbkNvbmZpZ3VyYXRpb24oKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZURvbWFpbkNvbmZpZ3VyYXRpb24nKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGEgRHluYW1pYyBUaGluZyBHcm91cFxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlRHluYW1pY1RoaW5nR3JvdXAuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRHluYW1pY1RoaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZUR5bmFtaWNUaGluZ0dyb3VwJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyBldmVudCBjb25maWd1cmF0aW9ucy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZUV2ZW50Q29uZmlndXJhdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlRXZlbnRDb25maWd1cmF0aW9ucygpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlRXZlbnRDb25maWd1cmF0aW9ucycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgZmxlZXQgaW5kZXhpbmcgY29uZmlndXJhdGlvblxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlSW5kZXhpbmdDb25maWd1cmF0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUluZGV4aW5nQ29uZmlndXJhdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlSW5kZXhpbmdDb25maWd1cmF0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyBhIGpvYi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZUpvYi5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVKb2IoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZUpvYicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgYSBqb2IgZXhlY3V0aW9uLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlSm9iRXhlY3V0aW9uLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZUpvYkV4ZWN1dGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlSm9iRXhlY3V0aW9uJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyB0aGUgZGVmaW5pdGlvbiBmb3IgdGhlIHNwZWNpZmllZCBtaXRpZ2F0aW9uIGFjdGlvbi5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZU1pdGlnYXRpb25BY3Rpb24uaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlTWl0aWdhdGlvbkFjdGlvbigpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlTWl0aWdhdGlvbkFjdGlvbicpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgYSBmbGVldCBwcm92aXNpb25pbmcgdGVtcGxhdGUuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVQcm92aXNpb25pbmdUZW1wbGF0ZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVQcm92aXNpb25pbmdUZW1wbGF0ZSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGUnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIHRoZSByb2xlIGFsaWFzXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVSb2xlQWxpYXMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlUm9sZUFsaWFzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVSb2xlQWxpYXMnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIGEgc2NoZWR1bGVkIGF1ZGl0LCBpbmNsdWRpbmcgd2hhdCBjaGVja3MgYXJlIHBlcmZvcm1lZCBhbmQgaG93IG9mdGVuIHRoZSBhdWRpdCB0YWtlcyBwbGFjZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZVNjaGVkdWxlZEF1ZGl0Lmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVNjaGVkdWxlZEF1ZGl0KCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVTY2hlZHVsZWRBdWRpdCcpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgYSBEZXZpY2UgRGVmZW5kZXIgc2VjdXJpdHkgcHJvZmlsZS5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZVNlY3VyaXR5UHJvZmlsZS5odG1sXG4gICAqL1xuICBwdWJsaWMgdG9VcGRhdGVTZWN1cml0eVByb2ZpbGUoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZVNlY3VyaXR5UHJvZmlsZScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgdGhlIGRhdGEgZm9yIGEgc3RyZWFtLlxuICAgKlxuICAgKiBBY2Nlc3MgTGV2ZWw6IFdyaXRlXG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2FwaXJlZmVyZW5jZS9BUElfVXBkYXRlU3RyZWFtLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVN0cmVhbSgpIHtcbiAgICB0aGlzLnRvKCdpb3Q6VXBkYXRlU3RyZWFtJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVXBkYXRlcyBpbmZvcm1hdGlvbiBhc3NvY2lhdGVkIHdpdGggdGhlIHNwZWNpZmllZCB0aGluZy5cbiAgICpcbiAgICogQWNjZXNzIExldmVsOiBXcml0ZVxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1VwZGF0ZVRoaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVRoaW5nKCkge1xuICAgIHRoaXMudG8oJ2lvdDpVcGRhdGVUaGluZycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIFVwZGF0ZXMgaW5mb3JtYXRpb24gYXNzb2NpYXRlZCB3aXRoIHRoZSBzcGVjaWZpZWQgdGhpbmcgZ3JvdXAuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVUaGluZ0dyb3VwLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVRoaW5nR3JvdXAoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZVRoaW5nR3JvdXAnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIHRoZSB0aGluZyBncm91cHMgdG8gd2hpY2ggdGhlIHRoaW5nIGJlbG9uZ3MuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvYXBpcmVmZXJlbmNlL0FQSV9VcGRhdGVUaGluZ0dyb3Vwc0ZvclRoaW5nLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1VwZGF0ZVRoaW5nR3JvdXBzRm9yVGhpbmcoKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZVRoaW5nR3JvdXBzRm9yVGhpbmcnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBVcGRhdGVzIHRoZSB0aGluZyBzaGFkb3cuXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogV3JpdGVcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvcG9saWN5LWFjdGlvbnMuaHRtbFxuICAgKi9cbiAgcHVibGljIHRvVXBkYXRlVGhpbmdTaGFkb3coKSB7XG4gICAgdGhpcy50bygnaW90OlVwZGF0ZVRoaW5nU2hhZG93Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAvKipcbiAgICogVmFsaWRhdGVzIGEgRGV2aWNlIERlZmVuZGVyIHNlY3VyaXR5IHByb2ZpbGUgYmVoYXZpb3JzIHNwZWNpZmljYXRpb24uXG4gICAqXG4gICAqIEFjY2VzcyBMZXZlbDogUmVhZFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9hcGlyZWZlcmVuY2UvQVBJX1ZhbGlkYXRlU2VjdXJpdHlQcm9maWxlQmVoYXZpb3JzLmh0bWxcbiAgICovXG4gIHB1YmxpYyB0b1ZhbGlkYXRlU2VjdXJpdHlQcm9maWxlQmVoYXZpb3JzKCkge1xuICAgIHRoaXMudG8oJ2lvdDpWYWxpZGF0ZVNlY3VyaXR5UHJvZmlsZUJlaGF2aW9ycycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFwiV3JpdGVcIjogW1xuICAgICAgXCJBY2NlcHRDZXJ0aWZpY2F0ZVRyYW5zZmVyXCIsXG4gICAgICBcIkFkZFRoaW5nVG9CaWxsaW5nR3JvdXBcIixcbiAgICAgIFwiQWRkVGhpbmdUb1RoaW5nR3JvdXBcIixcbiAgICAgIFwiQXNzb2NpYXRlVGFyZ2V0c1dpdGhKb2JcIixcbiAgICAgIFwiQXR0YWNoU2VjdXJpdHlQcm9maWxlXCIsXG4gICAgICBcIkF0dGFjaFRoaW5nUHJpbmNpcGFsXCIsXG4gICAgICBcIkNhbmNlbEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNUYXNrXCIsXG4gICAgICBcIkNhbmNlbEF1ZGl0VGFza1wiLFxuICAgICAgXCJDYW5jZWxDZXJ0aWZpY2F0ZVRyYW5zZmVyXCIsXG4gICAgICBcIkNhbmNlbEpvYlwiLFxuICAgICAgXCJDYW5jZWxKb2JFeGVjdXRpb25cIixcbiAgICAgIFwiQ2xlYXJEZWZhdWx0QXV0aG9yaXplclwiLFxuICAgICAgXCJDbG9zZVR1bm5lbFwiLFxuICAgICAgXCJDb25uZWN0XCIsXG4gICAgICBcIkNyZWF0ZUF1ZGl0U3VwcHJlc3Npb25cIixcbiAgICAgIFwiQ3JlYXRlQXV0aG9yaXplclwiLFxuICAgICAgXCJDcmVhdGVDZXJ0aWZpY2F0ZUZyb21Dc3JcIixcbiAgICAgIFwiQ3JlYXRlRGltZW5zaW9uXCIsXG4gICAgICBcIkNyZWF0ZURvbWFpbkNvbmZpZ3VyYXRpb25cIixcbiAgICAgIFwiQ3JlYXRlSm9iXCIsXG4gICAgICBcIkNyZWF0ZUtleXNBbmRDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJDcmVhdGVNaXRpZ2F0aW9uQWN0aW9uXCIsXG4gICAgICBcIkNyZWF0ZU9UQVVwZGF0ZVwiLFxuICAgICAgXCJDcmVhdGVQb2xpY3lcIixcbiAgICAgIFwiQ3JlYXRlUG9saWN5VmVyc2lvblwiLFxuICAgICAgXCJDcmVhdGVQcm92aXNpb25pbmdDbGFpbVwiLFxuICAgICAgXCJDcmVhdGVQcm92aXNpb25pbmdUZW1wbGF0ZVwiLFxuICAgICAgXCJDcmVhdGVQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb25cIixcbiAgICAgIFwiQ3JlYXRlUm9sZUFsaWFzXCIsXG4gICAgICBcIkNyZWF0ZVNjaGVkdWxlZEF1ZGl0XCIsXG4gICAgICBcIkNyZWF0ZVNlY3VyaXR5UHJvZmlsZVwiLFxuICAgICAgXCJDcmVhdGVTdHJlYW1cIixcbiAgICAgIFwiQ3JlYXRlVGhpbmdcIixcbiAgICAgIFwiQ3JlYXRlVG9waWNSdWxlXCIsXG4gICAgICBcIkRlbGV0ZUFjY291bnRBdWRpdENvbmZpZ3VyYXRpb25cIixcbiAgICAgIFwiRGVsZXRlQXVkaXRTdXBwcmVzc2lvblwiLFxuICAgICAgXCJEZWxldGVBdXRob3JpemVyXCIsXG4gICAgICBcIkRlbGV0ZUNBQ2VydGlmaWNhdGVcIixcbiAgICAgIFwiRGVsZXRlQ2VydGlmaWNhdGVcIixcbiAgICAgIFwiRGVsZXRlRGltZW5zaW9uXCIsXG4gICAgICBcIkRlbGV0ZURvbWFpbkNvbmZpZ3VyYXRpb25cIixcbiAgICAgIFwiRGVsZXRlSm9iXCIsXG4gICAgICBcIkRlbGV0ZUpvYkV4ZWN1dGlvblwiLFxuICAgICAgXCJEZWxldGVNaXRpZ2F0aW9uQWN0aW9uXCIsXG4gICAgICBcIkRlbGV0ZU9UQVVwZGF0ZVwiLFxuICAgICAgXCJEZWxldGVQb2xpY3lcIixcbiAgICAgIFwiRGVsZXRlUG9saWN5VmVyc2lvblwiLFxuICAgICAgXCJEZWxldGVQcm92aXNpb25pbmdUZW1wbGF0ZVwiLFxuICAgICAgXCJEZWxldGVQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb25cIixcbiAgICAgIFwiRGVsZXRlUmVnaXN0cmF0aW9uQ29kZVwiLFxuICAgICAgXCJEZWxldGVSb2xlQWxpYXNcIixcbiAgICAgIFwiRGVsZXRlU2NoZWR1bGVkQXVkaXRcIixcbiAgICAgIFwiRGVsZXRlU2VjdXJpdHlQcm9maWxlXCIsXG4gICAgICBcIkRlbGV0ZVN0cmVhbVwiLFxuICAgICAgXCJEZWxldGVUaGluZ1wiLFxuICAgICAgXCJEZWxldGVUaGluZ1NoYWRvd1wiLFxuICAgICAgXCJEZWxldGVUb3BpY1J1bGVcIixcbiAgICAgIFwiRGVsZXRlVjJMb2dnaW5nTGV2ZWxcIixcbiAgICAgIFwiRGVwcmVjYXRlVGhpbmdUeXBlXCIsXG4gICAgICBcIkRldGFjaFNlY3VyaXR5UHJvZmlsZVwiLFxuICAgICAgXCJEZXRhY2hUaGluZ1ByaW5jaXBhbFwiLFxuICAgICAgXCJEaXNhYmxlVG9waWNSdWxlXCIsXG4gICAgICBcIkVuYWJsZVRvcGljUnVsZVwiLFxuICAgICAgXCJPcGVuVHVubmVsXCIsXG4gICAgICBcIlB1Ymxpc2hcIixcbiAgICAgIFwiUmVjZWl2ZVwiLFxuICAgICAgXCJSZWdpc3RlckNBQ2VydGlmaWNhdGVcIixcbiAgICAgIFwiUmVnaXN0ZXJDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJSZWdpc3RlckNlcnRpZmljYXRlV2l0aG91dENBXCIsXG4gICAgICBcIlJlZ2lzdGVyVGhpbmdcIixcbiAgICAgIFwiUmVqZWN0Q2VydGlmaWNhdGVUcmFuc2ZlclwiLFxuICAgICAgXCJSZW1vdmVUaGluZ0Zyb21CaWxsaW5nR3JvdXBcIixcbiAgICAgIFwiUmVtb3ZlVGhpbmdGcm9tVGhpbmdHcm91cFwiLFxuICAgICAgXCJSZXBsYWNlVG9waWNSdWxlXCIsXG4gICAgICBcIlNldExvZ2dpbmdPcHRpb25zXCIsXG4gICAgICBcIlNldFYyTG9nZ2luZ0xldmVsXCIsXG4gICAgICBcIlNldFYyTG9nZ2luZ09wdGlvbnNcIixcbiAgICAgIFwiU3RhcnRBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFza1wiLFxuICAgICAgXCJTdGFydE5leHRQZW5kaW5nSm9iRXhlY3V0aW9uXCIsXG4gICAgICBcIlN0YXJ0T25EZW1hbmRBdWRpdFRhc2tcIixcbiAgICAgIFwiU3RhcnRUaGluZ1JlZ2lzdHJhdGlvblRhc2tcIixcbiAgICAgIFwiU3RvcFRoaW5nUmVnaXN0cmF0aW9uVGFza1wiLFxuICAgICAgXCJTdWJzY3JpYmVcIixcbiAgICAgIFwiVHJhbnNmZXJDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJVcGRhdGVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uXCIsXG4gICAgICBcIlVwZGF0ZUF1ZGl0U3VwcHJlc3Npb25cIixcbiAgICAgIFwiVXBkYXRlQXV0aG9yaXplclwiLFxuICAgICAgXCJVcGRhdGVCaWxsaW5nR3JvdXBcIixcbiAgICAgIFwiVXBkYXRlQ0FDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJVcGRhdGVDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJVcGRhdGVEaW1lbnNpb25cIixcbiAgICAgIFwiVXBkYXRlRG9tYWluQ29uZmlndXJhdGlvblwiLFxuICAgICAgXCJVcGRhdGVEeW5hbWljVGhpbmdHcm91cFwiLFxuICAgICAgXCJVcGRhdGVFdmVudENvbmZpZ3VyYXRpb25zXCIsXG4gICAgICBcIlVwZGF0ZUluZGV4aW5nQ29uZmlndXJhdGlvblwiLFxuICAgICAgXCJVcGRhdGVKb2JcIixcbiAgICAgIFwiVXBkYXRlSm9iRXhlY3V0aW9uXCIsXG4gICAgICBcIlVwZGF0ZU1pdGlnYXRpb25BY3Rpb25cIixcbiAgICAgIFwiVXBkYXRlUHJvdmlzaW9uaW5nVGVtcGxhdGVcIixcbiAgICAgIFwiVXBkYXRlUm9sZUFsaWFzXCIsXG4gICAgICBcIlVwZGF0ZVNjaGVkdWxlZEF1ZGl0XCIsXG4gICAgICBcIlVwZGF0ZVNlY3VyaXR5UHJvZmlsZVwiLFxuICAgICAgXCJVcGRhdGVTdHJlYW1cIixcbiAgICAgIFwiVXBkYXRlVGhpbmdcIixcbiAgICAgIFwiVXBkYXRlVGhpbmdHcm91cFwiLFxuICAgICAgXCJVcGRhdGVUaGluZ0dyb3Vwc0ZvclRoaW5nXCIsXG4gICAgICBcIlVwZGF0ZVRoaW5nU2hhZG93XCJcbiAgICBdLFxuICAgIFwiUGVybWlzc2lvbnMgbWFuYWdlbWVudFwiOiBbXG4gICAgICBcIkF0dGFjaFBvbGljeVwiLFxuICAgICAgXCJBdHRhY2hQcmluY2lwYWxQb2xpY3lcIixcbiAgICAgIFwiRGV0YWNoUG9saWN5XCIsXG4gICAgICBcIkRldGFjaFByaW5jaXBhbFBvbGljeVwiLFxuICAgICAgXCJTZXREZWZhdWx0QXV0aG9yaXplclwiLFxuICAgICAgXCJTZXREZWZhdWx0UG9saWN5VmVyc2lvblwiXG4gICAgXSxcbiAgICBcIlRhZ2dpbmdcIjogW1xuICAgICAgXCJDcmVhdGVCaWxsaW5nR3JvdXBcIixcbiAgICAgIFwiQ3JlYXRlRHluYW1pY1RoaW5nR3JvdXBcIixcbiAgICAgIFwiQ3JlYXRlVGhpbmdHcm91cFwiLFxuICAgICAgXCJDcmVhdGVUaGluZ1R5cGVcIixcbiAgICAgIFwiRGVsZXRlQmlsbGluZ0dyb3VwXCIsXG4gICAgICBcIkRlbGV0ZUR5bmFtaWNUaGluZ0dyb3VwXCIsXG4gICAgICBcIkRlbGV0ZVRoaW5nR3JvdXBcIixcbiAgICAgIFwiRGVsZXRlVGhpbmdUeXBlXCIsXG4gICAgICBcIlRhZ1Jlc291cmNlXCIsXG4gICAgICBcIlVudGFnUmVzb3VyY2VcIlxuICAgIF0sXG4gICAgXCJSZWFkXCI6IFtcbiAgICAgIFwiRGVzY3JpYmVBY2NvdW50QXVkaXRDb25maWd1cmF0aW9uXCIsXG4gICAgICBcIkRlc2NyaWJlQXVkaXRGaW5kaW5nXCIsXG4gICAgICBcIkRlc2NyaWJlQXVkaXRNaXRpZ2F0aW9uQWN0aW9uc1Rhc2tcIixcbiAgICAgIFwiRGVzY3JpYmVBdWRpdFN1cHByZXNzaW9uXCIsXG4gICAgICBcIkRlc2NyaWJlQXVkaXRUYXNrXCIsXG4gICAgICBcIkRlc2NyaWJlQXV0aG9yaXplclwiLFxuICAgICAgXCJEZXNjcmliZUJpbGxpbmdHcm91cFwiLFxuICAgICAgXCJEZXNjcmliZUNBQ2VydGlmaWNhdGVcIixcbiAgICAgIFwiRGVzY3JpYmVDZXJ0aWZpY2F0ZVwiLFxuICAgICAgXCJEZXNjcmliZURlZmF1bHRBdXRob3JpemVyXCIsXG4gICAgICBcIkRlc2NyaWJlRGltZW5zaW9uXCIsXG4gICAgICBcIkRlc2NyaWJlRG9tYWluQ29uZmlndXJhdGlvblwiLFxuICAgICAgXCJEZXNjcmliZUVuZHBvaW50XCIsXG4gICAgICBcIkRlc2NyaWJlRXZlbnRDb25maWd1cmF0aW9uc1wiLFxuICAgICAgXCJEZXNjcmliZUluZGV4XCIsXG4gICAgICBcIkRlc2NyaWJlSm9iXCIsXG4gICAgICBcIkRlc2NyaWJlSm9iRXhlY3V0aW9uXCIsXG4gICAgICBcIkRlc2NyaWJlTWl0aWdhdGlvbkFjdGlvblwiLFxuICAgICAgXCJEZXNjcmliZVByb3Zpc2lvbmluZ1RlbXBsYXRlXCIsXG4gICAgICBcIkRlc2NyaWJlUHJvdmlzaW9uaW5nVGVtcGxhdGVWZXJzaW9uXCIsXG4gICAgICBcIkRlc2NyaWJlUm9sZUFsaWFzXCIsXG4gICAgICBcIkRlc2NyaWJlU2NoZWR1bGVkQXVkaXRcIixcbiAgICAgIFwiRGVzY3JpYmVTZWN1cml0eVByb2ZpbGVcIixcbiAgICAgIFwiRGVzY3JpYmVTdHJlYW1cIixcbiAgICAgIFwiRGVzY3JpYmVUaGluZ1wiLFxuICAgICAgXCJEZXNjcmliZVRoaW5nR3JvdXBcIixcbiAgICAgIFwiRGVzY3JpYmVUaGluZ1JlZ2lzdHJhdGlvblRhc2tcIixcbiAgICAgIFwiRGVzY3JpYmVUaGluZ1R5cGVcIixcbiAgICAgIFwiRGVzY3JpYmVUdW5uZWxcIixcbiAgICAgIFwiR2V0Q2FyZGluYWxpdHlcIixcbiAgICAgIFwiR2V0RWZmZWN0aXZlUG9saWNpZXNcIixcbiAgICAgIFwiR2V0SW5kZXhpbmdDb25maWd1cmF0aW9uXCIsXG4gICAgICBcIkdldEpvYkRvY3VtZW50XCIsXG4gICAgICBcIkdldExvZ2dpbmdPcHRpb25zXCIsXG4gICAgICBcIkdldE9UQVVwZGF0ZVwiLFxuICAgICAgXCJHZXRQZW5kaW5nSm9iRXhlY3V0aW9uc1wiLFxuICAgICAgXCJHZXRQZXJjZW50aWxlc1wiLFxuICAgICAgXCJHZXRQb2xpY3lcIixcbiAgICAgIFwiR2V0UG9saWN5VmVyc2lvblwiLFxuICAgICAgXCJHZXRSZWdpc3RyYXRpb25Db2RlXCIsXG4gICAgICBcIkdldFN0YXRpc3RpY3NcIixcbiAgICAgIFwiR2V0VGhpbmdTaGFkb3dcIixcbiAgICAgIFwiR2V0VG9waWNSdWxlXCIsXG4gICAgICBcIkdldFYyTG9nZ2luZ09wdGlvbnNcIixcbiAgICAgIFwiU2VhcmNoSW5kZXhcIixcbiAgICAgIFwiVGVzdEF1dGhvcml6YXRpb25cIixcbiAgICAgIFwiVGVzdEludm9rZUF1dGhvcml6ZXJcIixcbiAgICAgIFwiVmFsaWRhdGVTZWN1cml0eVByb2ZpbGVCZWhhdmlvcnNcIlxuICAgIF0sXG4gICAgXCJMaXN0XCI6IFtcbiAgICAgIFwiTGlzdEFjdGl2ZVZpb2xhdGlvbnNcIixcbiAgICAgIFwiTGlzdEF0dGFjaGVkUG9saWNpZXNcIixcbiAgICAgIFwiTGlzdEF1ZGl0RmluZGluZ3NcIixcbiAgICAgIFwiTGlzdEF1ZGl0TWl0aWdhdGlvbkFjdGlvbnNFeGVjdXRpb25zXCIsXG4gICAgICBcIkxpc3RBdWRpdE1pdGlnYXRpb25BY3Rpb25zVGFza3NcIixcbiAgICAgIFwiTGlzdEF1ZGl0U3VwcHJlc3Npb25zXCIsXG4gICAgICBcIkxpc3RBdWRpdFRhc2tzXCIsXG4gICAgICBcIkxpc3RBdXRob3JpemVyc1wiLFxuICAgICAgXCJMaXN0QmlsbGluZ0dyb3Vwc1wiLFxuICAgICAgXCJMaXN0Q0FDZXJ0aWZpY2F0ZXNcIixcbiAgICAgIFwiTGlzdENlcnRpZmljYXRlc1wiLFxuICAgICAgXCJMaXN0Q2VydGlmaWNhdGVzQnlDQVwiLFxuICAgICAgXCJMaXN0RGltZW5zaW9uc1wiLFxuICAgICAgXCJMaXN0RG9tYWluQ29uZmlndXJhdGlvbnNcIixcbiAgICAgIFwiTGlzdEluZGljZXNcIixcbiAgICAgIFwiTGlzdEpvYkV4ZWN1dGlvbnNGb3JKb2JcIixcbiAgICAgIFwiTGlzdEpvYkV4ZWN1dGlvbnNGb3JUaGluZ1wiLFxuICAgICAgXCJMaXN0Sm9ic1wiLFxuICAgICAgXCJMaXN0TWl0aWdhdGlvbkFjdGlvbnNcIixcbiAgICAgIFwiTGlzdE5hbWVkU2hhZG93c0ZvclRoaW5nXCIsXG4gICAgICBcIkxpc3RPVEFVcGRhdGVzXCIsXG4gICAgICBcIkxpc3RPdXRnb2luZ0NlcnRpZmljYXRlc1wiLFxuICAgICAgXCJMaXN0UG9saWNpZXNcIixcbiAgICAgIFwiTGlzdFBvbGljeVByaW5jaXBhbHNcIixcbiAgICAgIFwiTGlzdFBvbGljeVZlcnNpb25zXCIsXG4gICAgICBcIkxpc3RQcmluY2lwYWxQb2xpY2llc1wiLFxuICAgICAgXCJMaXN0UHJpbmNpcGFsVGhpbmdzXCIsXG4gICAgICBcIkxpc3RQcm92aXNpb25pbmdUZW1wbGF0ZVZlcnNpb25zXCIsXG4gICAgICBcIkxpc3RQcm92aXNpb25pbmdUZW1wbGF0ZXNcIixcbiAgICAgIFwiTGlzdFJvbGVBbGlhc2VzXCIsXG4gICAgICBcIkxpc3RTY2hlZHVsZWRBdWRpdHNcIixcbiAgICAgIFwiTGlzdFNlY3VyaXR5UHJvZmlsZXNcIixcbiAgICAgIFwiTGlzdFNlY3VyaXR5UHJvZmlsZXNGb3JUYXJnZXRcIixcbiAgICAgIFwiTGlzdFN0cmVhbXNcIixcbiAgICAgIFwiTGlzdFRhZ3NGb3JSZXNvdXJjZVwiLFxuICAgICAgXCJMaXN0VGFyZ2V0c0ZvclBvbGljeVwiLFxuICAgICAgXCJMaXN0VGFyZ2V0c0ZvclNlY3VyaXR5UHJvZmlsZVwiLFxuICAgICAgXCJMaXN0VGhpbmdHcm91cHNcIixcbiAgICAgIFwiTGlzdFRoaW5nR3JvdXBzRm9yVGhpbmdcIixcbiAgICAgIFwiTGlzdFRoaW5nUHJpbmNpcGFsc1wiLFxuICAgICAgXCJMaXN0VGhpbmdSZWdpc3RyYXRpb25UYXNrUmVwb3J0c1wiLFxuICAgICAgXCJMaXN0VGhpbmdSZWdpc3RyYXRpb25UYXNrc1wiLFxuICAgICAgXCJMaXN0VGhpbmdUeXBlc1wiLFxuICAgICAgXCJMaXN0VGhpbmdzXCIsXG4gICAgICBcIkxpc3RUaGluZ3NJbkJpbGxpbmdHcm91cFwiLFxuICAgICAgXCJMaXN0VGhpbmdzSW5UaGluZ0dyb3VwXCIsXG4gICAgICBcIkxpc3RUb3BpY1J1bGVzXCIsXG4gICAgICBcIkxpc3RUdW5uZWxzXCIsXG4gICAgICBcIkxpc3RWMkxvZ2dpbmdMZXZlbHNcIixcbiAgICAgIFwiTGlzdFZpb2xhdGlvbkV2ZW50c1wiXG4gICAgXVxuICB9O1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBjbGllbnQgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9pb3QtbWVzc2FnZS1icm9rZXIuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gY2xpZW50SWQgLSBJZGVudGlmaWVyIGZvciB0aGUgY2xpZW50SWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqL1xuICBwdWJsaWMgb25DbGllbnQoY2xpZW50SWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OmNsaWVudC8ke0NsaWVudElkfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7Q2xpZW50SWR9JywgY2xpZW50SWQpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGluZGV4IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90LWluZGV4aW5nLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGluZGV4TmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBpbmRleE5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqL1xuICBwdWJsaWMgb25JbmRleChpbmRleE5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OmluZGV4LyR7SW5kZXhOYW1lfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7SW5kZXhOYW1lfScsIGluZGV4TmFtZSk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7QWNjb3VudH0nLCBhY2NvdW50IHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVnaW9ufScsIHJlZ2lvbiB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1BhcnRpdGlvbn0nLCBwYXJ0aXRpb24gfHwgJ2F3cycpO1xuICAgIHJldHVybiB0aGlzLm9uKGFybik7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgam9iIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90LWpvYnMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gam9iSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgam9iSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uSm9iKGpvYklkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgdmFyIGFybiA9ICdhcm46JHtQYXJ0aXRpb259OmlvdDoke1JlZ2lvbn06JHtBY2NvdW50fTpqb2IvJHtKb2JJZH0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0pvYklkfScsIGpvYklkKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSB0dW5uZWwgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9pb3QtdHVubmVscy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSB0dW5uZWxJZCAtIElkZW50aWZpZXIgZm9yIHRoZSB0dW5uZWxJZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25UdW5uZWwodHVubmVsSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnR1bm5lbC8ke1R1bm5lbElkfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7VHVubmVsSWR9JywgdHVubmVsSWQpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHRoaW5nIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdGhpbmctcmVnaXN0cnkuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdGhpbmdOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRoaW5nTmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICovXG4gIHB1YmxpYyBvblRoaW5nKHRoaW5nTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06dGhpbmcvJHtUaGluZ05hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtUaGluZ05hbWV9JywgdGhpbmdOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSB0aGluZ2dyb3VwIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvdGhpbmctZ3JvdXBzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHRoaW5nR3JvdXBOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRoaW5nR3JvdXBOYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblRoaW5nZ3JvdXAodGhpbmdHcm91cE5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnRoaW5nZ3JvdXAvJHtUaGluZ0dyb3VwTmFtZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1RoaW5nR3JvdXBOYW1lfScsIHRoaW5nR3JvdXBOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBiaWxsaW5nZ3JvdXAgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9iaWxsaW5nLWdyb3Vwcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBiaWxsaW5nR3JvdXBOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIGJpbGxpbmdHcm91cE5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uQmlsbGluZ2dyb3VwKGJpbGxpbmdHcm91cE5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OmJpbGxpbmdncm91cC8ke0JpbGxpbmdHcm91cE5hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtCaWxsaW5nR3JvdXBOYW1lfScsIGJpbGxpbmdHcm91cE5hbWUpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGR5bmFtaWN0aGluZ2dyb3VwIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZHluYW1pYy10aGluZy1ncm91cHMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdGhpbmdHcm91cE5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgdGhpbmdHcm91cE5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRHluYW1pY3RoaW5nZ3JvdXAodGhpbmdHcm91cE5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnRoaW5nZ3JvdXAvJHtUaGluZ0dyb3VwTmFtZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1RoaW5nR3JvdXBOYW1lfScsIHRoaW5nR3JvdXBOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSB0aGluZ3R5cGUgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS90aGluZy10eXBlcy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSB0aGluZ1R5cGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHRoaW5nVHlwZU5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uVGhpbmd0eXBlKHRoaW5nVHlwZU5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnRoaW5ndHlwZS8ke1RoaW5nVHlwZU5hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtUaGluZ1R5cGVOYW1lfScsIHRoaW5nVHlwZU5hbWUpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIHRvcGljIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90LW1lc3NhZ2UtYnJva2VyLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHRvcGljTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSB0b3BpY05hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqL1xuICBwdWJsaWMgb25Ub3BpYyh0b3BpY05hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnRvcGljLyR7VG9waWNOYW1lfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7VG9waWNOYW1lfScsIHRvcGljTmFtZSk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7QWNjb3VudH0nLCBhY2NvdW50IHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVnaW9ufScsIHJlZ2lvbiB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1BhcnRpdGlvbn0nLCBwYXJ0aXRpb24gfHwgJ2F3cycpO1xuICAgIHJldHVybiB0aGlzLm9uKGFybik7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgdG9waWNmaWx0ZXIgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS90b3BpY3MuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gdG9waWNGaWx0ZXIgLSBJZGVudGlmaWVyIGZvciB0aGUgdG9waWNGaWx0ZXIuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqL1xuICBwdWJsaWMgb25Ub3BpY2ZpbHRlcih0b3BpY0ZpbHRlcjogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06dG9waWNmaWx0ZXIvJHtUb3BpY0ZpbHRlcn0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1RvcGljRmlsdGVyfScsIHRvcGljRmlsdGVyKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSByb2xlYWxpYXMgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9hdXRob3JpemluZy1kaXJlY3QtYXdzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJvbGVBbGlhcyAtIElkZW50aWZpZXIgZm9yIHRoZSByb2xlQWxpYXMuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uUm9sZWFsaWFzKHJvbGVBbGlhczogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06cm9sZWFsaWFzLyR7Um9sZUFsaWFzfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7Um9sZUFsaWFzfScsIHJvbGVBbGlhcyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7QWNjb3VudH0nLCBhY2NvdW50IHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVnaW9ufScsIHJlZ2lvbiB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1BhcnRpdGlvbn0nLCBwYXJ0aXRpb24gfHwgJ2F3cycpO1xuICAgIHJldHVybiB0aGlzLm9uKGFybik7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgYXV0aG9yaXplciB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2N1c3RvbS1hdXRob3JpemVyLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGF1dGhvcml6ZXJOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIGF1dGhvcml6ZXJOYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkF1dGhvcml6ZXIoYXV0aG9yaXplck5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OmF1dGhvcml6ZXIvJHtBdXRob3JpemVyTmFtZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0F1dGhvcml6ZXJOYW1lfScsIGF1dGhvcml6ZXJOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBwb2xpY3kgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9pb3QtcG9saWNpZXMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gcG9saWN5TmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBwb2xpY3lOYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblBvbGljeShwb2xpY3lOYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgdmFyIGFybiA9ICdhcm46JHtQYXJ0aXRpb259OmlvdDoke1JlZ2lvbn06JHtBY2NvdW50fTpwb2xpY3kvJHtQb2xpY3lOYW1lfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UG9saWN5TmFtZX0nLCBwb2xpY3lOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBjZXJ0IHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUveDUwOS1jZXJ0cy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBjZXJ0aWZpY2F0ZSAtIElkZW50aWZpZXIgZm9yIHRoZSBjZXJ0aWZpY2F0ZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICovXG4gIHB1YmxpYyBvbkNlcnQoY2VydGlmaWNhdGU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OmNlcnQvJHtDZXJ0aWZpY2F0ZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0NlcnRpZmljYXRlfScsIGNlcnRpZmljYXRlKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBjYWNlcnQgdG8gdGhlIHN0YXRlbWVudFxuICAgKlxuICAgKiBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS94NTA5LWNlcnRzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIGNBQ2VydGlmaWNhdGUgLSBJZGVudGlmaWVyIGZvciB0aGUgY0FDZXJ0aWZpY2F0ZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25DYWNlcnQoY0FDZXJ0aWZpY2F0ZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06Y2FjZXJ0LyR7Q0FDZXJ0aWZpY2F0ZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0NBQ2VydGlmaWNhdGV9JywgY0FDZXJ0aWZpY2F0ZSk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7QWNjb3VudH0nLCBhY2NvdW50IHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVnaW9ufScsIHJlZ2lvbiB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1BhcnRpdGlvbn0nLCBwYXJ0aXRpb24gfHwgJ2F3cycpO1xuICAgIHJldHVybiB0aGlzLm9uKGFybik7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgc3RyZWFtIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2ZyZWVydG9zL2xhdGVzdC91c2VyZ3VpZGUvZnJlZXJ0b3Mtb3RhLWRldi5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBzdHJlYW1JZCAtIElkZW50aWZpZXIgZm9yIHRoZSBzdHJlYW1JZC5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25TdHJlYW0oc3RyZWFtSWQ6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnN0cmVhbS8ke1N0cmVhbUlkfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7U3RyZWFtSWR9Jywgc3RyZWFtSWQpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIG90YXVwZGF0ZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9mcmVlcnRvcy9sYXRlc3QvdXNlcmd1aWRlL2ZyZWVydG9zLW90YS1kZXYuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gb3RhVXBkYXRlSWQgLSBJZGVudGlmaWVyIGZvciB0aGUgb3RhVXBkYXRlSWQuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uT3RhdXBkYXRlKG90YVVwZGF0ZUlkOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgdmFyIGFybiA9ICdhcm46JHtQYXJ0aXRpb259OmlvdDoke1JlZ2lvbn06JHtBY2NvdW50fTpvdGF1cGRhdGUvJHtPdGFVcGRhdGVJZH0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke090YVVwZGF0ZUlkfScsIG90YVVwZGF0ZUlkKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBzY2hlZHVsZWRhdWRpdCB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RldmljZS1kZWZlbmRlci1hdWRpdC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBzY2hlZHVsZU5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgc2NoZWR1bGVOYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblNjaGVkdWxlZGF1ZGl0KHNjaGVkdWxlTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06c2NoZWR1bGVkYXVkaXQvJHtTY2hlZHVsZU5hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtTY2hlZHVsZU5hbWV9Jywgc2NoZWR1bGVOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBtaXRpZ2F0aW9uYWN0aW9uIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGV2aWNlLWRlZmVuZGVyLW1pdGlnYXRpb24tYWN0aW9ucy5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBtaXRpZ2F0aW9uQWN0aW9uTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBtaXRpZ2F0aW9uQWN0aW9uTmFtZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25NaXRpZ2F0aW9uYWN0aW9uKG1pdGlnYXRpb25BY3Rpb25OYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgdmFyIGFybiA9ICdhcm46JHtQYXJ0aXRpb259OmlvdDoke1JlZ2lvbn06JHtBY2NvdW50fTptaXRpZ2F0aW9uYWN0aW9uLyR7TWl0aWdhdGlvbkFjdGlvbk5hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtNaXRpZ2F0aW9uQWN0aW9uTmFtZX0nLCBtaXRpZ2F0aW9uQWN0aW9uTmFtZSk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7QWNjb3VudH0nLCBhY2NvdW50IHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UmVnaW9ufScsIHJlZ2lvbiB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1BhcnRpdGlvbn0nLCBwYXJ0aXRpb24gfHwgJ2F3cycpO1xuICAgIHJldHVybiB0aGlzLm9uKGFybik7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBhIHJlc291cmNlIG9mIHR5cGUgc2VjdXJpdHlwcm9maWxlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZGV2aWNlLWRlZmVuZGVyLWRldGVjdC5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBzZWN1cml0eVByb2ZpbGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHNlY3VyaXR5UHJvZmlsZU5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uU2VjdXJpdHlwcm9maWxlKHNlY3VyaXR5UHJvZmlsZU5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnNlY3VyaXR5cHJvZmlsZS8ke1NlY3VyaXR5UHJvZmlsZU5hbWV9JztcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtTZWN1cml0eVByb2ZpbGVOYW1lfScsIHNlY3VyaXR5UHJvZmlsZU5hbWUpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZHMgYSByZXNvdXJjZSBvZiB0eXBlIGRpbWVuc2lvbiB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL2RldmljZS1kZWZlbmRlci1kZXRlY3QuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gZGltZW5zaW9uTmFtZSAtIElkZW50aWZpZXIgZm9yIHRoZSBkaW1lbnNpb25OYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvbkRpbWVuc2lvbihkaW1lbnNpb25OYW1lOiBzdHJpbmcsIGFjY291bnQ/OiBzdHJpbmcsIHJlZ2lvbj86IHN0cmluZywgcGFydGl0aW9uPzogc3RyaW5nKSB7XG4gICAgdmFyIGFybiA9ICdhcm46JHtQYXJ0aXRpb259OmlvdDoke1JlZ2lvbn06JHtBY2NvdW50fTpkaW1lbnNpb24vJHtEaW1lbnNpb25OYW1lfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7RGltZW5zaW9uTmFtZX0nLCBkaW1lbnNpb25OYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBydWxlIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvaW90LXJ1bGVzLmh0bWxcbiAgICpcbiAgICogQHBhcmFtIHJ1bGVOYW1lIC0gSWRlbnRpZmllciBmb3IgdGhlIHJ1bGVOYW1lLlxuICAgKiBAcGFyYW0gYWNjb3VudCAtIEFjY291bnQgb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCBhY2NvdW50cy5cbiAgICogQHBhcmFtIHJlZ2lvbiAtIFJlZ2lvbiBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIHJlZ2lvbnMuXG4gICAqIEBwYXJhbSBwYXJ0aXRpb24gLSBQYXJ0aXRpb24gb2YgdGhlIEFXUyBhY2NvdW50IFthd3MsIGF3cy1jbiwgYXdzLXVzLWdvdl07IGRlZmF1bHRzIHRvIGBhd3NgLlxuICAgKlxuICAgKiBQb3NzaWJsZSBjb25kaXRpb25zOlxuICAgKiAtIC5pZkF3c1Jlc291cmNlVGFnKClcbiAgICovXG4gIHB1YmxpYyBvblJ1bGUocnVsZU5hbWU6IHN0cmluZywgYWNjb3VudD86IHN0cmluZywgcmVnaW9uPzogc3RyaW5nLCBwYXJ0aXRpb24/OiBzdHJpbmcpIHtcbiAgICB2YXIgYXJuID0gJ2Fybjoke1BhcnRpdGlvbn06aW90OiR7UmVnaW9ufToke0FjY291bnR9OnJ1bGUvJHtSdWxlTmFtZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1J1bGVOYW1lfScsIHJ1bGVOYW1lKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBwcm92aXNpb25pbmd0ZW1wbGF0ZSB0byB0aGUgc3RhdGVtZW50XG4gICAqXG4gICAqIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9pb3QvbGF0ZXN0L2RldmVsb3Blcmd1aWRlL3Byb3Zpc2lvbi10ZW1wbGF0ZS5odG1sXG4gICAqXG4gICAqIEBwYXJhbSBwcm92aXNpb25pbmdUZW1wbGF0ZSAtIElkZW50aWZpZXIgZm9yIHRoZSBwcm92aXNpb25pbmdUZW1wbGF0ZS5cbiAgICogQHBhcmFtIGFjY291bnQgLSBBY2NvdW50IG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgYWNjb3VudHMuXG4gICAqIEBwYXJhbSByZWdpb24gLSBSZWdpb24gb2YgdGhlIHJlc291cmNlOyBkZWZhdWx0cyB0byBlbXB0eSBzdHJpbmc6IGFsbCByZWdpb25zLlxuICAgKiBAcGFyYW0gcGFydGl0aW9uIC0gUGFydGl0aW9uIG9mIHRoZSBBV1MgYWNjb3VudCBbYXdzLCBhd3MtY24sIGF3cy11cy1nb3ZdOyBkZWZhdWx0cyB0byBgYXdzYC5cbiAgICpcbiAgICogUG9zc2libGUgY29uZGl0aW9uczpcbiAgICogLSAuaWZBd3NSZXNvdXJjZVRhZygpXG4gICAqL1xuICBwdWJsaWMgb25Qcm92aXNpb25pbmd0ZW1wbGF0ZShwcm92aXNpb25pbmdUZW1wbGF0ZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06cHJvdmlzaW9uaW5ndGVtcGxhdGUvJHtQcm92aXNpb25pbmdUZW1wbGF0ZX0nO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1Byb3Zpc2lvbmluZ1RlbXBsYXRlfScsIHByb3Zpc2lvbmluZ1RlbXBsYXRlKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtBY2NvdW50fScsIGFjY291bnQgfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtSZWdpb259JywgcmVnaW9uIHx8ICcqJyk7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7UGFydGl0aW9ufScsIHBhcnRpdGlvbiB8fCAnYXdzJyk7XG4gICAgcmV0dXJuIHRoaXMub24oYXJuKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBZGRzIGEgcmVzb3VyY2Ugb2YgdHlwZSBkb21haW5jb25maWd1cmF0aW9uIHRvIHRoZSBzdGF0ZW1lbnRcbiAgICpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2lvdC9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvZG9tYWluLWNvbmZpZ3VyYXRpb24uaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gZG9tYWluQ29uZmlndXJhdGlvbk5hbWUgLSBJZGVudGlmaWVyIGZvciB0aGUgZG9tYWluQ29uZmlndXJhdGlvbk5hbWUuXG4gICAqIEBwYXJhbSBhY2NvdW50IC0gQWNjb3VudCBvZiB0aGUgcmVzb3VyY2U7IGRlZmF1bHRzIHRvIGVtcHR5IHN0cmluZzogYWxsIGFjY291bnRzLlxuICAgKiBAcGFyYW0gcmVnaW9uIC0gUmVnaW9uIG9mIHRoZSByZXNvdXJjZTsgZGVmYXVsdHMgdG8gZW1wdHkgc3RyaW5nOiBhbGwgcmVnaW9ucy5cbiAgICogQHBhcmFtIHBhcnRpdGlvbiAtIFBhcnRpdGlvbiBvZiB0aGUgQVdTIGFjY291bnQgW2F3cywgYXdzLWNuLCBhd3MtdXMtZ292XTsgZGVmYXVsdHMgdG8gYGF3c2AuXG4gICAqXG4gICAqIFBvc3NpYmxlIGNvbmRpdGlvbnM6XG4gICAqIC0gLmlmQXdzUmVzb3VyY2VUYWcoKVxuICAgKi9cbiAgcHVibGljIG9uRG9tYWluY29uZmlndXJhdGlvbihkb21haW5Db25maWd1cmF0aW9uTmFtZTogc3RyaW5nLCBhY2NvdW50Pzogc3RyaW5nLCByZWdpb24/OiBzdHJpbmcsIHBhcnRpdGlvbj86IHN0cmluZykge1xuICAgIHZhciBhcm4gPSAnYXJuOiR7UGFydGl0aW9ufTppb3Q6JHtSZWdpb259OiR7QWNjb3VudH06ZG9tYWluY29uZmlndXJhdGlvbi8ke0RvbWFpbkNvbmZpZ3VyYXRpb25OYW1lfSc7XG4gICAgYXJuID0gYXJuLnJlcGxhY2UoJyR7RG9tYWluQ29uZmlndXJhdGlvbk5hbWV9JywgZG9tYWluQ29uZmlndXJhdGlvbk5hbWUpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke0FjY291bnR9JywgYWNjb3VudCB8fCAnKicpO1xuICAgIGFybiA9IGFybi5yZXBsYWNlKCcke1JlZ2lvbn0nLCByZWdpb24gfHwgJyonKTtcbiAgICBhcm4gPSBhcm4ucmVwbGFjZSgnJHtQYXJ0aXRpb259JywgcGFydGl0aW9uIHx8ICdhd3MnKTtcbiAgICByZXR1cm4gdGhpcy5vbihhcm4pO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBmbGFnIGluZGljYXRpbmcgd2hldGhlciBvciBub3QgdG8gYWxzbyBkZWxldGUgYW4gSW9UIFR1bm5lbCBpbW1lZGlhdGVseVxuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvQ2xvc2VUdW5uZWwoKVxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgYHRydWVgIG9yIGBmYWxzZWAuICoqRGVmYXVsdDoqKiBgdHJ1ZWBcbiAgICovXG4gIHB1YmxpYyBpZkRlbGV0ZSh2YWx1ZT86IGJvb2xlYW4pIHtcbiAgICByZXR1cm4gdGhpcy5pZihgaW90OkRlbGV0ZWAsICh0eXBlb2YgdmFsdWUgIT09ICd1bmRlZmluZWQnID8gdmFsdWUgOiB0cnVlKSwgJ0Jvb2wnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBGaWx0ZXJzIGFjdGlvbnMgYmFzZWQgb24gdGhlIGRvbWFpbiBuYW1lIG9mIGFuIElvVCBEb21haW5Db25maWd1cmF0aW9uXG4gICAqXG4gICAqIEFwcGxpZXMgdG8gYWN0aW9uczpcbiAgICogLSAudG9DcmVhdGVEb21haW5Db25maWd1cmF0aW9uKClcbiAgICpcbiAgICogQHBhcmFtIHZhbHVlIFRoZSB2YWx1ZShzKSB0byBjaGVja1xuICAgKiBAcGFyYW0gb3BlcmF0b3IgV29ya3Mgd2l0aCBbc3RyaW5nIG9wZXJhdG9yc10oaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0lBTS9sYXRlc3QvVXNlckd1aWRlL3JlZmVyZW5jZV9wb2xpY2llc19lbGVtZW50c19jb25kaXRpb25fb3BlcmF0b3JzLmh0bWwjQ29uZGl0aW9uc19TdHJpbmcpLiAqKkRlZmF1bHQ6KiogYFN0cmluZ0xpa2VgXG4gICAqL1xuICBwdWJsaWMgaWZEb21haW5OYW1lKHZhbHVlOiBzdHJpbmcgfCBzdHJpbmdbXSwgb3BlcmF0b3I/OiBPcGVyYXRvciB8IHN0cmluZykge1xuICAgIHJldHVybiB0aGlzLmlmKGBpb3Q6RG9tYWluTmFtZWAsIHZhbHVlLCBvcGVyYXRvciB8fCAnU3RyaW5nTGlrZScpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBsaXN0IG9mIGFsbCBJb1QgVGhpbmcgR3JvdXAgQVJOcyB0aGF0IHRoZSBkZXN0aW5hdGlvbiBJb1QgVGhpbmcgYmVsb25ncyB0byBmb3IgYW4gSW9UIFR1bm5lbFxuICAgKlxuICAgKiBBcHBsaWVzIHRvIGFjdGlvbnM6XG4gICAqIC0gLnRvT3BlblR1bm5lbCgpXG4gICAqXG4gICAqIEBwYXJhbSB2YWx1ZSBUaGUgdmFsdWUocykgdG8gY2hlY2tcbiAgICogQHBhcmFtIG9wZXJhdG9yIFdvcmtzIHdpdGggW3N0cmluZyBvcGVyYXRvcnNdKGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9JQU0vbGF0ZXN0L1VzZXJHdWlkZS9yZWZlcmVuY2VfcG9saWNpZXNfZWxlbWVudHNfY29uZGl0aW9uX29wZXJhdG9ycy5odG1sI0NvbmRpdGlvbnNfU3RyaW5nKS4gKipEZWZhdWx0OioqIGBTdHJpbmdMaWtlYFxuICAgKi9cbiAgcHVibGljIGlmVGhpbmdHcm91cEFybih2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgaW90OlRoaW5nR3JvdXBBcm5gLCB2YWx1ZSwgb3BlcmF0b3IgfHwgJ1N0cmluZ0xpa2UnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbGlzdCBvZiBhbGwgZGVzdGluYXRpb24gc2VydmljZXMgZm9yIGFuIElvVCBUdW5uZWxcbiAgICpcbiAgICogQXBwbGllcyB0byBhY3Rpb25zOlxuICAgKiAtIC50b09wZW5UdW5uZWwoKVxuICAgKlxuICAgKiBAcGFyYW0gdmFsdWUgVGhlIHZhbHVlKHMpIHRvIGNoZWNrXG4gICAqIEBwYXJhbSBvcGVyYXRvciBXb3JrcyB3aXRoIFtzdHJpbmcgb3BlcmF0b3JzXShodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vSUFNL2xhdGVzdC9Vc2VyR3VpZGUvcmVmZXJlbmNlX3BvbGljaWVzX2VsZW1lbnRzX2NvbmRpdGlvbl9vcGVyYXRvcnMuaHRtbCNDb25kaXRpb25zX1N0cmluZykuICoqRGVmYXVsdDoqKiBgU3RyaW5nTGlrZWBcbiAgICovXG4gIHB1YmxpYyBpZlR1bm5lbERlc3RpbmF0aW9uU2VydmljZSh2YWx1ZTogc3RyaW5nIHwgc3RyaW5nW10sIG9wZXJhdG9yPzogT3BlcmF0b3IgfCBzdHJpbmcpIHtcbiAgICByZXR1cm4gdGhpcy5pZihgaW90OlR1bm5lbERlc3RpbmF0aW9uU2VydmljZWAsIHZhbHVlLCBvcGVyYXRvciB8fCAnU3RyaW5nTGlrZScpO1xuICB9XG59XG4iXX0=