import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class AwsMarketplaceManagement extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    touploadFiles(): this;
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewMarketing(): this;
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewReports(): this;
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewSettings(): this;
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewSupport(): this;
    protected accessLevelList: AccessLevelList;
}
