"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceManagement = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceManagement extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-management';
        this.accessLevelList = {
            "Write": [
                "uploadFiles"
            ],
            "List": [
                "viewMarketing",
                "viewReports",
                "viewSettings",
                "viewSupport"
            ]
        };
    }
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    touploadFiles() {
        this.to('aws-marketplace-management:uploadFiles');
        return this;
    }
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewMarketing() {
        this.to('aws-marketplace-management:viewMarketing');
        return this;
    }
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewReports() {
        this.to('aws-marketplace-management:viewReports');
        return this;
    }
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewSettings() {
        this.to('aws-marketplace-management:viewSettings');
        return this;
    }
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toviewSupport() {
        this.to('aws-marketplace-management:viewSupport');
        return this;
    }
}
exports.AwsMarketplaceManagement = AwsMarketplaceManagement;
//# sourceMappingURL=data:application/json;base64,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