"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceMeteringService = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-metering-service';
        this.accessLevelList = {
            "Write": [
                "BatchMeterUsage",
                "MeterUsage",
                "RegisterUsage",
                "ResolveCustomer"
            ]
        };
    }
    /**
     * Called from a SaaS application listed on the AWS Marketplace to post metering records for a set of customers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     */
    toBatchMeterUsage() {
        this.to('aws-marketplace-metering-service:BatchMeterUsage');
        return this;
    }
    /**
     * Emits metering records.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     */
    toMeterUsage() {
        this.to('aws-marketplace-metering-service:MeterUsage');
        return this;
    }
    /**
     * Allows you to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     */
    toRegisterUsage() {
        this.to('aws-marketplace-metering-service:RegisterUsage');
        return this;
    }
    /**
     * Resolves a registration token to obtain a CustomerIdentifier and product code.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     */
    toResolveCustomer() {
        this.to('aws-marketplace-metering-service:ResolveCustomer');
        return this;
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
//# sourceMappingURL=data:application/json;base64,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