"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplacePrivate = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatemarketplace.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplacePrivate extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-private](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsprivatemarketplace.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'aws-marketplace-private';
        this.accessLevelList = {
            "Write": [
                "AssociateProductsWithPrivateMarketplace",
                "CreatePrivateMarketplace",
                "CreatePrivateMarketplaceProfile",
                "CreatePrivateMarketplaceRequests",
                "DisassociateProductsFromPrivateMarketplace",
                "StartPrivateMarketplace",
                "StopPrivateMarketplace",
                "UpdatePrivateMarketplaceProfile",
                "UpdatePrivateMarketplaceSettings"
            ],
            "List": [
                "DescribePrivateMarketplaceProducts",
                "DescribePrivateMarketplaceRequests",
                "ListPrivateMarketplaceProducts",
                "ListPrivateMarketplaceRequests"
            ],
            "Read": [
                "DescribePrivateMarketplaceProfile",
                "DescribePrivateMarketplaceSettings",
                "DescribePrivateMarketplaceStatus"
            ]
        };
    }
    /**
     * Adds new approved products to the Private Marketplace. Also allows to approve a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toAssociateProductsWithPrivateMarketplace() {
        this.to('aws-marketplace-private:AssociateProductsWithPrivateMarketplace');
        return this;
    }
    /**
     * Creates a Private Marketplace for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toCreatePrivateMarketplace() {
        this.to('aws-marketplace-private:CreatePrivateMarketplace');
        return this;
    }
    /**
     * Creates a Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toCreatePrivateMarketplaceProfile() {
        this.to('aws-marketplace-private:CreatePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Creates a new request for a product or products to be associated with the Private Marketplace. This action can be performed by any account in an in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toCreatePrivateMarketplaceRequests() {
        this.to('aws-marketplace-private:CreatePrivateMarketplaceRequests');
        return this;
    }
    /**
     * Describes the status of requested products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceProducts() {
        this.to('aws-marketplace-private:DescribePrivateMarketplaceProducts');
        return this;
    }
    /**
     * Describes details about the Private Marketplace Profile for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceProfile() {
        this.to('aws-marketplace-private:DescribePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Describes requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceRequests() {
        this.to('aws-marketplace-private:DescribePrivateMarketplaceRequests');
        return this;
    }
    /**
     * Describes the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceSettings() {
        this.to('aws-marketplace-private:DescribePrivateMarketplaceSettings');
        return this;
    }
    /**
     * Describes the status of the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDescribePrivateMarketplaceStatus() {
        this.to('aws-marketplace-private:DescribePrivateMarketplaceStatus');
        return this;
    }
    /**
     * Removes approved products from the Private Marketplace. Also allows to decline a request for a product to be associated with the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toDisassociateProductsFromPrivateMarketplace() {
        this.to('aws-marketplace-private:DisassociateProductsFromPrivateMarketplace');
        return this;
    }
    /**
     * Queryable list for the products and status of products in the Private Marketplace for administrative purposes. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toListPrivateMarketplaceProducts() {
        this.to('aws-marketplace-private:ListPrivateMarketplaceProducts');
        return this;
    }
    /**
     * Queryable list for requests and associated products in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toListPrivateMarketplaceRequests() {
        this.to('aws-marketplace-private:ListPrivateMarketplaceRequests');
        return this;
    }
    /**
     * Starts the Private Marketplace, enabling the customized AWS Marketplace experience, and enabling restrictions on the procurement of products based on what is available in the Private Marketplace. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toStartPrivateMarketplace() {
        this.to('aws-marketplace-private:StartPrivateMarketplace');
        return this;
    }
    /**
     * Stops the Private Marketplace, disabling the customized AWS Marketplace experience and removing the Private Marketplace procurement restrictions on products. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toStopPrivateMarketplace() {
        this.to('aws-marketplace-private:StopPrivateMarketplace');
        return this;
    }
    /**
     * Updates the Private Marketplace Profile that customizes the white label experience on the AWS Marketplace website for the individual account, or for the entire AWS Organization if one exists. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toUpdatePrivateMarketplaceProfile() {
        this.to('aws-marketplace-private:UpdatePrivateMarketplaceProfile');
        return this;
    }
    /**
     * Updates the Private Marketplace settings. This includes setting for enabling requests from end users and preferences for notifications. This action can be performed by any account in an AWS Organization, provided the user has permissions to do so, and the Organization's Service Control Policies allow it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/private-marketplace.html
     */
    toUpdatePrivateMarketplaceSettings() {
        this.to('aws-marketplace-private:UpdatePrivateMarketplaceSettings');
        return this;
    }
}
exports.AwsMarketplacePrivate = AwsMarketplacePrivate;
//# sourceMappingURL=data:application/json;base64,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