"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comprehendmedical = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_comprehendmedical.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Comprehendmedical extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [comprehendmedical](https://docs.aws.amazon.com/service-authorization/latest/reference/list_comprehendmedical.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'comprehendmedical';
        this.accessLevelList = {
            "Read": [
                "DetectEntities",
                "DetectPHI"
            ]
        };
    }
    /**
     * Inspects the specified text for the specified type of entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectEntities.html
     */
    toDetectEntities() {
        this.to('comprehendmedical:DetectEntities');
        return this;
    }
    /**
     * Inspects the specified text for PHI entities and returns information about them.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/comprehend/latest/dg/API_hera_DetectPHI.html
     */
    toDetectPHI() {
        this.to('comprehendmedical:DetectPHI');
        return this;
    }
}
exports.Comprehendmedical = Comprehendmedical;
//# sourceMappingURL=data:application/json;base64,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