"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Dbqms = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Dbqms extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [dbqms](https://docs.aws.amazon.com/service-authorization/latest/reference/list_databasequerymetadataservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'dbqms';
        this.accessLevelList = {
            "Write": [
                "CreateFavoriteQuery",
                "CreateQueryHistory",
                "DeleteFavoriteQueries",
                "DeleteQueryHistory",
                "UpdateFavoriteQuery",
                "UpdateQueryHistory"
            ],
            "List": [
                "DescribeFavoriteQueries",
                "DescribeQueryHistory"
            ],
            "Read": [
                "GetQueryString"
            ]
        };
    }
    /**
     * Creates a new favorite query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#CreateFavoriteQuery
     */
    toCreateFavoriteQuery() {
        this.to('dbqms:CreateFavoriteQuery');
        return this;
    }
    /**
     * Add a query to the history
     *
     * Access Level: Write
     */
    toCreateQueryHistory() {
        this.to('dbqms:CreateQueryHistory');
        return this;
    }
    /**
     * Delete saved queries
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteFavoriteQueries
     */
    toDeleteFavoriteQueries() {
        this.to('dbqms:DeleteFavoriteQueries');
        return this;
    }
    /**
     * Delete a historical query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DeleteQueryHistory
     */
    toDeleteQueryHistory() {
        this.to('dbqms:DeleteQueryHistory');
        return this;
    }
    /**
     * List saved queries and associated metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeFavoriteQueries
     */
    toDescribeFavoriteQueries() {
        this.to('dbqms:DescribeFavoriteQueries');
        return this;
    }
    /**
     * List history of queries that were run
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#DescribeQueryHistory
     */
    toDescribeQueryHistory() {
        this.to('dbqms:DescribeQueryHistory');
        return this;
    }
    /**
     * Retrieve favorite or history query string by id
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#GetQueryString
     */
    toGetQueryString() {
        this.to('dbqms:GetQueryString');
        return this;
    }
    /**
     * Update saved query and description
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateFavoriteQuery
     */
    toUpdateFavoriteQuery() {
        this.to('dbqms:UpdateFavoriteQuery');
        return this;
    }
    /**
     * Update the query history
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/dbqms-api.html#UpdateQueryHistory
     */
    toUpdateQueryHistory() {
        this.to('dbqms:UpdateQueryHistory');
        return this;
    }
}
exports.Dbqms = Dbqms;
//# sourceMappingURL=data:application/json;base64,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