"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = exports.KeyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "KeyProperty", { enumerable: true, get: function () { return kms_generated_1.RosKey; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Key`
 */
class Key extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Key`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKey = new kms_generated_1.RosKey(this, id, {
            protectionLevel: props.protectionLevel,
            description: props.description,
            rotationInterval: props.rotationInterval,
            enableAutomaticRotation: props.enableAutomaticRotation,
            pendingWindowInDays: props.pendingWindowInDays ? props.pendingWindowInDays : 30,
            keySpec: props.keySpec,
            enable: props.enable ? props.enable : true,
            keyUsage: props.keyUsage ? props.keyUsage : 'ENCRYPT/DECRYPT',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKey;
        this.attrKeyId = rosKey.attrKeyId;
    }
}
exports.Key = Key;
//# sourceMappingURL=data:application/json;base64,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