"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = exports.SecretProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "SecretProperty", { enumerable: true, get: function () { return kms_generated_1.RosSecret; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Secret`
 */
class Secret extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Secret`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSecret = new kms_generated_1.RosSecret(this, id, {
            versionId: props.versionId,
            secretName: props.secretName,
            description: props.description,
            secretDataType: props.secretDataType,
            secretData: props.secretData,
            versionStages: props.versionStages,
            encryptionKeyId: props.encryptionKeyId,
            recoveryWindowInDays: props.recoveryWindowInDays ? props.recoveryWindowInDays : 30,
            forceDeleteWithoutRecovery: props.forceDeleteWithoutRecovery ? props.forceDeleteWithoutRecovery : false,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSecret;
        this.attrArn = rosSecret.attrArn;
        this.attrSecretName = rosSecret.attrSecretName;
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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