import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
 *
 * @experimental
 */
export declare class SsmIncidents extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [ssm-incidents](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerincidentmanager.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to create a replication set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateReplicationSet.html
     *
     * @experimental
     */
    toCreateReplicationSet(): this;
    /**
     * (experimental) Grants permission to create a response plan.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateResponsePlan.html
     *
     * @experimental
     */
    toCreateResponsePlan(): this;
    /**
     * (experimental) Grants permission to create a timeline event for an incident record.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_CreateTimelineEvent.html
     *
     * @experimental
     */
    toCreateTimelineEvent(): this;
    /**
     * (experimental) Grants permission to delete an incident record.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteIncidentRecord.html
     *
     * @experimental
     */
    toDeleteIncidentRecord(): this;
    /**
     * (experimental) Grants permission to delete a replication set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteReplicationSet.html
     *
     * @experimental
     */
    toDeleteReplicationSet(): this;
    /**
     * (experimental) Grants permission to delete resource policy from a response plan.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResourcePolicy.html
     *
     * @experimental
     */
    toDeleteResourcePolicy(): this;
    /**
     * (experimental) Grants permission to delete a response plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteResponsePlan.html
     *
     * @experimental
     */
    toDeleteResponsePlan(): this;
    /**
     * (experimental) Grants permission to delete a timeline event.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_DeleteTimelineEvent.html
     *
     * @experimental
     */
    toDeleteTimelineEvent(): this;
    /**
     * (experimental) Grants permission to view the contents of an incident record.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetIncidentRecord.html
     *
     * @experimental
     */
    toGetIncidentRecord(): this;
    /**
     * (experimental) Grants permission to view the replication set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetReplicationSet.html
     *
     * @experimental
     */
    toGetReplicationSet(): this;
    /**
     * (experimental) Grants permission to view resource policies of a response plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResourcePolicies.html
     *
     * @experimental
     */
    toGetResourcePolicies(): this;
    /**
     * (experimental) Grants permission to view the contents of a specified response plan.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetResponsePlan.html
     *
     * @experimental
     */
    toGetResponsePlan(): this;
    /**
     * (experimental) Grants permission to view a timeline event.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_GetTimelineEvent.html
     *
     * @experimental
     */
    toGetTimelineEvent(): this;
    /**
     * (experimental) Grants permission to list the contents of all incident records.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListIncidentRecords.html
     *
     * @experimental
     */
    toListIncidentRecords(): this;
    /**
     * (experimental) Grants permission to list related items of an incident records.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListRelatedItems.html
     *
     * @experimental
     */
    toListRelatedItems(): this;
    /**
     * (experimental) Grants permission to list all replication sets.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListReplicationSets.html
     *
     * @experimental
     */
    toListReplicationSets(): this;
    /**
     * (experimental) Grants permission to list all response plans.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListResponsePlans.html
     *
     * @experimental
     */
    toListResponsePlans(): this;
    /**
     * (experimental) Grants permission to view a list of resource tags for a specified resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list all timeline events for an incident record.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_ListTimelineEvents.html
     *
     * @experimental
     */
    toListTimelineEvents(): this;
    /**
     * (experimental) Grants permission to put resource policy on a response plan.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_PutResourcePolicy.html
     *
     * @experimental
     */
    toPutResourcePolicy(): this;
    /**
     * (experimental) Grants permission to start a new incident using a response plan.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_StartIncident.html
     *
     * @experimental
     */
    toStartIncident(): this;
    /**
     * (experimental) Grants permission to add tags to a response plan.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tags from a response plan.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update replication set deletion protection.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateDeletionProtection.html
     *
     * @experimental
     */
    toUpdateDeletionProtection(): this;
    /**
     * (experimental) Grants permission to update the contents of an incident record.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateIncidentRecord.html
     *
     * @experimental
     */
    toUpdateIncidentRecord(): this;
    /**
     * (experimental) Grants permission to update related items of an incident record.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateRelatedItems.html
     *
     * @experimental
     */
    toUpdateRelatedItems(): this;
    /**
     * (experimental) Grants permission to update a replication set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateReplicationSet.html
     *
     * @experimental
     */
    toUpdateReplicationSet(): this;
    /**
     * (experimental) Grants permission to update the contents of a response plan.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateResponsePlan.html
     *
     * @experimental
     */
    toUpdateResponsePlan(): this;
    /**
     * (experimental) Grants permission to update a timeline event.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/incident-manager/latest/APIReference/API_UpdateTimelineEvent.html
     *
     * @experimental
     */
    toUpdateTimelineEvent(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type response-plan to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/response-plans.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onResponsePlan(responsePlan: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type incident-record to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/incident-record.html
     *
     * @param responsePlan - Identifier for the responsePlan.
     * @param incidentRecord - Identifier for the incidentRecord.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onIncidentRecord(responsePlan: string, incidentRecord: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type replication-set to the statement.
     *
     * https://docs.aws.amazon.com/incident-manager/latest/UserGuide/replication-set.html
     *
     * @param replicationSet - Identifier for the replicationSet.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onReplicationSet(replicationSet: string, account?: string, partition?: string): this;
}
