# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class NameServerRecord(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'raw': 'str',
        'record_type': 'str',
        'priority': 'str',
        'value': 'str'
    }

    attribute_map = {
        'raw': 'raw',
        'record_type': 'recordType',
        'priority': 'priority',
        'value': 'value'
    }

    def __init__(self, raw=None, record_type=None, priority=None, value=None, local_vars_configuration=None):  # noqa: E501
        """NameServerRecord - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._raw = None
        self._record_type = None
        self._priority = None
        self._value = None
        self.discriminator = None

        self.raw = raw
        self.record_type = record_type
        self.priority = priority
        self.value = value

    @property
    def raw(self):
        """Gets the raw of this NameServerRecord.  # noqa: E501


        :return: The raw of this NameServerRecord.  # noqa: E501
        :rtype: str
        """
        return self._raw

    @raw.setter
    def raw(self, raw):
        """Sets the raw of this NameServerRecord.


        :param raw: The raw of this NameServerRecord.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and raw is None:  # noqa: E501
            raise ValueError("Invalid value for `raw`, must not be `None`")  # noqa: E501

        self._raw = raw

    @property
    def record_type(self):
        """Gets the record_type of this NameServerRecord.  # noqa: E501


        :return: The record_type of this NameServerRecord.  # noqa: E501
        :rtype: str
        """
        return self._record_type

    @record_type.setter
    def record_type(self, record_type):
        """Sets the record_type of this NameServerRecord.


        :param record_type: The record_type of this NameServerRecord.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and record_type is None:  # noqa: E501
            raise ValueError("Invalid value for `record_type`, must not be `None`")  # noqa: E501

        self._record_type = record_type

    @property
    def priority(self):
        """Gets the priority of this NameServerRecord.  # noqa: E501


        :return: The priority of this NameServerRecord.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this NameServerRecord.


        :param priority: The priority of this NameServerRecord.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and priority is None:  # noqa: E501
            raise ValueError("Invalid value for `priority`, must not be `None`")  # noqa: E501

        self._priority = priority

    @property
    def value(self):
        """Gets the value of this NameServerRecord.  # noqa: E501


        :return: The value of this NameServerRecord.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this NameServerRecord.


        :param value: The value of this NameServerRecord.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and value is None:  # noqa: E501
            raise ValueError("Invalid value for `value`, must not be `None`")  # noqa: E501

        self._value = value

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NameServerRecord):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NameServerRecord):
            return True

        return self.to_dict() != other.to_dict()
