# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from regula.facesdk.webclient.gen.api_client import ApiClient
from regula.facesdk.webclient.gen.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PersonApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_image_to_person(self, person_id, add_image_to_person_request, **kwargs):  # noqa: E501
        """Add person image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_image_to_person(person_id, add_image_to_person_request, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param add_image_to_person_request: Image to add. (required)
        :type add_image_to_person_request: AddImageToPersonRequest
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AddImageToPersonResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.add_image_to_person_with_http_info(person_id, add_image_to_person_request, **kwargs)  # noqa: E501

    def add_image_to_person_with_http_info(self, person_id, add_image_to_person_request, **kwargs):  # noqa: E501
        """Add person image  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_image_to_person_with_http_info(person_id, add_image_to_person_request, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param add_image_to_person_request: Image to add. (required)
        :type add_image_to_person_request: AddImageToPersonRequest
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AddImageToPersonResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'add_image_to_person_request',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_image_to_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `add_image_to_person`")  # noqa: E501
        # verify the required parameter 'add_image_to_person_request' is set
        if self.api_client.client_side_validation and ('add_image_to_person_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_image_to_person_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_image_to_person_request` when calling `add_image_to_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_image_to_person_request' in local_var_params:
            body_params = local_var_params['add_image_to_person_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}/images', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AddImageToPersonResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_person(self, person_fields, **kwargs):  # noqa: E501
        """Create person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_person(person_fields, async_req=True)
        >>> result = thread.get()

        :param person_fields: (required)
        :type person_fields: PersonFields
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        return self.create_person_with_http_info(person_fields, **kwargs)  # noqa: E501

    def create_person_with_http_info(self, person_fields, **kwargs):  # noqa: E501
        """Create person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_person_with_http_info(person_fields, async_req=True)
        >>> result = thread.get()

        :param person_fields: (required)
        :type person_fields: PersonFields
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'person_fields',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_fields' is set
        if self.api_client.client_side_validation and ('person_fields' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_fields'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_fields` when calling `create_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'person_fields' in local_var_params:
            body_params = local_var_params['person_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_image_of_person(self, image_id, person_id, **kwargs):  # noqa: E501
        """Delete image of person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_image_of_person(image_id, person_id, async_req=True)
        >>> result = thread.get()

        :param image_id: Image ID. (required)
        :type image_id: str
        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_image_of_person_with_http_info(image_id, person_id, **kwargs)  # noqa: E501

    def delete_image_of_person_with_http_info(self, image_id, person_id, **kwargs):  # noqa: E501
        """Delete image of person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_image_of_person_with_http_info(image_id, person_id, async_req=True)
        >>> result = thread.get()

        :param image_id: Image ID. (required)
        :type image_id: str
        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'image_id',
            'person_id',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_image_of_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'image_id' is set
        if self.api_client.client_side_validation and ('image_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['image_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `image_id` when calling `delete_image_of_person`")  # noqa: E501
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `delete_image_of_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_id' in local_var_params:
            path_params['imageId'] = local_var_params['image_id']  # noqa: E501
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}/images/{imageId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_person(self, person_id, **kwargs):  # noqa: E501
        """Delete person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_person_with_http_info(person_id, **kwargs)  # noqa: E501

    def delete_person_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Delete person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_person_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `delete_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_groups_by_person_id(self, person_id, **kwargs):  # noqa: E501
        """Get person groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_groups_by_person_id(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param page: The page number to get a list of persons or groups.
        :type page: int
        :param size: The page size with a list of persons or groups, items.
        :type size: int
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GroupPage
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_groups_by_person_id_with_http_info(person_id, **kwargs)  # noqa: E501

    def get_all_groups_by_person_id_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Get person groups  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_groups_by_person_id_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param page: The page number to get a list of persons or groups.
        :type page: int
        :param size: The page size with a list of persons or groups, items.
        :type size: int
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GroupPage, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'page',
            'size',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_groups_by_person_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `get_all_groups_by_person_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}/groups', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GroupPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_images_by_person_id(self, person_id, **kwargs):  # noqa: E501
        """Get person images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_images_by_person_id(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param page: The page number to get a list of persons or groups.
        :type page: int
        :param size: The page size with a list of persons or groups, items.
        :type size: int
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ImagePage
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_images_by_person_id_with_http_info(person_id, **kwargs)  # noqa: E501

    def get_all_images_by_person_id_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Get person images  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_images_by_person_id_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param page: The page number to get a list of persons or groups.
        :type page: int
        :param size: The page size with a list of persons or groups, items.
        :type size: int
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ImagePage, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'page',
            'size',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_images_by_person_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `get_all_images_by_person_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'size' in local_var_params and local_var_params['size'] is not None:  # noqa: E501
            query_params.append(('size', local_var_params['size']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}/images', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ImagePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_image_of_person(self, image_id, person_id, **kwargs):  # noqa: E501
        """Get person image by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_of_person(image_id, person_id, async_req=True)
        >>> result = thread.get()

        :param image_id: Image ID. (required)
        :type image_id: str
        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: file_type
        """
        kwargs['_return_http_data_only'] = True
        return self.get_image_of_person_with_http_info(image_id, person_id, **kwargs)  # noqa: E501

    def get_image_of_person_with_http_info(self, image_id, person_id, **kwargs):  # noqa: E501
        """Get person image by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_image_of_person_with_http_info(image_id, person_id, async_req=True)
        >>> result = thread.get()

        :param image_id: Image ID. (required)
        :type image_id: str
        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(file_type, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'image_id',
            'person_id',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_image_of_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'image_id' is set
        if self.api_client.client_side_validation and ('image_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['image_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `image_id` when calling `get_image_of_person`")  # noqa: E501
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `get_image_of_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'image_id' in local_var_params:
            path_params['imageId'] = local_var_params['image_id']  # noqa: E501
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json''image/*'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}/images/{imageId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file_type',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_person(self, person_id, **kwargs):  # noqa: E501
        """Get person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Person
        """
        kwargs['_return_http_data_only'] = True
        return self.get_person_with_http_info(person_id, **kwargs)  # noqa: E501

    def get_person_with_http_info(self, person_id, **kwargs):  # noqa: E501
        """Get person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person_with_http_info(person_id, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Person, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `get_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Person',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_person(self, person_id, person_to_update_fields, **kwargs):  # noqa: E501
        """Update person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_person(person_id, person_to_update_fields, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param person_to_update_fields: Request body for the Person to update. (required)
        :type person_to_update_fields: PersonToUpdateFields
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.update_person_with_http_info(person_id, person_to_update_fields, **kwargs)  # noqa: E501

    def update_person_with_http_info(self, person_id, person_to_update_fields, **kwargs):  # noqa: E501
        """Update person  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_person_with_http_info(person_id, person_to_update_fields, async_req=True)
        >>> result = thread.get()

        :param person_id: Person ID. (required)
        :type person_id: str
        :param person_to_update_fields: Request body for the Person to update. (required)
        :type person_to_update_fields: PersonToUpdateFields
        :param x_request_id: Request header label.
        :type x_request_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'person_id',
            'person_to_update_fields',
            'x_request_id',
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_person" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'person_id' is set
        if self.api_client.client_side_validation and ('person_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_id` when calling `update_person`")  # noqa: E501
        # verify the required parameter 'person_to_update_fields' is set
        if self.api_client.client_side_validation and ('person_to_update_fields' not in local_var_params or  # noqa: E501
                                                        local_var_params['person_to_update_fields'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `person_to_update_fields` when calling `update_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'person_id' in local_var_params:
            path_params['personId'] = local_var_params['person_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in local_var_params:
            header_params['X-RequestID'] = local_var_params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'person_to_update_fields' in local_var_params:
            body_params = local_var_params['person_to_update_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/persons/{personId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
