# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from regula.facesdk.webclient.gen.configuration import Configuration


class AddImageToPersonRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tag': 'str',
        'image': 'AddImageToPersonRequestImage',
        'threshold': 'float',
        'limit': 'int',
    }

    attribute_map = {
        'tag': 'tag',
        'image': 'image',
        'threshold': 'threshold',
        'limit': 'limit',
    }

    def __init__(self, tag=None, image=None, threshold=None, limit=None, local_vars_configuration=None):  # noqa: E501
        """AddImageToPersonRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tag = None
        self._image = None
        self._threshold = None
        self._limit = None
        self.discriminator = None

        if tag is not None:
            self.tag = tag
        self.image = image
        if threshold is not None:
            self.threshold = threshold
        if limit is not None:
            self.limit = limit

    @property
    def tag(self):
        """Gets the tag of this AddImageToPersonRequest.  # noqa: E501

        Session identificator.  # noqa: E501

        :return: The tag of this AddImageToPersonRequest.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this AddImageToPersonRequest.

        Session identificator.  # noqa: E501

        :param tag: The tag of this AddImageToPersonRequest.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def image(self):
        """Gets the image of this AddImageToPersonRequest.  # noqa: E501


        :return: The image of this AddImageToPersonRequest.  # noqa: E501
        :rtype: AddImageToPersonRequestImage
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this AddImageToPersonRequest.


        :param image: The image of this AddImageToPersonRequest.  # noqa: E501
        :type image: AddImageToPersonRequestImage
        """
        if self.local_vars_configuration.client_side_validation and image is None:  # noqa: E501
            raise ValueError("Invalid value for `image`, must not be `None`")  # noqa: E501

        self._image = image

    @property
    def threshold(self):
        """Gets the threshold of this AddImageToPersonRequest.  # noqa: E501

        The similarity threshold.  # noqa: E501

        :return: The threshold of this AddImageToPersonRequest.  # noqa: E501
        :rtype: float
        """
        return self._threshold

    @threshold.setter
    def threshold(self, threshold):
        """Sets the threshold of this AddImageToPersonRequest.

        The similarity threshold.  # noqa: E501

        :param threshold: The threshold of this AddImageToPersonRequest.  # noqa: E501
        :type threshold: float
        """

        self._threshold = threshold

    @property
    def limit(self):
        """Gets the limit of this AddImageToPersonRequest.  # noqa: E501

        The maximum number of results to be returned.  # noqa: E501

        :return: The limit of this AddImageToPersonRequest.  # noqa: E501
        :rtype: int
        """
        return self._limit

    @limit.setter
    def limit(self, limit):
        """Sets the limit of this AddImageToPersonRequest.

        The maximum number of results to be returned.  # noqa: E501

        :param limit: The limit of this AddImageToPersonRequest.  # noqa: E501
        :type limit: int
        """

        self._limit = limit

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddImageToPersonRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddImageToPersonRequest):
            return True

        return self.to_dict() != other.to_dict()
