# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from regula.facesdk.webclient.gen.configuration import Configuration


class DetectionQuality(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'non_compliant': '[FaceQualityConfigName]',
        'details_groups': '[QualityDetailsGroups]',
        'details': '[QualityDetail]',
        'score': 'float',
        'timer': 'float',
    }

    attribute_map = {
        'non_compliant': 'nonCompliant',
        'details_groups': 'detailsGroups',
        'details': 'details',
        'score': 'score',
        'timer': 'timer',
    }

    def __init__(self, non_compliant=None, details_groups=None, details=None, score=None, timer=None, local_vars_configuration=None):  # noqa: E501
        """DetectionQuality - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._non_compliant = None
        self._details_groups = None
        self._details = None
        self._score = None
        self._timer = None
        self.discriminator = None

        if non_compliant is not None:
            self.non_compliant = non_compliant
        if details_groups is not None:
            self.details_groups = details_groups
        if details is not None:
            self.details = details
        if score is not None:
            self.score = score
        if timer is not None:
            self.timer = timer

    @property
    def non_compliant(self):
        """Gets the non_compliant of this DetectionQuality.  # noqa: E501

        The array of all the non-compliant assessment characteristics.  # noqa: E501

        :return: The non_compliant of this DetectionQuality.  # noqa: E501
        :rtype: [FaceQualityConfigName]
        """
        return self._non_compliant

    @non_compliant.setter
    def non_compliant(self, non_compliant):
        """Sets the non_compliant of this DetectionQuality.

        The array of all the non-compliant assessment characteristics.  # noqa: E501

        :param non_compliant: The non_compliant of this DetectionQuality.  # noqa: E501
        :type non_compliant: [FaceQualityConfigName]
        """

        self._non_compliant = non_compliant

    @property
    def details_groups(self):
        """Gets the details_groups of this DetectionQuality.  # noqa: E501

        The array of the assessment results for each group of characteristics.  # noqa: E501

        :return: The details_groups of this DetectionQuality.  # noqa: E501
        :rtype: [QualityDetailsGroups]
        """
        return self._details_groups

    @details_groups.setter
    def details_groups(self, details_groups):
        """Sets the details_groups of this DetectionQuality.

        The array of the assessment results for each group of characteristics.  # noqa: E501

        :param details_groups: The details_groups of this DetectionQuality.  # noqa: E501
        :type details_groups: [QualityDetailsGroups]
        """

        self._details_groups = details_groups

    @property
    def details(self):
        """Gets the details of this DetectionQuality.  # noqa: E501

        The array of the assessment characteristics that were set in the request.  # noqa: E501

        :return: The details of this DetectionQuality.  # noqa: E501
        :rtype: [QualityDetail]
        """
        return self._details

    @details.setter
    def details(self, details):
        """Sets the details of this DetectionQuality.

        The array of the assessment characteristics that were set in the request.  # noqa: E501

        :param details: The details of this DetectionQuality.  # noqa: E501
        :type details: [QualityDetail]
        """

        self._details = details

    @property
    def score(self):
        """Gets the score of this DetectionQuality.  # noqa: E501

        Returns the estimated portrait quality assessment result, a number from 0 to 1, where 1 is for absolute compliance.  # noqa: E501

        :return: The score of this DetectionQuality.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this DetectionQuality.

        Returns the estimated portrait quality assessment result, a number from 0 to 1, where 1 is for absolute compliance.  # noqa: E501

        :param score: The score of this DetectionQuality.  # noqa: E501
        :type score: float
        """

        self._score = score

    @property
    def timer(self):
        """Gets the timer of this DetectionQuality.  # noqa: E501

        The total time the quality assessment has taken.  # noqa: E501

        :return: The timer of this DetectionQuality.  # noqa: E501
        :rtype: float
        """
        return self._timer

    @timer.setter
    def timer(self, timer):
        """Sets the timer of this DetectionQuality.

        The total time the quality assessment has taken.  # noqa: E501

        :param timer: The timer of this DetectionQuality.  # noqa: E501
        :type timer: float
        """

        self._timer = timer

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DetectionQuality):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DetectionQuality):
            return True

        return self.to_dict() != other.to_dict()
