# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from regula.facesdk.webclient.gen.configuration import Configuration


class MatchImageResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'first_index': 'int',
        'first_face_index': 'float',
        'first': 'ImageSource',
        'second_index': 'int',
        'second_face_index': 'float',
        'second': 'ImageSource',
        'score': 'float',
        'similarity': 'float',
    }

    attribute_map = {
        'first_index': 'firstIndex',
        'first_face_index': 'firstFaceIndex',
        'first': 'first',
        'second_index': 'secondIndex',
        'second_face_index': 'secondFaceIndex',
        'second': 'second',
        'score': 'score',
        'similarity': 'similarity',
    }

    def __init__(self, first_index=None, first_face_index=None, first=None, second_index=None, second_face_index=None, second=None, score=None, similarity=None, local_vars_configuration=None):  # noqa: E501
        """MatchImageResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._first_index = None
        self._first_face_index = None
        self._first = None
        self._second_index = None
        self._second_face_index = None
        self._second = None
        self._score = None
        self._similarity = None
        self.discriminator = None

        self.first_index = first_index
        if first_face_index is not None:
            self.first_face_index = first_face_index
        if first is not None:
            self.first = first
        self.second_index = second_index
        if second_face_index is not None:
            self.second_face_index = second_face_index
        if second is not None:
            self.second = second
        if score is not None:
            self.score = score
        if similarity is not None:
            self.similarity = similarity

    @property
    def first_index(self):
        """Gets the first_index of this MatchImageResult.  # noqa: E501

        The image index number. Can be given; if not given, the index numbers are set automatically starting from `0`. All index numbers must be whole and unique—not repeated.  # noqa: E501

        :return: The first_index of this MatchImageResult.  # noqa: E501
        :rtype: int
        """
        return self._first_index

    @first_index.setter
    def first_index(self, first_index):
        """Sets the first_index of this MatchImageResult.

        The image index number. Can be given; if not given, the index numbers are set automatically starting from `0`. All index numbers must be whole and unique—not repeated.  # noqa: E501

        :param first_index: The first_index of this MatchImageResult.  # noqa: E501
        :type first_index: int
        """
        if self.local_vars_configuration.client_side_validation and first_index is None:  # noqa: E501
            raise ValueError("Invalid value for `first_index`, must not be `None`")  # noqa: E501

        self._first_index = first_index

    @property
    def first_face_index(self):
        """Gets the first_face_index of this MatchImageResult.  # noqa: E501

        The detected face index number.  # noqa: E501

        :return: The first_face_index of this MatchImageResult.  # noqa: E501
        :rtype: float
        """
        return self._first_face_index

    @first_face_index.setter
    def first_face_index(self, first_face_index):
        """Sets the first_face_index of this MatchImageResult.

        The detected face index number.  # noqa: E501

        :param first_face_index: The first_face_index of this MatchImageResult.  # noqa: E501
        :type first_face_index: float
        """

        self._first_face_index = first_face_index

    @property
    def first(self):
        """Gets the first of this MatchImageResult.  # noqa: E501


        :return: The first of this MatchImageResult.  # noqa: E501
        :rtype: ImageSource
        """
        return self._first

    @first.setter
    def first(self, first):
        """Sets the first of this MatchImageResult.


        :param first: The first of this MatchImageResult.  # noqa: E501
        :type first: ImageSource
        """

        self._first = first

    @property
    def second_index(self):
        """Gets the second_index of this MatchImageResult.  # noqa: E501

        The image index number. Can be given; if not given, the index numbers are set automatically starting from `0`. All index numbers must be whole and unique—not repeated.  # noqa: E501

        :return: The second_index of this MatchImageResult.  # noqa: E501
        :rtype: int
        """
        return self._second_index

    @second_index.setter
    def second_index(self, second_index):
        """Sets the second_index of this MatchImageResult.

        The image index number. Can be given; if not given, the index numbers are set automatically starting from `0`. All index numbers must be whole and unique—not repeated.  # noqa: E501

        :param second_index: The second_index of this MatchImageResult.  # noqa: E501
        :type second_index: int
        """
        if self.local_vars_configuration.client_side_validation and second_index is None:  # noqa: E501
            raise ValueError("Invalid value for `second_index`, must not be `None`")  # noqa: E501

        self._second_index = second_index

    @property
    def second_face_index(self):
        """Gets the second_face_index of this MatchImageResult.  # noqa: E501

        The detected face index number.  # noqa: E501

        :return: The second_face_index of this MatchImageResult.  # noqa: E501
        :rtype: float
        """
        return self._second_face_index

    @second_face_index.setter
    def second_face_index(self, second_face_index):
        """Sets the second_face_index of this MatchImageResult.

        The detected face index number.  # noqa: E501

        :param second_face_index: The second_face_index of this MatchImageResult.  # noqa: E501
        :type second_face_index: float
        """

        self._second_face_index = second_face_index

    @property
    def second(self):
        """Gets the second of this MatchImageResult.  # noqa: E501


        :return: The second of this MatchImageResult.  # noqa: E501
        :rtype: ImageSource
        """
        return self._second

    @second.setter
    def second(self, second):
        """Sets the second of this MatchImageResult.


        :param second: The second of this MatchImageResult.  # noqa: E501
        :type second: ImageSource
        """

        self._second = second

    @property
    def score(self):
        """Gets the score of this MatchImageResult.  # noqa: E501

        A dimensionless number that shows how similar the compared faces are. 0—absolutely identical faces.  # noqa: E501

        :return: The score of this MatchImageResult.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this MatchImageResult.

        A dimensionless number that shows how similar the compared faces are. 0—absolutely identical faces.  # noqa: E501

        :param score: The score of this MatchImageResult.  # noqa: E501
        :type score: float
        """

        self._score = score

    @property
    def similarity(self):
        """Gets the similarity of this MatchImageResult.  # noqa: E501

        The detected faces similarity, %. 100%—absolutely identical faces, 0%—absolutely not identical.  # noqa: E501

        :return: The similarity of this MatchImageResult.  # noqa: E501
        :rtype: float
        """
        return self._similarity

    @similarity.setter
    def similarity(self, similarity):
        """Sets the similarity of this MatchImageResult.

        The detected faces similarity, %. 100%—absolutely identical faces, 0%—absolutely not identical.  # noqa: E501

        :param similarity: The similarity of this MatchImageResult.  # noqa: E501
        :type similarity: float
        """

        self._similarity = similarity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchImageResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MatchImageResult):
            return True

        return self.to_dict() != other.to_dict()
