# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from regula.facesdk.webclient.gen.configuration import Configuration


class MatchRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'tag': 'str',
        'thumbnails': 'bool, date, datetime, dict, float, int, list, str, none_type',
        'images': '[MatchImage]',
        'output_image_params': 'OutputImageParams',
    }

    attribute_map = {
        'tag': 'tag',
        'thumbnails': 'thumbnails',
        'images': 'images',
        'output_image_params': 'outputImageParams',
    }

    def __init__(self, tag=None, thumbnails=None, images=None, output_image_params=None, local_vars_configuration=None):  # noqa: E501
        """MatchRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._tag = None
        self._thumbnails = None
        self._images = None
        self._output_image_params = None
        self.discriminator = None

        if tag is not None:
            self.tag = tag
        self.thumbnails = thumbnails
        self.images = images
        if output_image_params is not None:
            self.output_image_params = output_image_params

    @property
    def tag(self):
        """Gets the tag of this MatchRequest.  # noqa: E501

        Session identificator, should be unique for each session.  # noqa: E501

        :return: The tag of this MatchRequest.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this MatchRequest.

        Session identificator, should be unique for each session.  # noqa: E501

        :param tag: The tag of this MatchRequest.  # noqa: E501
        :type tag: str
        """

        self._tag = tag

    @property
    def thumbnails(self):
        """Gets the thumbnails of this MatchRequest.  # noqa: E501

        Use `outputImageParams.crop` instead.  # noqa: E501

        :return: The thumbnails of this MatchRequest.  # noqa: E501
        :rtype: bool, date, datetime, dict, float, int, list, str, none_type
        """
        return self._thumbnails

    @thumbnails.setter
    def thumbnails(self, thumbnails):
        """Sets the thumbnails of this MatchRequest.

        Use `outputImageParams.crop` instead.  # noqa: E501

        :param thumbnails: The thumbnails of this MatchRequest.  # noqa: E501
        :type thumbnails: bool, date, datetime, dict, float, int, list, str, none_type
        """

        self._thumbnails = thumbnails

    @property
    def images(self):
        """Gets the images of this MatchRequest.  # noqa: E501

        All images included in the comparison.  # noqa: E501

        :return: The images of this MatchRequest.  # noqa: E501
        :rtype: [MatchImage]
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this MatchRequest.

        All images included in the comparison.  # noqa: E501

        :param images: The images of this MatchRequest.  # noqa: E501
        :type images: [MatchImage]
        """
        if self.local_vars_configuration.client_side_validation and images is None:  # noqa: E501
            raise ValueError("Invalid value for `images`, must not be `None`")  # noqa: E501

        self._images = images

    @property
    def output_image_params(self):
        """Gets the output_image_params of this MatchRequest.  # noqa: E501


        :return: The output_image_params of this MatchRequest.  # noqa: E501
        :rtype: OutputImageParams
        """
        return self._output_image_params

    @output_image_params.setter
    def output_image_params(self, output_image_params):
        """Sets the output_image_params of this MatchRequest.


        :param output_image_params: The output_image_params of this MatchRequest.  # noqa: E501
        :type output_image_params: OutputImageParams
        """

        self._output_image_params = output_image_params

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MatchRequest):
            return True

        return self.to_dict() != other.to_dict()
