# coding: utf-8

"""
    Regula Face SDK Web API

    <a href=\"https://regulaforensics.com/products/face-recognition-sdk/  \" target=\"_blank\">Regula Face SDK</a> is a cross-platform biometric verification solution for a digital identity verification process and image quality assurance. The SDK enables convenient and reliable face capture on the client side (mobile, web, and desktop) and further processing on the client or server side.   The Face SDK includes the following features:  * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-detection\" target=\"_blank\">Face detection and image quality assessment</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-comparison-11\" target=\"_blank\">Face match (1:1)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#face-identification-1n\" target=\"_blank\">Face search (1:N)</a> * <a href=\"https://docs.regulaforensics.com/develop/face-sdk/overview/introduction/#liveness-assessment\" target=\"_blank\">Liveness detection</a>  Here is the <a href=\"https://github.com/regulaforensics/FaceSDK-web-openapi  \" target=\"_blank\">OpenAPI specification on GitHub</a>.   ### Clients * [JavaScript](https://github.com/regulaforensics/FaceSDK-web-js-client) client for the browser and node.js based on axios * [Java](https://github.com/regulaforensics/FaceSDK-web-java-client) client compatible with jvm and android * [Python](https://github.com/regulaforensics/FaceSDK-web-python-client) 3.5+ client * [C#](https://github.com/regulaforensics/FaceSDK-web-csharp-client) client for .NET & .NET Core   # noqa: E501

    The version of the OpenAPI document: 6.1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from regula.facesdk.webclient.gen.configuration import Configuration


class MatchRequestOutputImageParamsCrop(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'pad_color': '[int]',
        'return_original_rect': 'bool',
        'size': '[int]',
        'type': 'int',
    }

    attribute_map = {
        'pad_color': 'padColor',
        'return_original_rect': 'returnOriginalRect',
        'size': 'size',
        'type': 'type',
    }

    def __init__(self, pad_color=None, return_original_rect=None, size=None, type=None, local_vars_configuration=None):  # noqa: E501
        """MatchRequestOutputImageParamsCrop - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._pad_color = None
        self._return_original_rect = None
        self._size = None
        self._type = None
        self.discriminator = None

        if pad_color is not None:
            self.pad_color = pad_color
        if return_original_rect is not None:
            self.return_original_rect = return_original_rect
        if size is not None:
            self.size = size
        if type is not None:
            self.type = type

    @property
    def pad_color(self):
        """Gets the pad_color of this MatchRequestOutputImageParamsCrop.  # noqa: E501

        The RGB value of a color for filling background behind a person's silhouette and for aligning the image.  # noqa: E501

        :return: The pad_color of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :rtype: [int]
        """
        return self._pad_color

    @pad_color.setter
    def pad_color(self, pad_color):
        """Sets the pad_color of this MatchRequestOutputImageParamsCrop.

        The RGB value of a color for filling background behind a person's silhouette and for aligning the image.  # noqa: E501

        :param pad_color: The pad_color of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :type pad_color: [int]
        """

        self._pad_color = pad_color

    @property
    def return_original_rect(self):
        """Gets the return_original_rect of this MatchRequestOutputImageParamsCrop.  # noqa: E501

        Whether to return the coordinates of the rectangle with the face in the original image prepared for the face crop.  # noqa: E501

        :return: The return_original_rect of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :rtype: bool
        """
        return self._return_original_rect

    @return_original_rect.setter
    def return_original_rect(self, return_original_rect):
        """Sets the return_original_rect of this MatchRequestOutputImageParamsCrop.

        Whether to return the coordinates of the rectangle with the face in the original image prepared for the face crop.  # noqa: E501

        :param return_original_rect: The return_original_rect of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :type return_original_rect: bool
        """

        self._return_original_rect = return_original_rect

    @property
    def size(self):
        """Gets the size of this MatchRequestOutputImageParamsCrop.  # noqa: E501

        The resize value in case `type` matches this value. If it doesn't, no resize is performed.  # noqa: E501

        :return: The size of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :rtype: [int]
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this MatchRequestOutputImageParamsCrop.

        The resize value in case `type` matches this value. If it doesn't, no resize is performed.  # noqa: E501

        :param size: The size of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :type size: [int]
        """

        self._size = size

    @property
    def type(self):
        """Gets the type of this MatchRequestOutputImageParamsCrop.  # noqa: E501

        The aspect ratio according to which face alignment is performed. See the [FaceImageQualityAlignType enum](https://docs.regulaforensics.com/develop/face-sdk/web-service/development/enums/face-image-quality-align-type/). To get a thumbnail with aspect ratio 3:4, set `0`.  # noqa: E501

        :return: The type of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this MatchRequestOutputImageParamsCrop.

        The aspect ratio according to which face alignment is performed. See the [FaceImageQualityAlignType enum](https://docs.regulaforensics.com/develop/face-sdk/web-service/development/enums/face-image-quality-align-type/). To get a thumbnail with aspect ratio 3:4, set `0`.  # noqa: E501

        :param type: The type of this MatchRequestOutputImageParamsCrop.  # noqa: E501
        :type type: int
        """
        allowed_values = [0, 1, 2, 3, 4]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchRequestOutputImageParamsCrop):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MatchRequestOutputImageParamsCrop):
            return True

        return self.to_dict() != other.to_dict()
