"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone': {
        'Hosted Zone constructs the ARN'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '123456789012', region: 'us-east-1' },
            });
            const testZone = new lib_1.HostedZone(stack, 'HostedZone', {
                zoneName: 'testZone',
            });
            test.deepEqual(stack.resolve(testZone.hostedZoneArn), {
                'Fn::Join': [
                    '',
                    [
                        'arn:',
                        { Ref: 'AWS::Partition' },
                        ':route53:::hostedzone/',
                        { Ref: 'HostedZoneDB99F866' },
                    ],
                ],
            });
            test.done();
        },
    },
    'Supports tags'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const hostedZone = new lib_1.HostedZone(stack, 'HostedZone', {
            zoneName: 'test.zone',
        });
        cdk.Tag.add(hostedZone, 'zoneTag', 'inMyZone');
        // THEN
        assert_1.expect(stack).toMatch({
            Resources: {
                HostedZoneDB99F866: {
                    Type: 'AWS::Route53::HostedZone',
                    Properties: {
                        Name: 'test.zone.',
                        HostedZoneTags: [
                            {
                                Key: 'zoneTag',
                                Value: 'inMyZone',
                            },
                        ],
                    },
                },
            },
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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