# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['TlsSubscriptionValidationArgs', 'TlsSubscriptionValidation']

@pulumi.input_type
class TlsSubscriptionValidationArgs:
    def __init__(__self__, *,
                 subscription_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a TlsSubscriptionValidation resource.
        :param pulumi.Input[str] subscription_id: The ID of the TLS Subscription that should be validated.
        """
        pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[str]:
        """
        The ID of the TLS Subscription that should be validated.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subscription_id", value)


@pulumi.input_type
class _TlsSubscriptionValidationState:
    def __init__(__self__, *,
                 subscription_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TlsSubscriptionValidation resources.
        :param pulumi.Input[str] subscription_id: The ID of the TLS Subscription that should be validated.
        """
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the TLS Subscription that should be validated.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_id", value)


class TlsSubscriptionValidation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource represents a successful validation of a Fastly TLS Subscription in concert with other resources.

        Most commonly, this resource is used together with a resource for a DNS record and `TlsSubscription` to request a DNS validated certificate, deploy the required validation records and wait for validation to complete.

        > **Warning:** This resource implements a part of the validation workflow. It does not represent a real-world entity in Fastly, therefore changing or deleting this resource on its own has no immediate effect.

        ## Example Usage

        DNS Validation with AWS Route53:

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly

        domain_name = "example.com"
        example_servicev1 = fastly.Servicev1("exampleServicev1",
            domains=[fastly.Servicev1DomainArgs(
                name=domain_name,
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="127.0.0.1",
                name="localhost",
            )],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("exampleTlsSubscription",
            domains=example_servicev1.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        demo = aws.route53.get_zone(name=domain_name,
            private_zone=False)
        # Set up DNS record for managed DNS domain validation method
        domain_validation = aws.route53.Record("domainValidation",
            name=example_tls_subscription.managed_dns_challenge["recordName"],
            type=example_tls_subscription.managed_dns_challenge["recordType"],
            zone_id=demo.id,
            allow_overwrite=True,
            records=[example_tls_subscription.managed_dns_challenge["recordValue"]],
            ttl=60)
        # Resource that other resources can depend on if they require the certificate to be issued
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("exampleTlsSubscriptionValidation", subscription_id=example_tls_subscription.id,
        opts=pulumi.ResourceOptions(depends_on=[domain_validation]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] subscription_id: The ID of the TLS Subscription that should be validated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsSubscriptionValidationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource represents a successful validation of a Fastly TLS Subscription in concert with other resources.

        Most commonly, this resource is used together with a resource for a DNS record and `TlsSubscription` to request a DNS validated certificate, deploy the required validation records and wait for validation to complete.

        > **Warning:** This resource implements a part of the validation workflow. It does not represent a real-world entity in Fastly, therefore changing or deleting this resource on its own has no immediate effect.

        ## Example Usage

        DNS Validation with AWS Route53:

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_fastly as fastly

        domain_name = "example.com"
        example_servicev1 = fastly.Servicev1("exampleServicev1",
            domains=[fastly.Servicev1DomainArgs(
                name=domain_name,
            )],
            backends=[fastly.Servicev1BackendArgs(
                address="127.0.0.1",
                name="localhost",
            )],
            force_destroy=True)
        example_tls_subscription = fastly.TlsSubscription("exampleTlsSubscription",
            domains=example_servicev1.domains.apply(lambda domains: [domain.name for domain in domains]),
            certificate_authority="lets-encrypt")
        demo = aws.route53.get_zone(name=domain_name,
            private_zone=False)
        # Set up DNS record for managed DNS domain validation method
        domain_validation = aws.route53.Record("domainValidation",
            name=example_tls_subscription.managed_dns_challenge["recordName"],
            type=example_tls_subscription.managed_dns_challenge["recordType"],
            zone_id=demo.id,
            allow_overwrite=True,
            records=[example_tls_subscription.managed_dns_challenge["recordValue"]],
            ttl=60)
        # Resource that other resources can depend on if they require the certificate to be issued
        example_tls_subscription_validation = fastly.TlsSubscriptionValidation("exampleTlsSubscriptionValidation", subscription_id=example_tls_subscription.id,
        opts=pulumi.ResourceOptions(depends_on=[domain_validation]))
        ```

        :param str resource_name: The name of the resource.
        :param TlsSubscriptionValidationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsSubscriptionValidationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 subscription_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsSubscriptionValidationArgs.__new__(TlsSubscriptionValidationArgs)

            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
        super(TlsSubscriptionValidation, __self__).__init__(
            'fastly:index/tlsSubscriptionValidation:TlsSubscriptionValidation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            subscription_id: Optional[pulumi.Input[str]] = None) -> 'TlsSubscriptionValidation':
        """
        Get an existing TlsSubscriptionValidation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] subscription_id: The ID of the TLS Subscription that should be validated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsSubscriptionValidationState.__new__(_TlsSubscriptionValidationState)

        __props__.__dict__["subscription_id"] = subscription_id
        return TlsSubscriptionValidation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[str]:
        """
        The ID of the TLS Subscription that should be validated.
        """
        return pulumi.get(self, "subscription_id")

