# AlphaMed

简体中文 | [English](./README_en.md)

AlphaMed 是一个基于区块链技术的去中心化联邦学习解决方案，旨在使医疗机构能够在保证其医疗数据隐私和安全的同时，实现多机构联合建模。医疗机构可以在本地节点实现模型的训练，并支持以匿名的身份将加密的参数共享至聚合节点，从而实现更安全、可信的联邦学习。

相比于传统的联邦学习，AlphaMed 平台不仅能够确保只有合法的且经过许可的参与者才能加入网络，同时支持节点的匿名化的参与联合建模。同时，区块链的共识算法能够确保网络中的节点得到一直的决策，恶意的参与者或者数据投毒等攻击将被拒绝，从而保证了联邦学习更好的安全性。

在联邦学习的过程中，各个参与方都受到智能合约的约束，并且所有的事件、操作都将被记录在区块链的分布式账本上，可追溯、可审计，使得联合机器学习的安全性和隐私保护能力极大的提升。

[开始构建第一个联邦学习任务](./src/alphafed/fed_avg/README.md)

[在不同结构的数据源之间构建异构联邦学习任务](./src/alphafed/hetero_nn/README.md)
