"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_kms_1 = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-sqs');
const dlq = new lib_1.Queue(stack, 'DeadLetterQueue');
const queue = new lib_1.Queue(stack, 'Queue', {
    deadLetterQueue: { queue: dlq, maxReceiveCount: 5 },
    encryption: lib_1.QueueEncryption.KMS_MANAGED,
});
const fifo = new lib_1.Queue(stack, 'FifoQueue', {
    fifo: true,
    encryptionMasterKey: new aws_kms_1.Key(stack, 'EncryptionKey', { removalPolicy: core_1.RemovalPolicy.DESTROY })
});
const role = new aws_iam_1.Role(stack, 'Role', {
    assumedBy: new aws_iam_1.AccountRootPrincipal(),
});
dlq.grantConsumeMessages(role);
queue.grantConsumeMessages(role);
fifo.grantConsumeMessages(role);
new core_1.CfnOutput(stack, 'QueueUrl', { value: queue.queueUrl });
app.synth();
//# sourceMappingURL=data:application/json;base64,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