"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("@aws-cdk/aws-lambda");
const _1 = require(".");
/**
 * Invokes an AWS Lambda function during deployment.
 */
class TriggerFunction extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_triggers_TriggerFunctionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.trigger = new _1.Trigger(this, 'Trigger', {
            ...props,
            handler: this,
        });
    }
    executeAfter(...scopes) {
        this.trigger.executeAfter(...scopes);
    }
    executeBefore(...scopes) {
        this.trigger.executeBefore(...scopes);
    }
}
exports.TriggerFunction = TriggerFunction;
_a = JSII_RTTI_SYMBOL_1;
TriggerFunction[_a] = { fqn: "@aws-cdk/triggers.TriggerFunction", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidHJpZ2dlci1mdW5jdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRyaWdnZXItZnVuY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsOENBQThDO0FBRTlDLHdCQUFzRDtBQVF0RDs7R0FFRztBQUNILE1BQWEsZUFBZ0IsU0FBUSxNQUFNLENBQUMsUUFBUTtJQU9sRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBRXhCLElBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxVQUFPLENBQUMsSUFBSSxFQUFFLFNBQVMsRUFBRTtZQUMxQyxHQUFHLEtBQUs7WUFDUixPQUFPLEVBQUUsSUFBSTtTQUNkLENBQUMsQ0FBQztLQUNKO0lBRU0sWUFBWSxDQUFDLEdBQUcsTUFBbUI7UUFDeEMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsR0FBRyxNQUFNLENBQUMsQ0FBQztLQUN0QztJQUVNLGFBQWEsQ0FBQyxHQUFHLE1BQW1CO1FBQ3pDLElBQUksQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEdBQUcsTUFBTSxDQUFDLENBQUM7S0FDdkM7O0FBdEJILDBDQXVCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSVRyaWdnZXIsIFRyaWdnZXIsIFRyaWdnZXJPcHRpb25zIH0gZnJvbSAnLic7XG5cbi8qKlxuICogUHJvcHMgZm9yIGBJbnZva2VGdW5jdGlvbmAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVHJpZ2dlckZ1bmN0aW9uUHJvcHMgZXh0ZW5kcyBsYW1iZGEuRnVuY3Rpb25Qcm9wcywgVHJpZ2dlck9wdGlvbnMge1xufVxuXG4vKipcbiAqIEludm9rZXMgYW4gQVdTIExhbWJkYSBmdW5jdGlvbiBkdXJpbmcgZGVwbG95bWVudC5cbiAqL1xuZXhwb3J0IGNsYXNzIFRyaWdnZXJGdW5jdGlvbiBleHRlbmRzIGxhbWJkYS5GdW5jdGlvbiBpbXBsZW1lbnRzIElUcmlnZ2VyIHtcblxuICAvKipcbiAgICogVGhlIHVuZGVybHlpbmcgdHJpZ2dlciByZXNvdXJjZS5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSB0cmlnZ2VyOiBUcmlnZ2VyO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBUcmlnZ2VyRnVuY3Rpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgdGhpcy50cmlnZ2VyID0gbmV3IFRyaWdnZXIodGhpcywgJ1RyaWdnZXInLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGhhbmRsZXI6IHRoaXMsXG4gICAgfSk7XG4gIH1cblxuICBwdWJsaWMgZXhlY3V0ZUFmdGVyKC4uLnNjb3BlczogQ29uc3RydWN0W10pOiB2b2lkIHtcbiAgICB0aGlzLnRyaWdnZXIuZXhlY3V0ZUFmdGVyKC4uLnNjb3Blcyk7XG4gIH1cblxuICBwdWJsaWMgZXhlY3V0ZUJlZm9yZSguLi5zY29wZXM6IENvbnN0cnVjdFtdKTogdm9pZCB7XG4gICAgdGhpcy50cmlnZ2VyLmV4ZWN1dGVCZWZvcmUoLi4uc2NvcGVzKTtcbiAgfVxufVxuIl19