# mypy-boto3-cloud9

[![PyPI - mypy-boto3-cloud9](https://img.shields.io/pypi/v/mypy-boto3-cloud9.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloud9)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-cloud9.svg?color=blue)](https://pypi.org/project/mypy-boto3-cloud9)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-cloud9](#mypy-boto3-cloud9)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.Cloud9 1.13.25](https://boto3.amazonaws.com/v1/documentation/api/1.13.25/reference/services/cloud9.html#Cloud9) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-cloud9](#mypy-boto3-cloud9)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `Cloud9` service.

```bash
python -m pip install boto3-stubs[cloud9]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_cloud9` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_cloud9 import Cloud9Client

# Now mypy can check if your code is valid.
client: Cloud9Client = boto3.client("cloud9")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: Cloud9Client = session.client("cloud9")



# Annotated paginators are included as well

import mypy_boto3_cloud9.paginator as cloud9_paginators

describe_environment_memberships_paginator: cloud9_paginators.DescribeEnvironmentMembershipsPaginator = client.get_paginator("describe_environment_memberships")
list_environments_paginator: cloud9_paginators.ListEnvironmentsPaginator = client.get_paginator("list_environments")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_cloud9` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_cloud9 as cloud9
from mypy_boto3_cloud9 import Cloud9Client

# with these
from mypy_boto3 import cloud9
from mypy_boto3.cloud9 import Cloud9Client
```