"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const path = require("path");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
class MessagingResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const MessagingResourceProvider = new cr.Provider(this, 'MessagingResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.messagingCustomResource = new aws_cdk_lib_1.CustomResource(this, 'messagingCustomResource', {
            serviceToken: MessagingResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = cdk.Stack.of(this);
        const constructName = 'MessagingResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const messagingCustomResourceRole = new iam.Role(this, 'messagingCustomResourceRole', {
            description: 'Amazon Chime SDK Messaging Resources',
            assumedBy: new iam.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateAppInstance',
                                'chime:CreateChannelFlow',
                                'chime:DeleteChannelFlow',
                                'chime:DescribeAppInstance',
                                'chime:ListAppInstances',
                                'chime:UpdateAppInstance',
                                'chime:DeleteAppInstance',
                                'chime:CreateAppInstanceUser',
                                'chime:DeleteAppInstanceUser',
                                'chime:ListAppInstanceUsers',
                                'chime:UpdateAppInstanceUser',
                                'chime:DescribeAppInstanceUser',
                                'chime:CreateAppInstanceAdmin',
                                'chime:DescribeAppInstanceAdmin',
                                'chime:ListAppInstanceAdmins',
                                'chime:DeleteAppInstanceAdmin',
                                'chime:PutAppInstanceRetentionSettings',
                                'chime:GetAppInstanceRetentionSettings',
                                'chime:PutAppInstanceStreamingConfigurations',
                                'chime:GetAppInstanceStreamingConfigurations',
                                'chime:DeleteAppInstanceStreamingConfigurations',
                                'chime:TagResource',
                                'chime:UntagResource',
                                'chime:ListTagsForResource',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                    ],
                }),
                ['kinesisPolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:kinesis:${stack.region}:${stack.account}:stream/chime-messaging-*`,
                            ],
                            actions: ['kinesis:DescribeStream'],
                        }),
                    ],
                }),
                ['ssmPolicy']: new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new lambda.Function(stack, constructName, {
            runtime: lambda.Runtime.PYTHON_3_9,
            code: lambda.Code.fromAsset(path.join(__dirname, '../../resources/messaging')),
            handler: 'index.handler',
            architecture: lambda.Architecture.ARM_64,
            role: messagingCustomResourceRole,
            timeout: cdk.Duration.minutes(1),
        });
        return fn;
    }
}
exports.MessagingResources = MessagingResources;
_a = JSII_RTTI_SYMBOL_1;
MessagingResources[_a] = { fqn: "cdk-amazon-chime-resources.MessagingResources", version: "0.1.188" };
//# sourceMappingURL=data:application/json;base64,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