# Generated by Django 3.0.7 on 2020-06-27 16:37

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('pghistory', '0002_aggregateevent'),
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='CustomAggregateEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                (
                    'pgh_table',
                    models.CharField(
                        help_text='The table under which the event is stored',
                        max_length=64,
                    ),
                ),
                (
                    'pgh_data',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text='The raw data of the event row'
                    ),
                ),
                (
                    'pgh_diff',
                    django.contrib.postgres.fields.jsonb.JSONField(
                        help_text='The diff between the previous event and the current event'
                    ),
                ),
                ('url', models.TextField(null=True)),
            ],
            options={'managed': False},
        ),
        migrations.CreateModel(
            name='CustomModel',
            fields=[
                ('my_pk', models.UUIDField(primary_key=True, serialize=False)),
                ('int_field', models.IntegerField(db_column='integer_field')),
            ],
        ),
        migrations.CreateModel(
            name='EventModel',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='SnapshotModel',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                (
                    'fk_field',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name='UniqueConstraintModel',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'my_char_field',
                    models.CharField(max_length=32, unique=True),
                ),
                ('my_int_field1', models.IntegerField(db_index=True)),
                ('my_int_field2', models.IntegerField()),
                (
                    'my_one_to_one',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to='tests.CustomModel',
                    ),
                ),
            ],
            options={'unique_together': {('my_int_field1', 'my_int_field2')}},
        ),
        migrations.CreateModel(
            name='UntrackedModel',
            fields=[
                (
                    'id',
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                ('untracked', models.CharField(max_length=64)),
            ],
        ),
        migrations.CreateModel(
            name='UserGroupsEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('id', models.IntegerField()),
                (
                    'group',
                    models.ForeignKey(
                        db_constraint=False,
                        db_tablespace='',
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to='auth.Group',
                    ),
                ),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        db_constraint=False,
                        db_tablespace='',
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='UniqueConstraintModelEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('my_char_field', models.CharField(max_length=32)),
                ('my_int_field1', models.IntegerField()),
                ('my_int_field2', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'my_one_to_one',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to='tests.CustomModel',
                    ),
                ),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='snapshot',
                        to='tests.UniqueConstraintModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='SnapshotModelSnapshot',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'fk_field',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='snapshot',
                        to='tests.SnapshotModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='SnapshotModelDtFieldIntFieldEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='dt_field_int_field_snapshot',
                        to='tests.SnapshotModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='SnapshotModelDtFieldEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='dt_field_snapshot',
                        to='tests.SnapshotModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='NoPghObjSnapshot',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'fk_field',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='NoPghObjEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='EventModelEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                ('int_field', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='event',
                        to='tests.EventModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='CustomSnapshotModel',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('int_field', models.IntegerField()),
                ('id', models.IntegerField()),
                (
                    'fk_field',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'fk_field2',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        related_query_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='custom_related_name',
                        to='tests.SnapshotModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='CustomModelSnapshot',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('my_pk', models.UUIDField(serialize=False)),
                ('int_field', models.IntegerField(db_column='integer_field')),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='snapshot',
                        to='tests.CustomModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='CustomModelEvent',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('my_pk', models.UUIDField(serialize=False)),
                ('int_field', models.IntegerField(db_column='integer_field')),
                (
                    'pgh_context',
                    models.ForeignKey(
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='pghistory.Context',
                    ),
                ),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        db_constraint=False,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='event',
                        to='tests.CustomModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
        migrations.CreateModel(
            name='CustomEventModel',
            fields=[
                (
                    'pgh_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('pgh_created_at', models.DateTimeField(auto_now_add=True)),
                ('pgh_label', models.TextField(help_text='The event label.')),
                ('dt_field', models.DateTimeField()),
                (
                    'pgh_obj',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='custom_related_name',
                        to='tests.EventModel',
                    ),
                ),
            ],
            options={'abstract': False},
        ),
    ]
