# Isogeo API Python SDK

![PyPI](https://img.shields.io/pypi/v/isogeo-pysdk.svg?style=flat-square) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/isogeo-pysdk?style=flat-square)

[![Build Status](https://dev.azure.com/isogeo/Python%20SDK/_apis/build/status/isogeo.isogeo-api-py-minsdk?branchName=master)](https://dev.azure.com/isogeo/Python%20SDK/_build/latest?definitionId=3&branchName=master)
![Azure DevOps coverage](https://img.shields.io/azure-devops/coverage/isogeo/Python%20SDK/3?style=flat-square)

[![Documentation Status](https://readthedocs.org/projects/isogeo-api-pysdk/badge/?version=latest)](https://isogeo-api-pysdk.readthedocs.io/en/latest/?badge=latest) [![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)

A Python package to use Isogeo REST API.

## Requirements

Isogeo API requires oAuth2 authentication. To obtain credentials, send us your request by email [projects+api@isogeo.com](mailto:projects+api@isogeo.com).

Based on the well known [`requests`](https://github.com/requests/requests) package and the extension [`requests-oauthlib`](https://github.com/requests/requests-oauthlib).

## Documentation

- [Package manual and autogenerated modules doc](https://isogeo-api-pysdk.readthedocs.io)
- [Isogeo API](http://help.isogeo.com/api/)
- [Contribution guidelines (FR)](https://github.com/isogeo/isogeo-api-py-minsdk/wiki/)

## Usage in a nutshell

```powershell
python -m pip install --user isogeo-pysdk
# or using pipenv
python -m pipenv install isogeo-pysdk
```

### Quickstart

```python
from isogeo_pysdk import Isogeo

# authenticate your client application
isogeo = Isogeo(client_id=app_id,
                client_secret=app_secret)

# get the token
isogeo.connect()

# search within catalogs shared to the application
search = isogeo.search()

# print some statements
print("Search query parameters: ", search.query)
print("Total count of metadatas shared: ", search.total)
print("Count of resources got by request: {}\n".format(len(search.results)))

# close the session when you finish
isogeo.close()
```

Samples are available in `the source repository <https://github.com/isogeo/isogeo-api-py-minsdk/tree/master/isogeo_pysdk/samples>`_.

### Tests

Tests are performed for each published commit:

- by [Azure Pipelines](https://dev.azure.com/isogeo/Python%20SDK/_build)

```powershell
python -m pip install --upgrade -r tests/requirements_test.txt
python -m pytest
```

Or using the [included Powershell script](https://github.com/isogeo/isogeo-api-py-minsdk/blob/master/tool_test_coverage.ps1):

```powershell
.\tool_test_coverage.ps1
```

### Build

To package and upload:

```powershell
.\tool_build_upload.ps1
```

To build docs:

```powershell
.\tool_docs_build.ps1
```
